/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.handle;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.CustomizedUnitTreeNodeInfo;
import com.kingdee.eas.ep.LockFactory;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.LockManager;
import com.kingdee.eas.ep.client.depend.FunctionManager;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.figure.IconHelper;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CustomizedUnitTreeBuilder
implements ITreeBuilder {
    private ILNTreeNodeCtrl ctrl;
    private int initalLevel;
    private int expandLevel;
    private List locks = null;
    private boolean isSimpleView = false;
    private FilterInfo filter;
    private SelectorItemCollection selector;

    public CustomizedUnitTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
    }

    public CustomizedUnitTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
    }

    public CustomizedUnitTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.selector = selector;
    }

    public void setSimpleView(boolean isSimpleView) {
        this.isSimpleView = isSimpleView;
    }

    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    private boolean isLocked(String unitID) {
        if (this.locks == null) {
            try {
                this.locks = LockFactory.getRemoteInstance().getLocks();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.locks != null) {
            return this.locks.contains(unitID);
        }
        return false;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(false);
        }
        CustomizedUnitTreeNode rootNode = null;
        rootNode = tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof CustomizedUnitTreeNode ? (CustomizedUnitTreeNode)((Object)tree.getModel().getRoot()) : new CustomizedUnitTreeNode("\u52a8\u6001\u6269\u5c55\u65b9\u6848");
        AbstractObjectCollection col = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof TreeBaseInfo ? this.ctrl.getChildren((TreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter, this.selector) : this.ctrl.getChildren(null, this.initalLevel, this.filter, this.selector);
        tree.setShowsRootHandles(true);
        this.buildChildren(tree, rootNode, col, this.initalLevel);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)((Object)rootNode));
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    CustomizedUnitTreeNode treeNode = (CustomizedUnitTreeNode)((Object)event.getPath().getLastPathComponent());
                    if (CustomizedUnitTreeBuilder.this.filter != null) {
                        CustomizedUnitTreeBuilder.this.getChildren(tree, treeNode, CustomizedUnitTreeBuilder.this.filter);
                    } else {
                        CustomizedUnitTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KDTree tree = (KDTree)e.getSource();
                try {
                    CustomizedUnitTreeNode treeNode = (CustomizedUnitTreeNode)((Object)e.getPath().getLastPathComponent());
                    if (CustomizedUnitTreeBuilder.this.filter != null) {
                        CustomizedUnitTreeBuilder.this.getChildren(tree, treeNode, CustomizedUnitTreeBuilder.this.filter);
                    } else {
                        CustomizedUnitTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private List getWebScheme() throws Exception {
        ArrayList<String> webSchemeList = new ArrayList<String>();
        try {
            String sql = "SELECT FID FROM T_EP_CustomizedScheme WHERE FWEB = 1 ";
            ISQLExecutor iExec = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rows = iExec.executeSQL();
            while (rows.next()) {
                webSchemeList.add(rows.getString("FID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return webSchemeList;
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) throws Exception {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        Iterator iter = col.iterator();
        List webSchemeList = this.getWebScheme();
        String clientName = SysContext.getSysContext().getClientName();
        while (iter.hasNext()) {
            CustomizedUnitTreeNodeInfo treeNodeInfo = (CustomizedUnitTreeNodeInfo)iter.next();
            if (!"WEB_Dev_Debug".equals(clientName) && webSchemeList.contains(treeNodeInfo.getCustomizedSchemeID())) continue;
            NodeTypeEnum type = treeNodeInfo.getNodeType();
            if (this.isSimpleView && (NodeTypeEnum.PERMISSION.equals((Object)type) || NodeTypeEnum.EXCEPTION.equals((Object)type))) continue;
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject((Object)treeNodeInfo);
                continue;
            }
            CustomizedUnitTreeNode treeNode = new CustomizedUnitTreeNode(treeNodeInfo);
            if (!StringUtils.isEmpty((String)treeNodeInfo.getAlias())) {
                treeNode.setText(treeNodeInfo.getAlias());
            }
            if (StringUtils.isEmpty((String)treeNode.getText())) {
                treeNode.setText(treeNodeInfo.getNumber());
            }
            if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)((Object)new CustomizedUnitTreeNode()));
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)((Object)treeNode), (MutableTreeNode)beforeTreeNode, index);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (CustomizedUnitTreeNode)((Object)beforeTreeNode.getParent());
                }
                int index = this.getInsertIndex(beforeTreeNode, treeNode);
                if (treeNodeInfo.getLevel() == 1) {
                    index = beforeTreeNode.getChildCount();
                }
                tree.insertNodeInto((MutableTreeNode)((Object)treeNode), (MutableTreeNode)beforeTreeNode, index);
            }
            beforeTreeNode = treeNode;
            String id = treeNodeInfo.getId().toString();
            treeNode.setNodeType(type);
            if (NodeTypeEnum.ROOT.equals((Object)type)) {
                treeNode.setCustomIcon(FigureHelper.rootIcon);
                treeNode.setSchemeUnitID(id);
                treeNode.setDepend(treeNodeInfo.getDepend());
                continue;
            }
            if (NodeTypeEnum.PERMISSION.equals((Object)type) || NodeTypeEnum.EXCEPTION.equals((Object)type) || NodeTypeEnum.ENUM.equals((Object)type) || NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)type)) {
                treeNode.setUnitID(id);
                treeNode.setSchemeUnitID(((CustomizedUnitTreeNode)((Object)treeNode.getParent())).getSchemeUnitID());
                treeNode.setCustomIcon(IconHelper.getIcon(type));
                if (NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)type)) {
                    this.buildCustomizedUnitNode(treeNode);
                    continue;
                }
                treeNode.setMetadataPK(treeNodeInfo.getMetaDataPK());
                continue;
            }
            if (!NodeTypeEnum.FLODER.equals((Object)type)) continue;
            treeNode.setSchemeUnitID(((CustomizedUnitTreeNode)((Object)treeNode.getParent())).getSchemeUnitID());
        }
        this.setChildrenLockIcon((CustomizedUnitTreeNode)parentNode);
    }

    private int getInsertIndex(KDTreeNode parent, CustomizedUnitTreeNode child) {
        int unitcount = 0;
        int foldcount = 0;
        int othercount = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            KDTreeNode node = (KDTreeNode)parent.getChildAt(i);
            CustomizedUnitTreeNodeInfo info = (CustomizedUnitTreeNodeInfo)node.getUserObject();
            NodeTypeEnum nodeType = info.getNodeType();
            if (NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)nodeType)) {
                ++unitcount;
                continue;
            }
            if (NodeTypeEnum.FLODER.equals((Object)nodeType)) {
                ++foldcount;
                continue;
            }
            if (!NodeTypeEnum.PERMISSION.equals((Object)nodeType) && !NodeTypeEnum.EXCEPTION.equals((Object)nodeType)) continue;
            ++othercount;
        }
        CustomizedUnitTreeNodeInfo userobj = (CustomizedUnitTreeNodeInfo)child.getUserObject();
        NodeTypeEnum type = userobj.getNodeType();
        if (NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)type)) {
            return unitcount;
        }
        if (NodeTypeEnum.FLODER.equals((Object)type)) {
            return unitcount + foldcount;
        }
        if (NodeTypeEnum.PERMISSION.equals((Object)type) || NodeTypeEnum.EXCEPTION.equals((Object)type)) {
            return unitcount + foldcount + othercount;
        }
        return 0;
    }

    public void refreshLockState(CustomizedUnitTreeNode node) {
        this.locks = null;
        this.setChildrenLockIcon(node);
    }

    private void setChildrenLockIcon(CustomizedUnitTreeNode parentNode) {
        this.setLockIcon(parentNode);
        int count = parentNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.setChildrenLockIcon((CustomizedUnitTreeNode)((Object)parentNode.getChildAt(i)));
        }
    }

    private void setLockIcon(CustomizedUnitTreeNode treeNode) {
        for (CustomizedUnitTreeNode parentNode = (CustomizedUnitTreeNode)((Object)treeNode.getParent()); parentNode != null; parentNode = (CustomizedUnitTreeNode)((Object)parentNode.getParent())) {
            if (parentNode.getLockState() != 1 && parentNode.getLockState() != 2) continue;
            treeNode.setLockState(2);
            if (treeNode.getParent() != null) {
                treeNode.setCustomIcon(IconHelper.getIcon(treeNode.getNodeType()));
            }
            return;
        }
        boolean isLocked = this.isLocked(LockManager.getLockPK(treeNode));
        if (isLocked) {
            treeNode.setLockState(1);
            treeNode.setCustomIcon(FigureHelper.lockIcon);
        } else {
            treeNode.setLockState(0);
            if (treeNode.getParent() != null) {
                treeNode.setCustomIcon(IconHelper.getIcon(treeNode.getNodeType()));
            }
        }
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        this.locks = null;
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        this.locks = null;
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildCustomizedUnitNode(CustomizedUnitTreeNode treeNode) {
        if (treeNode != null && NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)treeNode.getNodeType()) && treeNode.getUserObject() instanceof CustomizedUnitInfo) {
            this.buildCustomizedUnitNodeChildren(treeNode);
        }
    }

    private CustomizedUnitTreeNode createFolderNode(CustomizedUnitTreeNode unitNode, NodeTypeEnum type, String txt) {
        CustomizedUnitTreeNode folderNode = new CustomizedUnitTreeNode();
        folderNode.setNodeType(type);
        folderNode.setText(txt);
        folderNode.setCustomIcon(IconHelper.getIcon(type));
        folderNode.setUserObject(unitNode.getUserObject());
        folderNode.setSchemeUnitID(unitNode.getSchemeUnitID());
        folderNode.setUnitID(unitNode.getUnitID());
        unitNode.add((MutableTreeNode)((Object)folderNode));
        return folderNode;
    }

    private void buildCustomizedUnitNodeChildren(CustomizedUnitTreeNode cuNode) {
        if (!this.isSimpleView) {
            this.buildStandCustomizedUnitNodeChildren(cuNode);
        } else {
            this.buildSimpleCustomizedUnitNodeChildren(cuNode);
        }
    }

    private void buildStandCustomizedUnitNodeChildren(CustomizedUnitTreeNode cuNode) {
        List mdList;
        CustomizedUnitTreeNode folderNode;
        CustomizedUnitInfo cuInfo = (CustomizedUnitInfo)cuNode.getUserObject();
        CustomizedUnitNodeInfo cunInfo = CustomizedUnitNodeInfoConverter.converter2Object(cuInfo.getCustomizedUnitObject());
        if (!StringUtils.isEmpty((String)cunInfo.getAlias())) {
            cuNode.setText(cunInfo.getAlias());
        }
        CustomizedUnitTreeNode uiFloderNode = this.createFolderNode(cuNode, NodeTypeEnum.UI_FLODER, "\u754c\u9762");
        if (this.hasUINode(cunInfo)) {
            folderNode = this.createFolderNode(uiFloderNode, NodeTypeEnum.EDITUI_FLODER, "\u7f16\u8f91\u754c\u9762");
            mdList = cunInfo.getUi().getEditui();
            this.buildMDNode(folderNode, mdList, NodeTypeEnum.EDITUI);
            folderNode = this.createFolderNode(uiFloderNode, NodeTypeEnum.LISTUI_FLODER, "\u5217\u8868\u754c\u9762");
            mdList = cunInfo.getUi().getListui();
            this.buildMDNode(folderNode, mdList, NodeTypeEnum.LISTUI);
            folderNode = this.createFolderNode(uiFloderNode, NodeTypeEnum.OTHERUI_FLODER, "\u5176\u5b83\u754c\u9762");
            mdList = cunInfo.getUi().getOtherui();
            this.buildMDNode(folderNode, mdList, NodeTypeEnum.OTHERUI);
        }
        if (FunctionManager.supportWeb()) {
            CustomizedUnitTreeNode webuiFloderNode = this.createFolderNode(cuNode, NodeTypeEnum.WEBUI_FLODER, "Web\u754c\u9762");
            if (this.hasWebUINode(cunInfo)) {
                folderNode = this.createFolderNode(webuiFloderNode, NodeTypeEnum.WEBEDITUI_FLODER, "Web\u7f16\u8f91\u754c\u9762");
                mdList = cunInfo.getWebUi().getEditui();
                this.buildMDNode(folderNode, mdList, NodeTypeEnum.WEBEDITUI);
                folderNode = this.createFolderNode(webuiFloderNode, NodeTypeEnum.WEBLISTUI_FLODER, "Web\u5217\u8868\u754c\u9762");
                mdList = cunInfo.getWebUi().getListui();
                this.buildMDNode(folderNode, mdList, NodeTypeEnum.WEBLISTUI);
            }
        }
        folderNode = this.createFolderNode(cuNode, NodeTypeEnum.QUERY_FLODER, "\u4e1a\u52a1\u6570\u636e\u6e90");
        mdList = cunInfo.getQuery();
        this.buildMDNode(folderNode, mdList, NodeTypeEnum.QUERY);
        folderNode = this.createFolderNode(cuNode, NodeTypeEnum.ENTITY_FLODER, "\u5b9e\u4f53");
        mdList = cunInfo.getEntity();
        this.buildMDNode(folderNode, mdList, NodeTypeEnum.ENTITY);
        folderNode = this.createFolderNode(cuNode, NodeTypeEnum.FUNCTION_FLODER, "\u529f\u80fd");
        mdList = cunInfo.getFunction();
        this.buildMDNode(folderNode, mdList, NodeTypeEnum.FUNCTION);
        folderNode = this.createFolderNode(cuNode, NodeTypeEnum.FACADE_FLODER, "Facade");
        mdList = cunInfo.getFacade();
        this.buildMDNode(folderNode, mdList, NodeTypeEnum.FACADE);
    }

    private boolean hasUINode(CustomizedUnitNodeInfo info) {
        if (info != null && info.getUi() != null) {
            CustomizedUnitNodeInfo.UIInfo ui = info.getUi();
            return ui.getEditui().size() > 0 || ui.getListui().size() > 0 || ui.getOtherui().size() > 0;
        }
        return false;
    }

    private boolean hasWebUINode(CustomizedUnitNodeInfo info) {
        if (info != null && info.getWebUi() != null) {
            CustomizedUnitNodeInfo.WebUIInfo ui = info.getWebUi();
            return ui.getEditui().size() > 0 || ui.getListui().size() > 0 || ui.getOtherui().size() > 0;
        }
        return false;
    }

    private void buildSimpleCustomizedUnitNodeChildren(CustomizedUnitTreeNode cuNode) {
        String alias;
        CustomizedUnitTreeNode leafNode;
        CustomizedUnitInfo cuInfo = (CustomizedUnitInfo)cuNode.getUserObject();
        CustomizedUnitNodeInfo cunInfo = CustomizedUnitNodeInfoConverter.converter2Object(cuInfo.getCustomizedUnitObject());
        if (!StringUtils.isEmpty((String)cunInfo.getAlias())) {
            cuNode.setText(cunInfo.getAlias());
        }
        CustomizedUnitTreeNode folderNode = this.createFolderNode(cuNode, NodeTypeEnum.EDITUI_FLODER, "\u7f16\u8f91\u754c\u9762");
        List list = cunInfo.getUi().getEditui();
        for (CustomizedUnitNodeInfo.MetaDataInfo md : list) {
            leafNode = this.createLeafNode(folderNode, NodeTypeEnum.EDITUI);
            leafNode.setMetadataPK(md.getPackage() + "." + md.getName());
            alias = StringUtils.isEmpty((String)md.getAlias()) ? md.getName() : md.getAlias();
            leafNode.setText(alias + "\u6807\u51c6\u754c\u9762");
            folderNode.add((MutableTreeNode)((Object)leafNode));
            leafNode = this.createLeafNode(folderNode, NodeTypeEnum.EDITUI_SCHEME);
            leafNode.setMetadataPK(md.getPackage() + "." + md.getName());
            alias = StringUtils.isEmpty((String)md.getAlias()) ? md.getName() : md.getAlias();
            leafNode.setText(alias + "\u4e2a\u6027\u5316\u65b9\u6848");
            folderNode.add((MutableTreeNode)((Object)leafNode));
        }
        list = cunInfo.getUi().getListui();
        folderNode = this.createFolderNode(cuNode, NodeTypeEnum.LISTUI_FLODER, "\u5217\u8868\u754c\u9762");
        for (CustomizedUnitNodeInfo.MetaDataInfo md : list) {
            leafNode = this.createLeafNode(folderNode, NodeTypeEnum.LISTUI);
            leafNode.setMetadataPK(md.getPackage() + "." + md.getName());
            alias = StringUtils.isEmpty((String)md.getAlias()) ? md.getName() : md.getAlias();
            leafNode.setText(alias + "\u6807\u51c6\u754c\u9762");
            folderNode.add((MutableTreeNode)((Object)leafNode));
            leafNode = this.createLeafNode(folderNode, NodeTypeEnum.LISTUI_SCHEME);
            leafNode.setMetadataPK(md.getPackage() + "." + md.getName());
            alias = StringUtils.isEmpty((String)md.getAlias()) ? md.getName() : md.getAlias();
            leafNode.setText(alias + "\u4e2a\u6027\u5316\u65b9\u6848");
            folderNode.add((MutableTreeNode)((Object)leafNode));
        }
    }

    private void buildMDNode(CustomizedUnitTreeNode folderNode, List mdList, NodeTypeEnum type) {
        for (CustomizedUnitNodeInfo.MetaDataInfo md : mdList) {
            CustomizedUnitTreeNode childNode = this.createLeafNode(folderNode, type);
            childNode.setText(StringUtils.isEmpty((String)md.getAlias()) ? md.getName() : md.getAlias());
            childNode.setMetadataPK(md.getPackage() + "." + md.getName());
            folderNode.add((MutableTreeNode)((Object)childNode));
        }
    }

    private CustomizedUnitTreeNode createLeafNode(CustomizedUnitTreeNode folderNode, NodeTypeEnum type) {
        CustomizedUnitTreeNode childNode = new CustomizedUnitTreeNode();
        childNode.setNodeType(type);
        childNode.setUserObject(folderNode.getUserObject());
        childNode.setSchemeUnitID(folderNode.getSchemeUnitID());
        childNode.setUnitID(folderNode.getUnitID());
        return childNode;
    }
}

