/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.handle;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ep.CustomizedUnitTreeNodeInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.util.FilterUtility;
import java.util.List;

public class CustomizedUnitTreeNodeCtrl
implements ILNTreeNodeCtrl {
    private ICustomizedUnit treeCtrl;

    public CustomizedUnitTreeNodeCtrl(ICustomizedUnit iTreeBase) {
        this.treeCtrl = iTreeBase;
    }

    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level) throws Exception {
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level, null, null);
        List nodes = this.treeCtrl.getUnitNodes(viewInfo);
        return this.toCollection(nodes);
    }

    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws Exception {
        return this.getChildren(parentNodeInfo, level, filter, null);
    }

    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection selector) throws Exception {
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level, filter, selector);
        List nodes = this.treeCtrl.getUnitNodes(viewInfo);
        return this.toCollection(nodes);
    }

    private CoreBaseCollection toCollection(List nodes) {
        CoreBaseCollection col = new CoreBaseCollection();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            CustomizedUnitTreeNodeInfo node = (CustomizedUnitTreeNodeInfo)nodes.get(i);
            col.add((CoreBaseInfo)node);
        }
        return col;
    }

    private EntityViewInfo getViewInfo(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection selector) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "!%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel()), CompareType.GREATER_EQUALS));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel() + level), CompareType.LESS_EQUALS));
        } else {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level), CompareType.LESS_EQUALS));
        }
        if (parentNodeInfo != null && FilterUtility.hasFilterItem((FilterInfo)filter)) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        if (selector != null) {
            for (int i = 0; i < selector.size(); ++i) {
                viewInfo.getSelector().add(selector.get(i));
            }
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
        }
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        return viewInfo;
    }
}

