/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model;

import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import java.util.ArrayList;

public class AllComponentInfoArr {
    public static final int ALL = 1;
    public static final int TAB_INDEX = 2;
    private AbstractUIObjectInfo uiModel;
    private ArrayList componentInfoArr = null;

    public AllComponentInfoArr(AbstractUIObjectInfo uiModel) {
        assert (uiModel != null);
        this.uiModel = uiModel;
        this.componentInfoArr = this.getAllWidgets(uiModel.getComponents());
    }

    public AllComponentInfoArr(int style) {
        if (style == 1) {
            this.componentInfoArr = this.getAllWidgets(this.uiModel.getComponents());
        } else if (style == 2) {
            this.componentInfoArr = this.getAllTabIndexWidgets(this.uiModel.getComponents());
        }
    }

    public ArrayList getComponentInfoArr() {
        return this.componentInfoArr;
    }

    private ArrayList getAllWidgets(ComponentCollection componentCollection) {
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (!EditUIEditorHelper.canBind(componentInfo) && !(this.uiModel instanceof WebUIObjectInfo) || this.isBinded(componentInfo)) continue;
            result.add(componentInfo);
        }
        return result;
    }

    private boolean isBinded(ComponentInfo componentInfo) {
        if (componentInfo != null && componentInfo.getPropertyBindings() != null && componentInfo.isConfigured()) {
            PropertyBindingCollection pbc = componentInfo.getPropertyBindings();
            if (componentInfo.getClassType().equals("com.kingdee.bos.ctrl.kdf.table.KDTable")) {
                PropertyInfo property = componentInfo.getProperties().get("formatXml");
                if (property != null) {
                    TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
                    String[] nameList = tableInfo.getColumnNameList();
                    for (int i = 0; i < nameList.length; ++i) {
                        if (!((ColumnInfo)tableInfo.getColumns().get(i)).isConfigured() || pbc.get(nameList[i] + ".text") != null) continue;
                        return false;
                    }
                }
            } else {
                for (int i = 0; i < pbc.size(); ++i) {
                    String name = pbc.get(i).getPropertyName();
                    if ("toolTipText".equals(name) || "enabled".equals(name) || "visible".equals(name) || "userobject".equals(name)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private ArrayList getAllTabIndexWidgets(ComponentCollection componentCollection) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (EditUIEditorHelper.canBind(componentInfo) || this.uiModel instanceof WebUIObjectInfo) {
                result.add(componentInfo);
            }
            if (!componentInfo.isContainer()) continue;
            ArrayList subResult = this.getAllTabIndexWidgets(componentInfo.getComponents());
            for (int j = 0; j < subResult.size(); ++j) {
                result.add(subResult.get(j));
            }
        }
        return result;
    }
}

