/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.model.IPropertyInfo;
import com.kingdee.eas.ep.client.util.EntityEditorHelper;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PropertyInfoProxy
implements IPropertyInfo {
    private static final Logger logger = Logger.getLogger(PropertyInfoProxy.class);
    public static final String DATA_SOURCE_TYPE = "DataSourceType";
    private EntityObjectInfo entity;
    private PropertyInfo pInfo;
    private String name;
    private String alias;
    private int length;
    private int precision;
    private int scale;
    private String defaultValue;
    private boolean isMultiLanguage;
    private boolean isConfigured;
    private BizDataTypeEnum dataType;
    private DataSourceEnum dataSourceType;
    private EntityObjectInfo dataSource;
    private String enumPK;
    private ColumnInfo mappingField;
    private Project depend;

    public PropertyInfoProxy(EntityObjectInfo entity) {
        assert (entity != null);
        this.entity = entity;
    }

    public PropertyInfoProxy(EntityObjectInfo entity, PropertyInfo pInfo) {
        assert (entity != null);
        this.entity = entity;
        this.pInfo = pInfo;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    public void setEntity(EntityObjectInfo entity) {
        assert (entity != null);
        this.entity = entity;
    }

    public PropertyInfo getPropertyInfo() {
        return this.pInfo;
    }

    public void setPropertyInfo(PropertyInfo info) {
        this.pInfo = info;
    }

    public String getName() {
        return this.name;
    }

    public void setDepend(Project depend) {
        this.depend = depend;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnInfo getMappingField() {
        return this.mappingField;
    }

    public void setMappingField(ColumnInfo mappingField) {
        this.mappingField = mappingField;
    }

    public BizEnumInfo getEnumType() {
        return UictUtils.loadBizEnum((IMetaDataPK)MetaDataPK.create((String)this.enumPK), this.depend);
    }

    @Override
    public void setEnumPK(String enumpk) {
        this.enumPK = enumpk;
    }

    public DataSourceEnum getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceEnum dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public EntityObjectInfo getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(EntityObjectInfo dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isMultiLanguage() {
        return this.isMultiLanguage;
    }

    public void setMultiLanguage(boolean isMultiLanguage) {
        this.isMultiLanguage = isMultiLanguage;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this.isConfigured = isConfigured;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public BizDataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(BizDataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public void syn2Proxy() {
        if (this.pInfo != null) {
            this.setName(this.pInfo.getName());
            this.setAlias(this.pInfo.getAlias());
            this.setMappingField(this.pInfo.getMappingField());
            this.setConfigured(this.pInfo.isConfigured());
            if (this.pInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo own = (OwnPropertyInfo)this.pInfo;
                this.setDataType(EntityEditorHelper.getDataTypeAlias(this.pInfo));
                this.setLength(own.getLength());
                this.setScale(own.getDecimalDigits());
                this.setPrecision(own.getPrecision());
                this.setMultiLanguage(own.isMultilingual());
                if (BizDataTypeEnum.ENUM.equals((Object)this.getDataType())) {
                    this.setEnumPK(own.getMetaDataRef());
                }
                if (!StringUtils.isEmpty((String)own.getExtendedProperty(DATA_SOURCE_TYPE))) {
                    this.setDataSourceType(EntityEditorHelper.getDataSourceType(DataSourceType.getEnum((String)own.getExtendedProperty(DATA_SOURCE_TYPE))));
                }
                if (this.getDataSourceType() == null) {
                    if (BizDataTypeEnum.ENUM.equals((Object)this.getDataType())) {
                        this.setDataSourceType(DataSourceEnum.LIST);
                    } else {
                        this.setDataSourceType(DataSourceEnum.SELF);
                    }
                }
            } else if (this.pInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo link = (LinkPropertyInfo)this.pInfo;
                RelationshipInfo relation = link.getRelationship();
                this.setDataType(EntityEditorHelper.getDataTypeAlias(this.pInfo));
                if (CardinalityType.ONE.equals((Object)relation.getSupplierCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relation.getSupplierCardinality())) {
                    this.setDataSourceType(DataSourceEnum.BASEDATA);
                    EntityObjectInfo entity = relation.getSupplierObject();
                    this.setDataSource(entity);
                }
            }
        }
    }

    public void syn2Property() {
        if (BizDataTypeEnum.OBJECT.equals((Object)this.getDataType()) && this.getDataSource() != null) {
            LinkPropertyInfo lkprop = this.createLinkProperty((LinkPropertyInfo)this.pInfo);
            if (lkprop != null) {
                lkprop.setConfigured(true);
            }
            this.pInfo = lkprop;
        } else {
            OwnPropertyInfo ownprop = this.createOwnProperty((OwnPropertyInfo)this.pInfo);
            if (ownprop != null) {
                ownprop.setConfigured(true);
            }
            this.pInfo = ownprop;
        }
    }

    private LinkPropertyInfo createLinkProperty(LinkPropertyInfo linkprop) {
        if (linkprop == null) {
            linkprop = new LinkPropertyInfo();
        }
        linkprop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop.setName(this.getName());
        MutiLanUtil.setAlias(linkprop, this.getAlias());
        linkprop.setMappingField(this.getMappingField());
        linkprop.setConfigured(this.isConfigured());
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(this.entity.getPackage());
        String relationName = "R_" + this.entity.getName() + "_" + this.getDataSource().getName() + "_" + this.getName();
        relation.setName(relationName);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setClientObject(this.entity);
        relation.setSupplierObject(this.getDataSource());
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop.setRelationship(relation);
        EntityViewInfo defaultView = this.entity.getDefaultView();
        if (defaultView == null) {
            defaultView = new EntityViewInfo();
            this.entity.setDefaultView(defaultView);
        }
        linkprop.setExtendedProperty("isForMapping", "false");
        linkprop.setExtendedProperty("isForGrouping", "false");
        linkprop.setExtendedProperty("isForMatching", "false");
        linkprop.setExtendedProperty("isForWrittenBack", "false");
        String dynExtendPropertyList = linkprop.getExtendedProperty("dynExtendPropertyList") + "|isForMapping|isForGrouping|isForMatching|isForWrittenBack";
        linkprop.setExtendedProperty("dynExtendPropertyList", dynExtendPropertyList);
        return linkprop;
    }

    private OwnPropertyInfo createOwnProperty(OwnPropertyInfo prop) {
        String dynExtendPropertyList;
        if (prop == null) {
            prop = new OwnPropertyInfo();
        }
        prop.setName(this.getName());
        MutiLanUtil.setAlias(prop, this.getAlias());
        prop.setDataType(EntityEditorHelper.getPropertyType(this.getDataType()));
        if (this.getDataType().equals((Object)BizDataTypeEnum.ENUM)) {
            BizEnumInfo bizenum = this.getEnumType();
            if (bizenum == null) {
                logger.error((Object)"!!!!!  bizData has enum type, but without enum info");
                return null;
            }
            prop.setMetadataRef(bizenum.getFullName());
        }
        prop.setLength(this.getLength());
        prop.setPrecision(this.getPrecision());
        prop.setDecimalDigits(this.getScale());
        prop.setMappingField(this.getMappingField());
        prop.setMultilingual(this.isMultiLanguage());
        if (this.getDefaultValue() != null) {
            prop.setDefaultValue(this.getDefaultValue());
        }
        if (this.getDataSourceType() != null && this.getDataSourceType().equals((Object)DataSourceEnum.BASEDATAEXT)) {
            prop.getExtendedProperties().put(DATA_SOURCE_TYPE, EntityEditorHelper.getDataSourceType(this.getDataSourceType()).getName());
        }
        if (this.getDataSourceType() != null && (this.getDataSourceType().equals((Object)DataSourceEnum.SELF) || this.getDataSourceType().equals((Object)DataSourceEnum.LIST))) {
            prop.setExtendedProperty("isInCode", "true");
            dynExtendPropertyList = prop.getExtendedProperty("dynExtendPropertyList") + "|isInCode";
            prop.setExtendedProperty("dynExtendPropertyList", dynExtendPropertyList);
        }
        prop.setExtendedProperty("isForMapping", "false");
        prop.setExtendedProperty("isForGrouping", "false");
        prop.setExtendedProperty("isForMatching", "false");
        prop.setExtendedProperty("isForWrittenBack", "false");
        dynExtendPropertyList = prop.getExtendedProperty("dynExtendPropertyList") + "|isForMapping|isForGrouping|isForMatching|isForWrittenBack";
        prop.setExtendedProperty("dynExtendPropertyList", dynExtendPropertyList);
        prop.setExtendedProperty("enableFieldPermission", String.valueOf(true));
        dynExtendPropertyList = prop.getExtendedProperty("dynExtendPropertyList") + "|enableFieldPermission";
        prop.setExtendedProperty("dynExtendPropertyList", dynExtendPropertyList);
        return prop;
    }
}

