/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.dtc;

import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.eas.ep.client.model.dtc.ControlStaticInfo;
import com.kingdee.eas.ep.client.model.dtc.DTControlEventInfo;
import com.kingdee.eas.ep.client.model.dtc.DTControlPropertyInfo;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class ComponentHelper
implements Serializable {
    private String className;
    private DTControlPropertyInfo[] propInfos;
    private DTControlEventInfo[] eventInfos;
    public static final String CONSTAINTS = "constraint";
    public static final String NAME = "name";
    public static final String LAYOUT = "layout";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.uidesigner.model.ComponentHelper");

    public ComponentHelper(String className, DTControlPropertyInfo[] propInfos, DTControlEventInfo[] eventInfos) {
        this.className = className;
        this.propInfos = propInfos;
        this.eventInfos = eventInfos;
    }

    public ComponentHelper(String className) {
        this.className = className;
        this.propInfos = null;
        this.eventInfos = null;
    }

    public PropertyCollection getPropertyCollection() {
        if (this.propInfos == null) {
            return this.getRTCPropertyCollection();
        }
        return this.getDTCPropertyCollection();
    }

    public void doPropertyDescriptors(ControlStaticInfo conStaticInfo, boolean isContainer, boolean isVisual) {
        if (this.propInfos != null) {
            this.doDTCPropertyDescriptors(conStaticInfo, isContainer, isVisual);
        }
    }

    public boolean isContainer(String className) {
        try {
            Object obj = Class.forName(className).newInstance();
            return obj instanceof JPanel || obj instanceof JMenuBar || obj instanceof JToolBar;
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
            return false;
        }
    }

    public boolean isVisual(String className) {
        try {
            Object obj = Class.forName(className).newInstance();
            return !(obj instanceof ButtonGroup);
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
            return true;
        }
    }

    private void doDTCPropertyDescriptors(ControlStaticInfo conStaticInfo, boolean isContainer, boolean isVisual) {
        if (this.propInfos == null) {
            return;
        }
        for (int i = 0; i < this.propInfos.length; ++i) {
            if (NAME.equals(this.propInfos[i].getName()) || LAYOUT.equals(this.propInfos[i].getName()) || CONSTAINTS.equals(this.propInfos[i].getName())) continue;
            ControlStaticInfo.PropertyStaticInfo info = new ControlStaticInfo.PropertyStaticInfo();
            conStaticInfo.setPropStaticInfo(this.propInfos[i].getName(), info);
            this.fillPropStaticInfo(this.propInfos[i], info);
        }
    }

    private void fillPropStaticInfo(DTControlPropertyInfo info, ControlStaticInfo.PropertyStaticInfo propStaticInfo) {
        propStaticInfo.setDefaultValue(info.getDefaultValue());
        propStaticInfo.setMultiLan(info.isMultiLan());
        propStaticInfo.setType(info.getType());
        propStaticInfo.setDirectSet(info.canDirectSet());
        propStaticInfo.setBindData(info.canBindData());
        propStaticInfo.setGroup(info.getGroup());
        propStaticInfo.setEnableEL(info.isEnableEL());
    }

    private PropertyCollection getRTCPropertyCollection() {
        PropertyCollection collection = new PropertyCollection();
        return collection;
    }

    private PropertyCollection getDTCPropertyCollection() {
        PropertyCollection collection = new PropertyCollection();
        if (this.propInfos == null) {
            return collection;
        }
        for (int i = 0; i < this.propInfos.length; ++i) {
            collection.add(this.getPropertyInfo(this.propInfos[i]));
        }
        return collection;
    }

    private PropertyInfo getPropertyInfo(DTControlPropertyInfo info) {
        PropertyInfo property = new PropertyInfo();
        property.setName(info.getName());
        property.setType(info.getType());
        property.setMultiLanguage(info.isMultiLan());
        return property;
    }
}

