/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.dtc;

import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigGroupInfo;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigInfo;
import com.kingdee.util.SAXBuilderFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DTCConfigManager {
    private static DTCConfigManager dtcConfigManager = null;
    private String configFile = "DTCConfig.xml";
    private String extConfigFile = "DTCConfig_Ext.xml";
    private Hashtable dtcConfigMap = new Hashtable();
    private List dtcConfigGroupList = new ArrayList();
    private Element root;
    private Element extRoot;
    private static SAXBuilder sb = SAXBuilderFactory.create();
    private static SAXBuilder extSb = SAXBuilderFactory.create();
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.uidesigner.dtc.DTCConfigManager");

    private DTCConfigManager() {
        this.initDTCConfigMap();
    }

    private void initDTCConfigMap() {
        try {
            URL url = DTCConfigManager.class.getResource(this.configFile);
            Document doc = sb.build(url.openStream());
            this.root = doc.getRootElement();
            if (this.root == null) {
                return;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
            return;
        }
        this.assembleExtDtc();
        List children = this.root.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (!"group".equalsIgnoreCase(itemname)) continue;
            this.addDTCConfigGroup(item.getAttributeValue("name"), item);
        }
    }

    private void assembleExtDtc() {
        try {
            URL url = DTCConfigManager.class.getResource(this.extConfigFile);
            Document doc = extSb.build(url.openStream());
            this.extRoot = doc.getRootElement();
            if (this.extRoot == null) {
                return;
            }
            List children = this.extRoot.getChildren();
            for (Element item : children) {
                String itemname = item.getName();
                if (!"group".equalsIgnoreCase(itemname)) continue;
                this.root.addContent((Content)item.clone());
            }
        }
        catch (Exception ex) {
            logger.info((Object)"ext dtc is not found!");
        }
    }

    private void addDTCConfigGroup(String groupName, Element groupItem) {
        List children = groupItem.getChildren();
        DTCConfigGroupInfo dtcConfigGroup = new DTCConfigGroupInfo(groupName);
        if (groupItem.getAttributeValue("type") != null) {
            dtcConfigGroup.setType(groupItem.getAttributeValue("type"));
        }
        for (Element item : children) {
            String isExt;
            String itemname = item.getName();
            if (!"control".equalsIgnoreCase(itemname)) continue;
            DTCConfigInfo model = new DTCConfigInfo();
            model.controlName = item.getAttributeValue("name");
            model.controlType = item.getAttributeValue("type");
            model.dtcConfig = item.getAttributeValue("dtcConfig");
            model.figure = item.getAttributeValue("figure");
            model.smallIconName = item.getAttributeValue("smallicon");
            model.largeIconName = item.getAttributeValue("largeicon");
            model.description = item.getAttributeValue("description");
            model.setSmallIcon(FigureHelper.getImageIcon(model.smallIconName));
            model.setLargeIcon(FigureHelper.getImageIcon(model.largeIconName));
            String isVisible = item.getAttributeValue("isVisible");
            if (isVisible != null && "false".equalsIgnoreCase(isVisible)) {
                model.isVisible = false;
            }
            if ((isExt = item.getAttributeValue("isExt")) != null && "true".equalsIgnoreCase(isExt)) {
                model.isExt = true;
            }
            model.initializerClass = item.getAttributeValue("initializerClass");
            this.dtcConfigMap.put(model.controlType, model);
            dtcConfigGroup.getDTCConfigList().add(model);
        }
        this.dtcConfigGroupList.add(dtcConfigGroup);
    }

    public List getDTCConfigGroupList() {
        return this.dtcConfigGroupList;
    }

    public Map getDTCConfigMap() {
        return this.dtcConfigMap;
    }

    public DTCConfigInfo getDTCConfig(String controlType) {
        return (DTCConfigInfo)this.dtcConfigMap.get(controlType);
    }

    public static DTCConfigManager getInstance() {
        if (dtcConfigManager == null) {
            dtcConfigManager = new DTCConfigManager();
        }
        return dtcConfigManager;
    }
}

