/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.dtc;

import com.kingdee.eas.ep.client.model.dtc.DTCConfigManager;
import com.kingdee.eas.ep.client.model.dtc.DTControlEventInfo;
import com.kingdee.eas.ep.client.model.dtc.DTControlPropertyInfo;
import com.kingdee.eas.ep.client.model.dtc.WidgetTools;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.StringUtils;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DTCHandler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.uidesigner.dtc.DTCHandler");
    private static SAXBuilder sb = SAXBuilderFactory.create();
    private static SAXBuilder extSb = SAXBuilderFactory.create();
    private String xmlFile;
    private Element root;
    private String defaultEventName = null;

    public DTCHandler(String xmlFileName) {
        this.xmlFile = "dtcConfig/" + xmlFileName;
        this.initialize();
    }

    public DTControlPropertyInfo[] getPropertyInfo() {
        return WidgetTools.getPropertyInfos(this.root);
    }

    public DTControlEventInfo[] getEventInfo() {
        Object[] eventNames = new Object[1];
        DTControlEventInfo[] infos = WidgetTools.getEventInfos(this.root, eventNames);
        this.defaultEventName = (String)eventNames[0];
        return infos;
    }

    public String getDefaultEventName() {
        return this.defaultEventName;
    }

    public boolean isContainer() {
        return WidgetTools.isContainer(this.root);
    }

    public boolean isVisual() {
        return WidgetTools.isVisual(this.root);
    }

    private void initialize() {
        try {
            URL url = DTCConfigManager.class.getResource(this.xmlFile);
            Document doc = sb.build(url.openStream());
            this.root = doc.getRootElement();
            this.assembleExtDtc();
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
    }

    private void assembleExtDtc() {
        if (!StringUtils.isEmpty((String)this.xmlFile) && this.xmlFile.endsWith(".con")) {
            String ext = this.xmlFile.substring(0, this.xmlFile.length() - 4) + "_Ext.con";
            try {
                Element element;
                int i;
                List list;
                URL url = DTCConfigManager.class.getResource(ext);
                Document doc = extSb.build(url.openStream());
                Element extRoot = doc.getRootElement();
                Element originalProperties = WidgetTools.getPropertysElement(this.root);
                Element originalEvents = WidgetTools.getEventsElement(this.root);
                Element extProperties = WidgetTools.getPropertysElement(extRoot);
                Element extEvents = WidgetTools.getEventsElement(extRoot);
                if (originalProperties != null && extProperties != null) {
                    list = extProperties.getChildren();
                    for (i = 0; i < list.size(); ++i) {
                        element = (Element)list.get(i);
                        originalProperties.addContent((Content)element.clone());
                    }
                }
                if (originalEvents != null && extEvents != null) {
                    list = extEvents.getChildren();
                    for (i = 0; i < list.size(); ++i) {
                        element = (Element)list.get(i);
                        originalEvents.addContent((Content)element.clone());
                    }
                }
            }
            catch (FileNotFoundException fe) {
                logger.info((Object)("ext dtc[" + ext + "] is not exist"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

