/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.dtc;

import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.dtc.ComponentHelper;
import com.kingdee.eas.ep.client.model.dtc.ControlStaticInfo;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigInfo;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigManager;
import com.kingdee.eas.ep.client.model.dtc.DTCHandler;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Logger;

public class DTControlHelper {
    private static Hashtable propCollectionMap = new Hashtable();
    private static Hashtable controlStaticInfoMap = new Hashtable();
    private static Hashtable isContainerMap = new Hashtable();
    private static Hashtable isVisualMap = new Hashtable();
    private static Set isEditableSet = new HashSet();
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.uidesigner.model.dtc.DTControlHelper");

    private DTControlHelper() {
    }

    public static PropertyCollection getPropertyCollection(String className) {
        Object obj = propCollectionMap.get(className);
        if (obj == null || !(obj instanceof PropertyCollection)) {
            if (!DTControlHelper.dtInitialize(className)) {
                PropertyCollection collection = new ComponentHelper(className).getPropertyCollection();
                propCollectionMap.put(className, collection);
                return (PropertyCollection)collection.clone();
            }
            obj = propCollectionMap.get(className);
        }
        return (PropertyCollection)((PropertyCollection)obj).clone();
    }

    public static Object setPropertyCollection(String className, PropertyCollection collection) {
        if (collection == null || className == null) {
            return null;
        }
        return propCollectionMap.put(className, collection);
    }

    public static ControlStaticInfo getControlStaticInfo(String className) {
        Object obj = controlStaticInfoMap.get(className);
        if (obj == null || !(obj instanceof ControlStaticInfo)) {
            if (!DTControlHelper.dtInitialize(className)) {
                ControlStaticInfo staticInfo = new ControlStaticInfo();
                controlStaticInfoMap.put(className, staticInfo);
                return staticInfo;
            }
            obj = controlStaticInfoMap.get(className);
        }
        return (ControlStaticInfo)obj;
    }

    public static boolean isContainer(String className) {
        Object obj = isContainerMap.get(className);
        if (obj == null) {
            if (!DTControlHelper.dtInitialize(className)) {
                boolean container = new ComponentHelper(className).isContainer(className);
                isContainerMap.put(className, new Boolean(container));
                return container;
            }
            obj = isContainerMap.get(className);
        }
        return (Boolean)obj;
    }

    public static boolean isVisual(String className) {
        Object obj = isVisualMap.get(className);
        if (obj == null) {
            if (!DTControlHelper.dtInitialize(className)) {
                boolean visual = new ComponentHelper(className).isVisual(className);
                isVisualMap.put(className, new Boolean(visual));
                return visual;
            }
            obj = isVisualMap.get(className);
        }
        return (Boolean)obj;
    }

    public static boolean isEditable(String className) {
        if (isEditableSet.isEmpty()) {
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDCheckBox");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDTextField");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDFormattedTextField");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDPasswordField");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDTextArea");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDList");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDComboBox");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDSpinner");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDTree");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDEditorPane");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDSlider");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDTextPane");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDDatePicker");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDTimePicker");
            isEditableSet.add("com.kingdee.bos.ctrl.kdf.table.KDTable");
            isEditableSet.add("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
            isEditableSet.add("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox");
            isEditableSet.add("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDBusiMaskField");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDBusiCurrencyField");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDNumberTextField");
            isEditableSet.add("com.kingdee.bos.ctrl.swing.KDComboColor");
            isEditableSet.add("com.kingdee.bos.ctrl.web.TextField");
            isEditableSet.add("com.kingdee.bos.ctrl.web.TextArea");
            isEditableSet.add("com.kingdee.bos.ctrl.web.ComboBox");
        }
        return isEditableSet.contains(className);
    }

    private static boolean dtInitialize(String className) {
        try {
            DTCConfigInfo dtc = DTCConfigManager.getInstance().getDTCConfig(className);
            if (dtc != null) {
                DTCHandler handler = new DTCHandler(dtc.dtcConfig);
                isContainerMap.put(className, new Boolean(handler.isContainer()));
                isVisualMap.put(className, new Boolean(handler.isVisual()));
                ComponentHelper helper = new ComponentHelper(className, handler.getPropertyInfo(), handler.getEventInfo());
                Object obj = controlStaticInfoMap.get(className);
                if (obj == null || !(obj instanceof ControlStaticInfo)) {
                    ControlStaticInfo staticInfo = new ControlStaticInfo();
                    helper.doPropertyDescriptors(staticInfo, handler.isContainer(), handler.isVisual());
                    controlStaticInfoMap.put(className, staticInfo);
                    DTControlHelper.setPropertyCollection(className, helper.getPropertyCollection());
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionHandler.handleError(null, ex, "\u63a7\u4ef6\u6ce8\u518c\u9519\u8bef");
            return false;
        }
    }
}

