/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.dtc;

import com.kingdee.eas.ep.client.model.dtc.DTControlEventInfo;
import com.kingdee.eas.ep.client.model.dtc.DTControlPropertyInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class WidgetTools {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.uidesigner.model.dtc.WidgetTools");
    Element root;

    private WidgetTools() {
    }

    public static DTControlPropertyInfo[] getPropertyInfos(Element root) {
        Element elementProperties = root.getChild("Properties");
        List propertyList = elementProperties.getChildren();
        DTControlPropertyInfo[] pInfos = new DTControlPropertyInfo[propertyList.size()];
        for (int i = 0; i < propertyList.size(); ++i) {
            DTControlPropertyInfo pInfo;
            Element property = (Element)propertyList.get(i);
            pInfos[i] = pInfo = WidgetTools.getPropertyInfo(property);
        }
        return pInfos;
    }

    public static DTControlPropertyInfo getPropertyInfo(Element property) {
        Element isMultiLan;
        Element defaultValue;
        Element enableEL;
        Element canBindData;
        Element canDirectSet;
        if (property == null) {
            return null;
        }
        Element name = property.getChild("name");
        Element type = property.getChild("type");
        DTControlPropertyInfo pInfo = new DTControlPropertyInfo(name.getText(), type.getText());
        Element group = property.getChild("group");
        if (group != null && group.getText() != null && group.getText().trim().length() > 0) {
            pInfo.setGroup(group.getText());
        }
        if ((canDirectSet = property.getChild("canDirectSet")) != null && canDirectSet.getText() != null && canDirectSet.getText().trim().length() > 0 && "false".equalsIgnoreCase(canDirectSet.getTextTrim())) {
            pInfo.setDirectSet(false);
        }
        if ((canBindData = property.getChild("canBindData")) != null && canBindData.getText() != null && canBindData.getText().trim().length() > 0 && "false".equalsIgnoreCase(canBindData.getTextTrim())) {
            pInfo.setBindData(false);
        }
        if ((enableEL = property.getChild("enableEL")) != null && enableEL.getText() != null && enableEL.getText().trim().length() > 0 && "true".equalsIgnoreCase(enableEL.getTextTrim())) {
            pInfo.setEnableEL(true);
        }
        if ((defaultValue = property.getChild("defaultValue")).getText() != null && defaultValue.getText().trim().length() > 0) {
            pInfo.setDefaultValue(defaultValue.getText());
        }
        if ((isMultiLan = property.getChild("isMultiLan")) != null) {
            if (isMultiLan.getText() != null && isMultiLan.getText().trim().length() > 0) {
                pInfo.setMultiLan(Boolean.valueOf(isMultiLan.getText().trim()));
            } else {
                pInfo.setMultiLan(false);
            }
        } else {
            pInfo.setMultiLan(false);
        }
        Element isExt = property.getChild("isExt");
        if (isExt != null) {
            if (!StringUtils.isEmpty((String)isExt.getText())) {
                pInfo.setExt(Boolean.valueOf(isExt.getText().trim()));
            } else {
                pInfo.setExt(false);
            }
        } else {
            pInfo.setExt(false);
        }
        Element editorType = property.getChild("editorType");
        if (editorType.getText() != null && editorType.getText().trim().length() > 0) {
            pInfo.setEditorType(Integer.parseInt(editorType.getText().trim()));
        } else {
            pInfo.setEditorType(0);
        }
        return pInfo;
    }

    public static Element getPropertyElement(DTControlPropertyInfo info) {
        if (info == null) {
            return null;
        }
        Element property = new Element("Propertie");
        Element name = new Element("name");
        name.setText(info.getName());
        property.addContent((Content)name);
        Element type = new Element("type");
        type.setText(info.getType());
        property.addContent((Content)type);
        Element group = new Element("group");
        group.setText(info.getGroup());
        property.addContent((Content)group);
        Element canDirectSet = new Element("canDirectSet");
        canDirectSet.setText(String.valueOf(info.canDirectSet()));
        property.addContent((Content)canDirectSet);
        Element canBindData = new Element("canBindData");
        canBindData.setText(String.valueOf(info.canBindData()));
        property.addContent((Content)canBindData);
        Element enableEL = new Element("enableEL");
        enableEL.setText(String.valueOf(info.isEnableEL()));
        property.addContent((Content)enableEL);
        Element defaultValue = new Element("defaultValue");
        defaultValue.setText(info.getDefaultValue());
        property.addContent((Content)defaultValue);
        Element isMultiLan = new Element("isMultiLan");
        isMultiLan.setText(String.valueOf(info.isMultiLan()));
        property.addContent((Content)isMultiLan);
        Element isExt = new Element("isExt");
        isExt.setText(String.valueOf(info.isExt()));
        property.addContent((Content)isExt);
        Element editorType = new Element("editorType");
        editorType.setText(String.valueOf(info.getEditorType()));
        property.addContent((Content)editorType);
        return property;
    }

    public static Element getPropertysElement(Element root) {
        if (root == null) {
            return null;
        }
        Element elementProperties = root.getChild("Properties");
        return elementProperties;
    }

    public static Element getEventsElement(Element root) {
        if (root == null) {
            return null;
        }
        Element elementProperties = root.getChild("Events");
        return elementProperties;
    }

    public static DTControlEventInfo[] getEventInfos(Element root, Object[] defaultEventNames) {
        Element eventsElement = root.getChild("Events");
        List eventList = eventsElement.getChildren();
        DTControlEventInfo[] result = new DTControlEventInfo[eventList.size()];
        boolean isFoundDefaultEvent = false;
        for (int i = 0; i < eventList.size(); ++i) {
            Element event = (Element)eventList.get(i);
            DTControlEventInfo eInfo = WidgetTools.getEventInfo(event);
            if (!isFoundDefaultEvent && eInfo != null && eInfo.isDefault()) {
                defaultEventNames[0] = eInfo.getEventName().trim();
                isFoundDefaultEvent = true;
            }
            result[i] = eInfo;
        }
        return result;
    }

    public static DTControlEventInfo getEventInfo(Element event) {
        if (event == null) {
            return null;
        }
        Element eventName = event.getChild("eventName");
        Element eventType = event.getChild("eventType");
        Element listenerType = event.getChild("listenerType");
        Element listenerAdapter = event.getChild("listenerAdapter");
        Element isDefaultElement = event.getChild("isDefault");
        Element runAtElement = event.getChild("runAt");
        Element returnTypeElement = event.getChild("returnType");
        Element isExt = event.getChild("isExt");
        DTControlEventInfo eInfo = new DTControlEventInfo(eventName.getTextTrim(), eventType.getTextTrim(), listenerType.getTextTrim(), listenerAdapter.getTextTrim());
        if (runAtElement != null) {
            eInfo.setRunAt(runAtElement.getTextTrim());
        }
        if (returnTypeElement != null) {
            eInfo.setReturnType(returnTypeElement.getTextTrim());
        }
        if (isDefaultElement != null && "true".equalsIgnoreCase(isDefaultElement.getTextTrim())) {
            eInfo.setDefault(true);
        }
        if (isExt != null) {
            if (!StringUtils.isEmpty((String)isExt.getText())) {
                eInfo.setExt(Boolean.valueOf(isExt.getText().trim()));
            } else {
                eInfo.setExt(false);
            }
        } else {
            eInfo.setExt(false);
        }
        return eInfo;
    }

    public static Element getEventElement(DTControlEventInfo info) {
        if (info == null) {
            return null;
        }
        Element property = new Element("Event");
        Element eventName = new Element("eventName");
        eventName.setText(info.getEventName());
        property.addContent((Content)eventName);
        Element eventType = new Element("eventType");
        eventType.setText(info.getEventType());
        property.addContent((Content)eventType);
        Element listenerType = new Element("listenerType");
        listenerType.setText(info.getListenerType());
        property.addContent((Content)listenerType);
        Element listenerAdapter = new Element("listenerAdapter");
        listenerAdapter.setText(info.getListenerAdapter());
        property.addContent((Content)listenerAdapter);
        Element isDefault = new Element("isDefault");
        isDefault.setText(String.valueOf(info.isDefault()));
        property.addContent((Content)isDefault);
        Element runAt = new Element("runAt");
        runAt.setText(info.getRunAt());
        property.addContent((Content)runAt);
        Element isExt = new Element("isExt");
        isExt.setText(String.valueOf(info.isExt()));
        property.addContent((Content)isExt);
        return property;
    }

    public static boolean isVisual(Element root) {
        return Boolean.valueOf(root.getChild("isVisual").getTextTrim());
    }

    public static boolean isContainer(Element root) {
        return Boolean.valueOf(root.getChild("isContainer").getTextTrim());
    }
}

