/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.extendproperty;

import com.kingdee.bos.dao.IExtendedPropertyContainer;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.eas.ep.client.model.extendproperty.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import org.apache.log4j.Logger;

public final class ExtendPropertyUtil {
    private static final Logger logger = Logger.getLogger(ExtendPropertyUtil.class);

    public static Configuration getConfigration() {
        Configuration config = null;
        try {
            URL url = ExtendPropertyUtil.class.getResource("bosconfig.xml");
            File file = Configuration.getFile("bosconfig.xml");
            config = file.exists() ? Configuration.getInstance() : Configuration.getInstance(url);
        }
        catch (Exception e) {
            logger.debug((Object)"error", (Throwable)e);
        }
        return config;
    }

    public static boolean load(IExtendedPropertyContainer epc) {
        boolean hasUpdate;
        block15: {
            hasUpdate = false;
            try {
                Configuration config = ExtendPropertyUtil.getConfigration();
                ConfigurationItem item22 = config.getConfigItem("ExtendProperties");
                if (item22 == null) break block15;
                for (ConfigurationItem item22 : item22.getAllChildren()) {
                    if (item22 == null) continue;
                    for (ConfigurationItem item22 : item22.getAllChildren()) {
                        QueryInfo query;
                        EntityObjectInfo entity;
                        String defaultValue;
                        if (item22 == null) continue;
                        String key = item22.getName() == null ? "" : item22.getName();
                        String object = item22.getProperty("object") == null ? "" : item22.getProperty("object");
                        String filter = item22.getProperty("filter") == null ? "" : item22.getProperty("filter");
                        String string = defaultValue = item22.getProperty("defaultvalue") == null ? "" : item22.getProperty("defaultvalue");
                        if (epc instanceof EntityObjectInfo && object.equalsIgnoreCase("entity") && ExtendPropertyUtil.isExtendFrom((EntityObjectInfo)epc, filter) && !epc.containsExtendedPropertyKey(key)) {
                            epc.setExtendedProperty(key, defaultValue);
                            hasUpdate = true;
                            continue;
                        }
                        if (epc instanceof EntityObjectInfo && object.equalsIgnoreCase("property") && ExtendPropertyUtil.isExtendFrom((EntityObjectInfo)epc, filter)) {
                            entity = (EntityObjectInfo)epc;
                            for (PropertyInfo pInfo : entity.getProperties()) {
                                if (pInfo.containsExtendedPropertyKey(key)) continue;
                                pInfo.setExtendedProperty(key, defaultValue);
                                hasUpdate = true;
                            }
                            continue;
                        }
                        if (epc instanceof EntityObjectInfo && object.equalsIgnoreCase("entityproperty") && ExtendPropertyUtil.isExtendFrom((EntityObjectInfo)epc, filter) && !epc.containsExtendedPropertyKey(key)) {
                            epc.setExtendedProperty(key, defaultValue);
                            hasUpdate = true;
                            entity = (EntityObjectInfo)epc;
                            for (PropertyInfo pInfo : entity.getProperties()) {
                                if (pInfo.containsExtendedPropertyKey(key)) continue;
                                pInfo.setExtendedProperty(key, defaultValue);
                                hasUpdate = true;
                            }
                            continue;
                        }
                        if (epc instanceof QueryInfo && object.equalsIgnoreCase("query") && !epc.containsExtendedPropertyKey(key)) {
                            epc.setExtendedProperty(key, defaultValue);
                            hasUpdate = true;
                            continue;
                        }
                        if (epc instanceof QueryInfo && object.equalsIgnoreCase("field")) {
                            query = (QueryInfo)epc;
                            for (QueryFieldInfo qInfo : query.getUnits().getQueryFields()) {
                                if (qInfo.containsExtendedPropertyKey(key)) continue;
                                qInfo.setExtendedProperty(key, defaultValue);
                                hasUpdate = true;
                            }
                            continue;
                        }
                        if (epc instanceof QueryInfo && object.equalsIgnoreCase("queryfield") && !epc.containsExtendedPropertyKey(key)) {
                            epc.setExtendedProperty(key, defaultValue);
                            hasUpdate = true;
                            query = (QueryInfo)epc;
                            for (QueryFieldInfo qInfo : query.getUnits().getQueryFields()) {
                                if (qInfo.containsExtendedPropertyKey(key)) continue;
                                qInfo.setExtendedProperty(key, defaultValue);
                                hasUpdate = true;
                            }
                            continue;
                        }
                        if (!(epc instanceof PermissionInfo) || !object.equalsIgnoreCase("permissionitem")) continue;
                        PermissionInfo permission = (PermissionInfo)epc;
                        for (PropertyInfo pInfo : permission.getPermissionItems()) {
                            if (pInfo.containsExtendedPropertyKey(key)) continue;
                            pInfo.setExtendedProperty(key, defaultValue);
                            hasUpdate = true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hasUpdate;
    }

    public static boolean isDefaultProperty(ExtendPropertyInfo epInfo) {
        boolean isDefault = false;
        try {
            Configuration config = Configuration.getInstance();
            ConfigurationItem cItem22 = config.getConfigItem("ExtendProperties");
            if (cItem22 != null) {
                block2: for (ConfigurationItem cItem22 : cItem22.getAllChildren()) {
                    for (ConfigurationItem cItem22 : cItem22.getAllChildren()) {
                        String key = cItem22.getName();
                        if (!key.equalsIgnoreCase(epInfo.getName())) continue;
                        isDefault = true;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isDefault;
    }

    protected static boolean isExtendFrom(EntityObjectInfo entity, String baseName) {
        if (StringUtils.isEmpty((String)baseName)) {
            return true;
        }
        boolean isExtend = false;
        String name = entity.getFullName();
        String[] baseNameArray = StringUtils.split((String)baseName, (String)"||");
        HashSet<String> baseNameSet = new HashSet<String>();
        if (baseNameArray != null) {
            for (int i = 0; i < baseNameArray.length; ++i) {
                baseNameSet.add(baseNameArray[i]);
            }
        }
        if (baseNameSet.contains(name)) {
            isExtend = true;
        } else {
            for (EntityObjectInfo parent = entity.getBaseEntity(); parent != null; parent = parent.getBaseEntity()) {
                name = parent.getFullName();
                if (!baseNameSet.contains(name)) continue;
                return true;
            }
        }
        return isExtend;
    }
}

