/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.model.extendproperty;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.ep.client.model.extendproperty.Configuration;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.ExtendPropertyUtil;
import com.kingdee.eas.ep.client.model.extendproperty.GroupComparator;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ReadBosConfigUtil {
    private static final Logger logger = Logger.getLogger(ReadBosConfigUtil.class);

    public static List getAllExtendProperty(String useObject, AbstractMDValue metadata) {
        ArrayList<ExdPropertyDelegate> items = new ArrayList<ExdPropertyDelegate>();
        String object = useObject == null ? "" : useObject;
        try {
            Configuration config = ExtendPropertyUtil.getConfigration();
            ConfigurationItem proItems = config.getConfigItem("ExtendProperties");
            if (proItems != null) {
                for (ConfigurationItem proItem : proItems.getAllChildren()) {
                    for (ConfigurationItem propertyItem : proItem.getAllChildren()) {
                        String obj = propertyItem.getProperty("object");
                        if (!StringUtils.isEmpty((String)obj) && !object.equals(obj)) continue;
                        String filter = propertyItem.getProperty("filter");
                        if (metadata != null && metadata instanceof EntityObjectInfo && !ReadBosConfigUtil.canSelect((EntityObjectInfo)metadata, filter)) continue;
                        ExdPropertyDelegate delegate = new ExdPropertyDelegate();
                        String name = propertyItem.getName();
                        delegate.setName(name == null ? "" : name);
                        String group = propertyItem.getProperty("group");
                        delegate.setGroup(group == null ? "" : group);
                        String alias = propertyItem.getProperty("alias");
                        delegate.setAlias(alias == null ? "" : alias);
                        String value = propertyItem.getProperty("defaultvalue");
                        delegate.setValue(value == null ? "" : value);
                        delegate.setDefaultValue(value == null ? "" : value);
                        String type = propertyItem.getProperty("type");
                        delegate.setType(type == null ? "" : type);
                        String desc = propertyItem.getProperty("description");
                        delegate.setDescription(desc == null ? "" : desc);
                        String required = propertyItem.getProperty("required");
                        delegate.setRequired(required == null ? "" : required);
                        String useAble = propertyItem.getProperty("useAble");
                        if ("false".equalsIgnoreCase(useAble)) {
                            delegate.setUseAble(false);
                        }
                        items.add(delegate);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)"error", (Throwable)e);
        }
        Object[] objs = items.toArray();
        GroupComparator comparator = new GroupComparator();
        Arrays.sort(objs, comparator);
        items.clear();
        for (int i = 0; i < objs.length; ++i) {
            items.add((ExdPropertyDelegate)((Object)objs[i]));
        }
        return items;
    }

    public static boolean canUse(ConfigurationItem propertyItem) {
        if (StringUtils.isEmpty((String)propertyItem.getProperty("useAble"))) {
            return true;
        }
        String property = propertyItem.getProperty("useAble");
        return !Boolean.FALSE.toString().equalsIgnoreCase(property);
    }

    public static String getPropertyName(String extendPropertyName, String proName) {
        if (extendPropertyName == null || extendPropertyName.equals("") || proName == null || proName.equals("")) {
            return "";
        }
        try {
            Configuration config = ExtendPropertyUtil.getConfigration();
            ConfigurationItem proItems = config.getConfigItem("ExtendProperties");
            if (proItems != null) {
                for (ConfigurationItem proItem : proItems.getAllChildren()) {
                    for (ConfigurationItem propertyItem : proItem.getAllChildren()) {
                        String propertyName = propertyItem.getName();
                        if (propertyName == null || !propertyName.equals(extendPropertyName)) continue;
                        String group = propertyItem.getProperty(proName);
                        return group == null ? "" : group;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)"error", (Throwable)e);
        }
        return "";
    }

    public static ExdPropertyDelegate getExdPropertyByName(String extendPropertyName, AbstractMDValue metadata) {
        ExdPropertyDelegate delegate;
        block6: {
            delegate = new ExdPropertyDelegate();
            if (extendPropertyName == null || extendPropertyName.equals("")) {
                return delegate;
            }
            try {
                Configuration config = ExtendPropertyUtil.getConfigration();
                ConfigurationItem proItems = config.getConfigItem("ExtendProperties");
                if (proItems == null) break block6;
                Iterator it = proItems.getAllChildren().iterator();
                while (it.hasNext()) {
                    boolean canBreak = false;
                    ConfigurationItem proItem = (ConfigurationItem)it.next();
                    for (ConfigurationItem propertyItem : proItem.getAllChildren()) {
                        String propertyName = propertyItem.getName();
                        if (propertyName == null || !propertyName.trim().equals(extendPropertyName.trim())) continue;
                        String filter = propertyItem.getProperty("filter");
                        if (metadata != null && metadata instanceof EntityObjectInfo && !ReadBosConfigUtil.canSelect((EntityObjectInfo)metadata, filter)) continue;
                        String name = propertyItem.getName();
                        delegate.setName(name == null ? "" : name);
                        String group = propertyItem.getProperty("group");
                        delegate.setGroup(group == null ? "" : group);
                        String alias = propertyItem.getProperty("alias");
                        delegate.setAlias(alias == null ? "" : alias);
                        String value = propertyItem.getProperty("defaultvalue");
                        delegate.setValue(value == null ? "" : value);
                        delegate.setDefaultValue(value == null ? "" : value);
                        String type = propertyItem.getProperty("type");
                        delegate.setType(type == null ? "" : type);
                        String desc = propertyItem.getProperty("description");
                        delegate.setDescription(desc == null ? "" : desc);
                        String required = propertyItem.getProperty("required");
                        delegate.setRequired(required == null ? "" : required);
                        String useAble = propertyItem.getProperty("useAble");
                        if ("false".equalsIgnoreCase(useAble)) {
                            delegate.setUseAble(false);
                        }
                        canBreak = true;
                        break;
                    }
                    if (!canBreak) continue;
                    break;
                }
            }
            catch (Exception e) {
                logger.debug((Object)"error", (Throwable)e);
            }
        }
        return delegate;
    }

    public static List getRequiredExdPro(String useObject, AbstractMDValue metadata) {
        ArrayList<ExdPropertyDelegate> ret = new ArrayList<ExdPropertyDelegate>();
        if (useObject == null || useObject.equals("")) {
            return ret;
        }
        List list = ReadBosConfigUtil.getAllExtendProperty(useObject, metadata);
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            String required = delegate.getRequired();
            if (required == null || !required.equalsIgnoreCase("true")) continue;
            ret.add(delegate);
        }
        return ret;
    }

    private static boolean canSelect(EntityObjectInfo entity, String filters) {
        if (StringUtils.isEmpty((String)filters)) {
            return true;
        }
        boolean canSelect = false;
        String name = entity.getFullName();
        String[] baseNameArray = StringUtils.split((String)filters, (String)"||");
        HashSet<String> baseNameSet = new HashSet<String>();
        if (baseNameArray != null) {
            for (int i = 0; i < baseNameArray.length; ++i) {
                baseNameSet.add(baseNameArray[i]);
            }
        }
        if (baseNameSet.contains(name)) {
            canSelect = true;
        } else {
            for (EntityObjectInfo parent = entity.getBaseEntity(); parent != null; parent = parent.getBaseEntity()) {
                name = parent.getFullName();
                if (!baseNameSet.contains(name)) continue;
                return true;
            }
        }
        return canSelect;
    }

    public static List getAllExtendPropertyWithoutFilter(String useObject) {
        ArrayList<Object> items = new ArrayList<Object>();
        String object = useObject == null ? "" : useObject;
        try {
            Configuration config = ExtendPropertyUtil.getConfigration();
            ConfigurationItem proItems = config.getConfigItem("ExtendProperties");
            if (proItems != null) {
                for (ConfigurationItem proItem : proItems.getAllChildren()) {
                    for (ConfigurationItem propertyItem : proItem.getAllChildren()) {
                        String obj = propertyItem.getProperty("object");
                        if (!StringUtils.isEmpty((String)obj) && !object.equals(obj)) continue;
                        ExdPropertyDelegate delegate = new ExdPropertyDelegate();
                        String name = propertyItem.getName();
                        delegate.setName(name == null ? "" : name);
                        String group = propertyItem.getProperty("group");
                        delegate.setGroup(group == null ? "" : group);
                        String alias = propertyItem.getProperty("alias");
                        delegate.setAlias(alias == null ? "" : alias);
                        String value = propertyItem.getProperty("defaultvalue");
                        delegate.setValue(value == null ? "" : value);
                        delegate.setDefaultValue(value == null ? "" : value);
                        String type = propertyItem.getProperty("type");
                        delegate.setType(type == null ? "" : type);
                        String desc = propertyItem.getProperty("description");
                        delegate.setDescription(desc == null ? "" : desc);
                        String required = propertyItem.getProperty("required");
                        delegate.setRequired(required == null ? "" : required);
                        items.add((Object)delegate);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)"error", (Throwable)e);
        }
        Object[] objs = items.toArray();
        GroupComparator comparator = new GroupComparator();
        Arrays.sort(objs, comparator);
        items.clear();
        for (int i = 0; i < objs.length; ++i) {
            items.add(objs[i]);
        }
        return items;
    }
}

