/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.editor.enums.EnumEditor;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.CustomizedUnitDefaultTreeNodePolicy;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;

public class EnumTreeNodePolicy
extends CustomizedUnitDefaultTreeNodePolicy {
    public EnumTreeNodePolicy(CustomizedUnitUI ui) {
        super(ui);
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireDoubleClick(selectedNode, e);
            if (!StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
                try {
                    BizEnumInfo base = UictUtils.loadBizEnum((IMetaDataPK)new MetaDataPK(selectedNode.getMetadataPK()), selectedNode.getDepend());
                    BizEnumInfo clone = (BizEnumInfo)base.clone();
                    EnumEditor editor = new EnumEditor(base, clone);
                    editor.setCustomizedSchemeID(selectedNode.getCustomizedSchemeID());
                    editor.setDepends(selectedNode.getDepend());
                    this.ui.getEditorPanel().addTabPanel(editor, "\u679a\u4e3e-" + (StringUtils.isEmpty((String)clone.getAlias()) ? clone.getName() : clone.getAlias()));
                }
                catch (Exception ex) {
                    ExceptionHandler.handleError((Component)((Object)this.ui), ex, "\u52a0\u8f7d\u679a\u4e3e\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                }
            }
        }
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode) && !StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
            this.popMenu.show((Component)this.tree, e.getX(), e.getY());
        }
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (this.accept(newNode)) {
            super.fireSelectedChange(newNode, oldNode, e, scheme);
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return node != null && NodeTypeEnum.ENUM.equals((Object)node.getNodeType());
    }
}

