/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.editor.exception.ExceptionEditor;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.CustomizedUnitDefaultTreeNodePolicy;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class ExceptionTreeNodePolicy
extends CustomizedUnitDefaultTreeNodePolicy {
    private static Logger logger = Logger.getLogger(ExceptionTreeNodePolicy.class);

    public ExceptionTreeNodePolicy(CustomizedUnitUI ui) {
        super(ui);
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireDoubleClick(selectedNode, e);
            if (!StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
                try {
                    ExceptionEditor editor = new ExceptionEditor(selectedNode.getMetadataPK(), selectedNode.getCustomizedSchemeID());
                    editor.setCustomizedSchemeID(selectedNode.getCustomizedSchemeID());
                    editor.setDepends(selectedNode.getDepend());
                    this.ui.getEditorPanel().addTabPanel(editor, "\u5f02\u5e38-" + selectedNode.getMetadataPK());
                    if (this.ui.getExplorerPanel().getTabPanelCount() > 1) {
                        this.ui.getExplorerPanel().removeTabPanel(1);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handleError((Component)((Object)this.ui), ex, "\u52a0\u8f7d\u5f02\u5e38\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                }
            }
        }
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (this.accept(newNode)) {
            super.fireSelectedChange(newNode, oldNode, e, scheme);
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return node != null && NodeTypeEnum.EXCEPTION.equals((Object)node.getNodeType());
    }
}

