/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.ExtendDefinitionUI;
import com.kingdee.eas.ep.client.FacadeEditorUI;
import com.kingdee.eas.ep.client.adapter.ExtendDefinitionUIAdapter;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.CustomizedUnitDefaultTreeNodePolicy;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class FacadeTreeNodePolicy
extends CustomizedUnitDefaultTreeNodePolicy {
    private static Logger logger = Logger.getLogger(FacadeTreeNodePolicy.class);

    public FacadeTreeNodePolicy(CustomizedUnitUI ui) {
        super(ui);
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireDoubleClick(selectedNode, e);
            if (!StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
                try {
                    FacadeInfo base = UictUtils.loadFacade((IMetaDataPK)new MetaDataPK(selectedNode.getMetadataPK()), selectedNode.getDepend());
                    FacadeInfo clone = (FacadeInfo)base.trueClone();
                    FacadeEditorUI editor = new FacadeEditorUI(clone, selectedNode.getDepend(), selectedNode.getCustomizedSchemeID());
                    editor.initUIContentLayout();
                    this.ui.getEditorPanel().addTabPanel(editor, "facade");
                    editor.loadData();
                    ExtendDefinitionUI extendDefinitionUI = new ExtendDefinitionUI((AbstractMetaDataValue)clone, MetaDataTypeList.FACADE, selectedNode.getMetadataPK(), selectedNode.getCustomizedSchemeID(), selectedNode.getDepend());
                    ExtendDefinitionUIAdapter adapter = new ExtendDefinitionUIAdapter(extendDefinitionUI);
                    adapter.setCustomizedSchemeID(selectedNode.getCustomizedSchemeID());
                    adapter.setDepends(selectedNode.getDepend());
                    this.ui.getEditorPanel().addTabPanelNotSave(adapter, "\u6269\u5c55\u5b9a\u4e49");
                    if (this.ui.getExplorerPanel().getTabPanelCount() > 1) {
                        this.ui.getExplorerPanel().removeTabPanel(1);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                    ExceptionHandler.handleError((Component)((Object)this.ui), ex, "\u52a0\u8f7d\u529f\u80fd\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                }
            }
        }
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireRightClick(selectedNode, e);
            this.popMenu.show((Component)this.tree, e.getX(), e.getY());
        }
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (this.accept(newNode)) {
            super.fireSelectedChange(newNode, oldNode, e, scheme);
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return node != null && NodeTypeEnum.FACADE.equals((Object)node.getNodeType());
    }
}

