/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.FunctionEditorUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.CustomizedUnitDefaultTreeNodePolicy;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class FunctionTreeNodePolicy
extends CustomizedUnitDefaultTreeNodePolicy {
    private static Logger logger = Logger.getLogger(FunctionTreeNodePolicy.class);

    public FunctionTreeNodePolicy(CustomizedUnitUI ui) {
        super(ui);
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireDoubleClick(selectedNode, e);
            if (!StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
                try {
                    FunctionObjectInfo base = UictUtils.loadFunction((IMetaDataPK)new MetaDataPK(selectedNode.getMetadataPK()), selectedNode.getDepend());
                    FunctionObjectInfo clone = (FunctionObjectInfo)base.clone();
                    FunctionEditorUI editor = new FunctionEditorUI(clone, selectedNode.getDepend(), selectedNode.getCustomizedSchemeID());
                    editor.initUIContentLayout();
                    this.ui.getEditorPanel().addTabPanel(editor, "\u529f\u80fd");
                    editor.loadData();
                    if (this.ui.getExplorerPanel().getTabPanelCount() > 1) {
                        this.ui.getExplorerPanel().removeTabPanel(1);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                    ExceptionHandler.handleError((Component)((Object)this.ui), ex, "\u52a0\u8f7d\u529f\u80fd\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                }
            }
        }
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireRightClick(selectedNode, e);
            this.popMenu.show((Component)this.tree, e.getX(), e.getY());
        }
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (this.accept(newNode)) {
            super.fireSelectedChange(newNode, oldNode, e, scheme);
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return node != null && NodeTypeEnum.FUNCTION.equals((Object)node.getNodeType());
    }
}

