/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomTemplateInfo;
import com.kingdee.eas.ep.CustomizedItems;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.ReCreateException;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.util.ImportBizUnitHelper;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.wizard.template.CopyCreator;
import com.kingdee.eas.ep.client.wizard.template.UnitNodeCreator;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;

public class NewUnitPolicy {
    private CustomTemplateInfo template;
    private CopyCreator.TemplateInfo templateInfo;
    protected CustomizedUnitTreeNode selectedNode = null;
    private CustomizedUnitInfo cuInfo = null;
    protected CustomizedUnitUI ui;
    private BizUnitInfo buInfo;
    public static final String AddNew = "0";
    public static final String Import = "1";
    public static final String Copy = "2";

    public NewUnitPolicy(CustomTemplateInfo template, CopyCreator.TemplateInfo templateInfo, CustomizedUnitTreeNode selectedNode, CustomizedUnitInfo cuInfo, CustomizedUnitUI ui) {
        this.template = template;
        this.templateInfo = templateInfo;
        this.selectedNode = selectedNode;
        this.cuInfo = cuInfo;
        this.ui = ui;
    }

    public void copyTemplate() throws Exception {
        try {
            CopyCreator creator = new CopyCreator(this.templateInfo, this.selectedNode.getCustomizedSchemeID(), this.selectedNode.getDepend());
            creator.create();
            UnitNodeCreator nCreator = new UnitNodeCreator(creator, this.selectedNode, this.cuInfo);
            nCreator.setTemplateNumber(this.template.getNumber());
            nCreator.create();
        }
        catch (ReCreateException e) {
            MsgBox.showInfo((String)"\u4f60\u8981\u521b\u5efa\u751f\u6210\u7684\u5143\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5305\u8def\u5f84\u6216\u8005\u540d\u79f0\uff01");
        }
        catch (Exception exc) {
            ExceptionHandler.handleError((Component)((Object)this.ui), exc, "\u521b\u5efa\u6269\u5c55\u5355\u5143\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            return;
        }
        if (this.ui != null) {
            if (this.cuInfo != null) {
                this.ui.getExplorerPanel().getCustomizedUnitTreePanel().refresh(3);
            } else {
                this.ui.getExplorerPanel().getCustomizedUnitTreePanel().refresh(0);
            }
        }
    }

    public void addNewCustomUnit() throws Exception {
        CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
        cunInfo.setType(AddNew);
        String xml = CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
        ICustomizedUnit bizInterface = CustomizedUnitFactory.getRemoteInstance();
        this.cuInfo.setCustomizedUnitObject(xml);
        this.cuInfo.setId(BOSUuid.create((BOSObjectType)this.cuInfo.getBOSType()));
        this.cuInfo.setNumber(this.cuInfo.getId().toString());
        this.cuInfo.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
        this.cuInfo.setLevel(this.selectedNode.getLevel() + 1);
        this.cuInfo.setParent((CustomizedUnitInfo)this.selectedNode.getUserObject());
        this.cuInfo.setCustomizedSchemeID(this.selectedNode.getCustomizedSchemeID());
        bizInterface.addnew((CoreBaseInfo)this.cuInfo);
        this.ui.getExplorerPanel().getCustomizedUnitTreePanel().refresh(0);
    }

    public void importCustomUnit() throws Exception {
        if (this.buInfo != null) {
            FunctionObjectInfo function;
            UIObjectInfo editui;
            UIObjectInfo listui;
            CustomizedUnitNodeInfo.MetaDataInfo md;
            QueryInfo query;
            EntityObjectInfo entity;
            if (this.isChildExist(this.selectedNode, this.buInfo.getAlias())) {
                throw new EPException(EPException.ITEM_CUSTOMIZED);
            }
            String sEntityPK = this.buInfo.getString("entityPK");
            String sQueryPK = this.buInfo.getString("queryPK");
            String sListUIPK = this.buInfo.getString("listUIPK");
            String sEditUIPK = this.buInfo.getString("editUIPK");
            String sWebListUIPK = this.buInfo.getString("webListUIPK");
            String sWebEditUIPK = this.buInfo.getString("webEditUIPK");
            String entityFunctionPK = this.buInfo.getString("entityFunctionPK");
            String editUIFunctionPK = this.buInfo.getString("editUIFunctionPK");
            String listUIFunctionPK = this.buInfo.getString("listUIFunctionPK");
            CustomizedItems items = new CustomizedItems();
            items.addMetadataPK(this.buInfo.getPackage() + "." + this.buInfo.getName());
            CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
            cunInfo.setPackagePK(this.buInfo.getPackage());
            cunInfo.setName(this.buInfo.getName());
            cunInfo.setAlias(this.buInfo.getAlias());
            cunInfo.setCustomizedType("bizunit");
            if (!StringUtils.isEmpty((String)sEntityPK) && (entity = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(sEntityPK), this.selectedNode.getDepend())) != null) {
                ArrayList entitys = new ArrayList();
                ImportBizUnitHelper.getEntitys(entity, entitys);
                for (EntityObjectInfo eoi : entitys) {
                    CustomizedUnitNodeInfo.MetaDataInfo md2 = new CustomizedUnitNodeInfo.MetaDataInfo(eoi.getPackage(), eoi.getName(), eoi.getAlias());
                    cunInfo.getEntity().add(md2);
                    items.addMetadataPK(eoi.getFullName());
                }
            }
            if (!StringUtils.isEmpty((String)sQueryPK) && (query = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(sQueryPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(query.getPackage(), query.getName(), query.getAlias());
                cunInfo.getQuery().add(md);
                items.addMetadataPK(sQueryPK);
            }
            if (!StringUtils.isEmpty((String)sListUIPK) && (listui = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(sListUIPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
                cunInfo.getUi().getListui().add(md);
                items.addMetadataPK(sListUIPK);
            }
            if (!StringUtils.isEmpty((String)sEditUIPK) && (editui = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(sEditUIPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
                cunInfo.getUi().getEditui().add(md);
                items.addMetadataPK(sEditUIPK);
            }
            if (!StringUtils.isEmpty((String)sWebListUIPK) && (listui = UictUtils.loadWebUI((IMetaDataPK)new MetaDataPK(sWebListUIPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
                cunInfo.getWebUi().getListui().add(md);
                items.addMetadataPK(sWebListUIPK);
            }
            if (!StringUtils.isEmpty((String)sWebEditUIPK) && (editui = UictUtils.loadWebUI((IMetaDataPK)new MetaDataPK(sWebEditUIPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
                cunInfo.getWebUi().getEditui().add(md);
                items.addMetadataPK(sWebEditUIPK);
            }
            if (!StringUtils.isEmpty((String)entityFunctionPK) && (function = UictUtils.loadFunction((IMetaDataPK)new MetaDataPK(entityFunctionPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
                cunInfo.getFunction().add(md);
                items.addMetadataPK(entityFunctionPK);
            }
            if (!StringUtils.isEmpty((String)editUIFunctionPK) && (function = UictUtils.loadFunction((IMetaDataPK)new MetaDataPK(editUIFunctionPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
                cunInfo.getFunction().add(md);
                items.addMetadataPK(editUIFunctionPK);
            }
            if (!StringUtils.isEmpty((String)listUIFunctionPK) && (function = UictUtils.loadFunction((IMetaDataPK)new MetaDataPK(listUIFunctionPK), this.selectedNode.getDepend())) != null) {
                md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
                cunInfo.getFunction().add(md);
                items.addMetadataPK(listUIFunctionPK);
            }
            cunInfo.setType(Import);
            items.setSchemeID(this.selectedNode.getCustomizedSchemeID());
            String xml = CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
            ICustomizedUnit bizInterface = CustomizedUnitFactory.getRemoteInstance();
            CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
            dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
            dataObj.setNumber(dataObj.getId().toString());
            dataObj.setName(cunInfo.getName());
            dataObj.setDisplayName(StringUtils.isEmpty((String)cunInfo.getAlias()) ? cunInfo.getName() : cunInfo.getAlias());
            dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
            dataObj.setCustomizedUnitObject(xml);
            dataObj.setIsLeaf(false);
            dataObj.setLevel(this.selectedNode.getLevel() + 1);
            dataObj.setParent((CustomizedUnitInfo)this.selectedNode.getUserObject());
            dataObj.setCustomizedSchemeID(this.selectedNode.getCustomizedSchemeID());
            bizInterface.addnew((CoreBaseInfo)dataObj);
            this.ui.getExplorerPanel().getCustomizedUnitTreePanel().refresh(0);
        }
    }

    private boolean isChildExist(CustomizedUnitTreeNode parent, String childName) {
        if (parent == null || childName == null) {
            return false;
        }
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            String text;
            TreeNode child = parent.getChildAt(i);
            if (!(child instanceof CustomizedUnitTreeNode) || !childName.equals(text = ((CustomizedUnitTreeNode)((Object)child)).getText())) continue;
            return true;
        }
        return false;
    }

    public void setBuInfo(BizUnitInfo buInfo) {
        this.buInfo = buInfo;
    }
}

