/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.editor.permission.PermissionEditorUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.CustomizedUnitDefaultTreeNodePolicy;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class PermissionTreeNodePolicy
extends CustomizedUnitDefaultTreeNodePolicy {
    private static Logger logger = Logger.getLogger(PermissionTreeNodePolicy.class);

    public PermissionTreeNodePolicy(CustomizedUnitUI ui) {
        super(ui);
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireDoubleClick(selectedNode, e);
            if (!StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
                try {
                    PermissionInfo base = UictUtils.loadPermission((IMetaDataPK)new MetaDataPK(selectedNode.getMetadataPK()), selectedNode.getDepend());
                    if (base.getPermissionItems() != null) {
                        logger.error((Object)("PermissionTreeNodePolicy base  size is :" + base.getPermissionItems().size()));
                    } else {
                        logger.error((Object)"PermissionTreeNodePolicy  base is null");
                    }
                    PermissionInfo clone = (PermissionInfo)base.trueClone();
                    if (clone.getPermissionItems() != null) {
                        logger.error((Object)("PermissionTreeNodePolicy clone size is :" + clone.getPermissionItems().size()));
                    } else {
                        logger.error((Object)"PermissionTreeNodePolicy clone is null");
                    }
                    PermissionEditorUI editor = new PermissionEditorUI(base, clone, selectedNode.getCustomizedSchemeID(), selectedNode.getDepend());
                    editor.setCustomizedUnitUI(this.ui);
                    editor.setCustomizedSchemeID(selectedNode.getCustomizedSchemeID());
                    editor.setCustomizedSchemeAlias(selectedNode.getText());
                    editor.setDepends(selectedNode.getDepend());
                    this.ui.getEditorPanel().addTabPanel(editor, "\u6743\u9650-" + (StringUtils.isEmpty((String)clone.getAlias()) ? clone.getName() : clone.getAlias()));
                    if (this.ui.getExplorerPanel().getTabPanelCount() > 1) {
                        this.ui.getExplorerPanel().removeTabPanel(1);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                    ExceptionHandler.handleError((Component)((Object)this.ui), ex, "\u52a0\u8f7d\u6743\u9650\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                }
            }
        }
    }

    @Override
    protected void initCommonMenuItem() {
        super.initCommonMenuItem();
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireRightClick(selectedNode, e);
            this.popMenu.show((Component)this.tree, e.getX(), e.getY());
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return node != null && NodeTypeEnum.PERMISSION.equals((Object)node.getNodeType());
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (this.accept(newNode)) {
            super.fireSelectedChange(newNode, oldNode, e, scheme);
        }
    }
}

