/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.editor.query.ui.DynQueryEditor;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.CustomizedUnitDefaultTreeNodePolicy;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;

public class QueryTreeNodePolicy
extends CustomizedUnitDefaultTreeNodePolicy {
    public QueryTreeNodePolicy(CustomizedUnitUI ui) {
        super(ui);
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireDoubleClick(selectedNode, e);
            if (!StringUtils.isEmpty((String)selectedNode.getMetadataPK())) {
                try {
                    DynQueryEditor dynQuery = new DynQueryEditor();
                    dynQuery.setCustomizedUnitUI(this.ui);
                    dynQuery.setDepends(selectedNode.getDepend());
                    dynQuery.setCustomizedSchemeID(selectedNode.getCustomizedSchemeID());
                    dynQuery.setMetadataPK(selectedNode.getMetadataPK());
                    this.ui.getEditorPanel().addTabPanel(dynQuery, "\u6570\u636e\u6e90");
                    if (this.ui.getExplorerPanel().getTabPanelCount() > 1) {
                        this.ui.getExplorerPanel().removeTabPanel(1);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handleError((Component)((Object)this.ui), ex, "\u52a0\u8f7d\u6570\u636e\u6e90\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
        if (this.accept(selectedNode)) {
            super.fireRightClick(selectedNode, e);
            this.popMenu.show((Component)this.tree, e.getX(), e.getY());
        }
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (this.accept(newNode)) {
            super.fireSelectedChange(newNode, oldNode, e, scheme);
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return node != null && NodeTypeEnum.QUERY.equals((Object)node.getNodeType());
    }
}

