/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.ICustomizedUnitTreeNodePolicy;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class StatusManagerPolicy
implements ICustomizedUnitTreeNodePolicy {
    protected CustomizedUnitUI ui;
    protected KDTree tree;
    private static Logger logger = Logger.getLogger(StatusManagerPolicy.class);

    public StatusManagerPolicy() {
    }

    public StatusManagerPolicy(CustomizedUnitUI ui, KDTree tree) {
        this.ui = ui;
        this.tree = tree;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    @Override
    public void fireSelectedChange(CustomizedUnitTreeNode newNode, CustomizedUnitTreeNode oldNode, TreeSelectionEvent e, CustomizedSchemeInfo scheme) {
        if (newNode != null && scheme != null) {
            this.ui.getbtnCancel().setVisible(scheme.isStart());
            this.ui.getbtnStart().setVisible(!scheme.isStart());
            this.ui.getbtnCancel().setEnabled(!CustomSchemeUtil.isSystemScheme(scheme));
            this.ui.getbtnStart().setEnabled(!CustomSchemeUtil.isSystemScheme(scheme));
            this.ui.getbtnSave().setEnabled(!scheme.isStart() && !CustomSchemeUtil.isSystemScheme(scheme));
            if (!this.ui.getbtnSave().isEnabled()) {
                this.ui.getbtnSave().setToolTipText("\u53cd\u542f\u7528\u65b9\u6848\u540e\u4fdd\u5b58");
            } else {
                this.ui.getbtnSave().setToolTipText("\u4fdd\u5b58");
            }
        } else {
            this.ui.getbtnCancel().setEnabled(false);
            this.ui.getbtnStart().setEnabled(false);
            this.ui.getbtnSave().setEnabled(false);
        }
    }

    @Override
    public void fireRightClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
    }

    @Override
    public void fireDoubleClick(CustomizedUnitTreeNode selectedNode, MouseEvent e) {
    }

    @Override
    public void setTree(KDTree tree) {
        this.tree = tree;
        this.resetStatus();
    }

    public void resetStatus() {
        if (this.tree != null && this.tree.getSelectionPath() != null) {
            TreePath path = this.tree.getSelectionPath();
            try {
                CustomizedUnitTreeNode node = (CustomizedUnitTreeNode)((Object)path.getLastPathComponent());
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)node.getCustomizedSchemeID()));
                CustomizedSchemeInfo scheme = (CustomizedSchemeInfo)CustomizedSchemeFactory.getRemoteInstance().getValue((IObjectPK)pk);
                this.ui.getbtnCancel().setVisible(scheme.isStart());
                this.ui.getbtnStart().setVisible(!scheme.isStart());
                this.ui.getbtnCancel().setEnabled(!CustomSchemeUtil.isSystemScheme(scheme));
                this.ui.getbtnStart().setEnabled(!CustomSchemeUtil.isSystemScheme(scheme));
                this.ui.getbtnSave().setEnabled(!scheme.isStart() && !CustomSchemeUtil.isSystemScheme(scheme));
                if (!this.ui.getbtnSave().isEnabled()) {
                    this.ui.getbtnSave().setToolTipText("\u53cd\u542f\u7528\u65b9\u6848\u540e\u4fdd\u5b58");
                } else {
                    this.ui.getbtnSave().setToolTipText("\u4fdd\u5b58");
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
        }
    }

    @Override
    public boolean accept(CustomizedUnitTreeNode node) {
        return true;
    }
}

