/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.policy.tree;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.util.ImportBizUnitHelper;
import com.kingdee.eas.ep.client.util.UserConfigureUtils;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class UnitNodeCreatorForUserConfigure {
    private static CustomizedUnitInfo userSchemeRootNode;

    public CustomizedUnitInfo getUserSchemeRootNode() {
        if (userSchemeRootNode == null) {
            userSchemeRootNode = new CustomizedUnitInfo();
            userSchemeRootNode.setId(BOSUuid.read((String)"VpqTVowmQBih1YhSWJwLMTN2tTA="));
            userSchemeRootNode.setCustomizedSchemeID(UserConfigureUtils.userConfigureProject.getId());
        }
        return userSchemeRootNode;
    }

    public CustomizedUnitInfo createUnit(CustomizedUnitInfo parent, BizUnitInfo bizUnit) throws Exception {
        CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
        dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
        dataObj.setNumber(dataObj.getId().toString());
        dataObj.setName(bizUnit.getName());
        dataObj.setMetaDataPK(bizUnit.getFullName());
        dataObj.setDisplayName(StringUtils.isEmpty((String)bizUnit.getAlias()) ? bizUnit.getName() : bizUnit.getAlias());
        dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
        dataObj.setCustomizedUnitObject(this.buildContent(bizUnit));
        dataObj.setIsLeaf(false);
        dataObj.setLevel(parent.getLevel() + 1);
        dataObj.setParent(parent);
        dataObj.setCustomizedSchemeID(parent.getCustomizedSchemeID());
        return dataObj;
    }

    private String buildContent(BizUnitInfo buInfo) throws Exception {
        FunctionObjectInfo function;
        UIObjectInfo editui;
        UIObjectInfo listui;
        CustomizedUnitNodeInfo.MetaDataInfo md;
        QueryInfo query;
        EntityObjectInfo entity;
        String sEntityPK = buInfo.getString("entityPK");
        String sQueryPK = buInfo.getString("queryPK");
        String sListUIPK = buInfo.getString("listUIPK");
        String sEditUIPK = buInfo.getString("editUIPK");
        String sWebListUIPK = buInfo.getString("webListUIPK");
        String sWebEditUIPK = buInfo.getString("webEditUIPK");
        String entityFunctionPK = buInfo.getString("entityFunctionPK");
        String editUIFunctionPK = buInfo.getString("editUIFunctionPK");
        String listUIFunctionPK = buInfo.getString("listUIFunctionPK");
        CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
        cunInfo.setPackagePK(buInfo.getPackage());
        cunInfo.setName(buInfo.getName());
        cunInfo.setAlias(buInfo.getAlias());
        cunInfo.setCustomizedType("bizunit");
        if (!StringUtils.isEmpty((String)sEntityPK) && (entity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)sEntityPK), null)) != null) {
            ArrayList entitys = new ArrayList();
            ImportBizUnitHelper.getEntitys(entity, entitys);
            for (EntityObjectInfo eoi : entitys) {
                CustomizedUnitNodeInfo.MetaDataInfo md2 = new CustomizedUnitNodeInfo.MetaDataInfo(eoi.getPackage(), eoi.getName(), eoi.getAlias());
                cunInfo.getEntity().add(md2);
            }
        }
        if (!StringUtils.isEmpty((String)sQueryPK) && (query = MetadataUtils.loadQuery((IMetaDataPK)MetaDataPK.create((String)sQueryPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(query.getPackage(), query.getName(), query.getAlias());
            cunInfo.getQuery().add(md);
        }
        if (!StringUtils.isEmpty((String)sListUIPK) && (listui = MetadataUtils.loadUI((IMetaDataPK)MetaDataPK.create((String)sListUIPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
            cunInfo.getUi().getListui().add(md);
        }
        if (!StringUtils.isEmpty((String)sEditUIPK) && (editui = MetadataUtils.loadUI((IMetaDataPK)MetaDataPK.create((String)sEditUIPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
            cunInfo.getUi().getEditui().add(md);
        }
        if (!StringUtils.isEmpty((String)sWebListUIPK) && (listui = MetadataUtils.loadWebUI((IMetaDataPK)MetaDataPK.create((String)sWebListUIPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
            cunInfo.getWebUi().getListui().add(md);
        }
        if (!StringUtils.isEmpty((String)sWebEditUIPK) && (editui = MetadataUtils.loadWebUI((IMetaDataPK)MetaDataPK.create((String)sWebEditUIPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
            cunInfo.getWebUi().getEditui().add(md);
        }
        if (!StringUtils.isEmpty((String)entityFunctionPK) && (function = MetadataUtils.loadFunction((IMetaDataPK)MetaDataPK.create((String)entityFunctionPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        if (!StringUtils.isEmpty((String)editUIFunctionPK) && (function = MetadataUtils.loadFunction((IMetaDataPK)MetaDataPK.create((String)editUIFunctionPK))) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        if (!StringUtils.isEmpty((String)listUIFunctionPK) && (function = MetadataUtils.loadFunction((IMetaDataPK)MetaDataPK.create((String)listUIFunctionPK), null)) != null) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        cunInfo.setType("1");
        return CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
    }
}

