/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.depend.LRULinkedHashMap;
import com.kingdee.eas.ep.client.runtime.UIObjectInfoProxy;
import java.util.Map;

public class CachedUILoader {
    private static String oldDSessionId = null;
    private static Map<IMetaDataPK, UIObjectInfoProxy> cache = new LRULinkedHashMap<IMetaDataPK, UIObjectInfoProxy>();

    public static synchronized UIObjectInfoProxy loadUIObject(IMetaDataPK pk) {
        UIObjectInfoProxy uiObjectInfo = null;
        if (CachedUILoader.sessionChanged()) {
            CachedUILoader.clear();
        } else {
            uiObjectInfo = CachedUILoader.getFromCache(pk);
        }
        if (uiObjectInfo == null) {
            uiObjectInfo = new UIObjectInfoProxy(pk);
            cache.put(pk, uiObjectInfo);
        }
        return uiObjectInfo;
    }

    private static boolean sessionChanged() {
        String sessionId = SysContext.getSysContext().getSessionID();
        if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            return true;
        }
        return false;
    }

    private static UIObjectInfoProxy getFromCache(IMetaDataPK pk) {
        UIObjectInfoProxy obj = cache.get(pk);
        if (obj instanceof UIObjectInfoProxy) {
            return obj;
        }
        return null;
    }

    public static synchronized void clear() {
        cache.clear();
    }
}

