/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.tablepanel.KDTablePanel;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.eas.ep.client.runtime.ComponentModifyInfo;
import com.kingdee.eas.ep.client.runtime.DynamicExtendService;
import com.kingdee.eas.ep.client.runtime.UISegmentAssemblerHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ComponentModifier {
    private static final Logger logger = Logger.getLogger(ComponentModifyInfo.class);
    private DynamicExtendService service;
    private Map<String, Component> localCtx;
    private ResourceBundleHelper resHelper;

    public ComponentModifier(DynamicExtendService service, Map<String, Component> localCtx) {
        this.service = service;
        this.localCtx = localCtx;
        try {
            boolean isZH;
            String currentCode = BOSLocaleUtil.getShortCode((Locale)LocaleUtils.getDefaultOriginLocale());
            boolean bl = isZH = currentCode != null && currentCode.equals(BOSLocaleUtil.getShortCode((Locale)BOSLocaleUtil.ZH_CN));
            if (!isZH && MLClientUtils.getLanguageComboModel((boolean)false).getSize() > 0) {
                CoreUI baseUI = (CoreUI)localCtx.get("CoreUI");
                StringBuffer uiPk = new StringBuffer(baseUI.getMetaDataPK().getFullName());
                this.resHelper = new ResourceBundleHelper(uiPk.insert(uiPk.lastIndexOf(".") + 1, "Abstract").toString());
            }
        }
        catch (Throwable t) {
            this.resHelper = null;
        }
    }

    public void doModify(ComponentModifyInfo cInfo) {
        String name = cInfo.getName();
        Component obj = this.localCtx.get(name);
        if (!(obj instanceof JComponent)) {
            return;
        }
        JComponent comp = (JComponent)obj;
        if (cInfo.isModified("displayFormat")) {
            this.modifyDisplayFormat(cInfo, comp);
        }
        if (cInfo.isModified("f7FilterItem")) {
            this.modifyFilterItem(cInfo, comp);
        }
        if (cInfo.isModified("horizontalAlignment")) {
            this.modifyHorizontalAlignment(cInfo, comp);
        }
        if (cInfo.isModified("enabled")) {
            this.resetEnable(cInfo, comp);
        }
        if (cInfo.isModified("required")) {
            this.resetRequired(cInfo, comp);
        }
        if (cInfo.isModified("constraints")) {
            this.resetConstraint(cInfo, comp);
        }
        if (cInfo.isModified("parent")) {
            this.resetParent(cInfo, comp);
        }
        if (cInfo.isModified("visible")) {
            this.resetVisible(cInfo, comp);
        }
        if (cInfo.isModified("text")) {
            this.resetText(cInfo, comp);
        }
        if (cInfo.isModified("boundLabelAlignment")) {
            this.resetBoundLabelAlignment(cInfo, comp);
        }
        if (cInfo.isModified("boundLabelLength")) {
            this.resetBoundLabelLength(cInfo, comp);
        }
        if (cInfo.isModified("boundLabelUnderline")) {
            this.resetBoundLabelUnderline(cInfo, comp);
        }
        if (cInfo.isModified("boundLabelText")) {
            this.resetBoundLabelText(cInfo, comp);
        }
        if (cInfo.isModified("maxLength")) {
            this.resetMaxLength(cInfo, comp);
        }
    }

    private void resetMaxLength(ComponentModifyInfo cInfo, JComponent comp) {
        Integer value = cInfo.getInteger("maxLength");
        if (value != null && value > 0) {
            if (comp instanceof KDTextField) {
                ((KDTextField)comp).setMaxLength(value.intValue());
            } else if (comp instanceof KDTextArea) {
                ((KDTextArea)comp).setMaxLength(value.intValue());
            }
        }
    }

    private void resetBoundLabelAlignment(ComponentModifyInfo cInfo, JComponent comp) {
        Integer value = cInfo.getInteger("boundLabelAlignment");
        if (comp instanceof KDLabelContainer && value != null) {
            ((KDLabelContainer)comp).setBoundLabelAlignment(value.intValue(), false);
        }
    }

    private void resetBoundLabelLength(ComponentModifyInfo cInfo, JComponent comp) {
        Integer value = cInfo.getInteger("boundLabelLength");
        if (comp instanceof KDLabelContainer && value != null) {
            KDLabelContainer lab = (KDLabelContainer)comp;
            lab.getPropertyChangeListeners();
            ((KDLabelContainer)comp).setBoundLabelLength(value.intValue(), false);
        }
    }

    private void resetBoundLabelUnderline(ComponentModifyInfo cInfo, JComponent comp) {
        Boolean value = cInfo.getBoolean("boundLabelUnderline");
        if (comp instanceof KDLabelContainer && value != null) {
            ((KDLabelContainer)comp).setBoundLabelUnderline(value.booleanValue(), false);
        }
    }

    private void resetBoundLabelText(ComponentModifyInfo cInfo, JComponent comp) {
        String value;
        block4: {
            value = cInfo.getString("boundLabelText");
            try {
                String value1;
                if (this.resHelper != null && !StringUtils.isEmpty((String)(value1 = this.resHelper.getString(cInfo.getName() + "." + "boundLabelText")))) {
                    value = value1;
                }
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"resHelper.getString error!", t);
            }
        }
        if (comp instanceof KDLabelContainer && value != null) {
            ((KDLabelContainer)comp).setBoundLabelText(value, false);
        }
    }

    private void resetText(ComponentModifyInfo cInfo, JComponent component) {
        String text;
        block8: {
            text = cInfo.getString("text");
            try {
                String text1;
                if (this.resHelper != null && !StringUtils.isEmpty((String)(text1 = this.resHelper.getString(cInfo.getName() + "." + "text")))) {
                    text = text1;
                }
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)"resHelper.getString error!", t);
            }
        }
        if (component instanceof KDButton || component instanceof KDRadioButton || component instanceof KDCheckBox || component instanceof KDLabel) {
            try {
                Method method = component.getClass().getMethod("setText", String.class);
                method.invoke((Object)component, text);
            }
            catch (Exception exception) {}
        } else if (component instanceof KDContainer) {
            ((KDContainer)component).setTitle(text);
        }
    }

    private void resetVisible(ComponentModifyInfo cInfo, JComponent comp) {
        Container parent = comp.getParent();
        Boolean value = cInfo.getBoolean("visible");
        if (value != null) {
            if (parent instanceof KDTabbedPane) {
                if (!value.booleanValue()) {
                    ((KDTabbedPane)parent).remove((Component)comp);
                }
            } else {
                comp.setVisible(value);
            }
        }
    }

    private void resetParent(ComponentModifyInfo cInfo, JComponent comp) {
        String parentName = cInfo.getString("parent");
        Component parent = this.localCtx.get(parentName);
        if (parent instanceof Container) {
            JComponent contentPane = UISegmentAssemblerHelper.getContentPane((JComponent)parent);
            Object value = cInfo.getValue("constraints");
            if (UISegmentAssemblerHelper.isKDLayout(contentPane)) {
                if (value instanceof KDLayoutConstraint) {
                    KDLayout.Constraints kdconstraints = new KDLayout.Constraints(((KDLayoutConstraint)value).anchor, ((KDLayoutConstraint)value).toRectangle());
                    contentPane.add((Component)comp, kdconstraints);
                } else if (value instanceof Rectangle) {
                    contentPane.add((Component)comp, (Rectangle)value);
                }
            } else if (value instanceof KDLayoutConstraint) {
                contentPane.add((Component)comp, ((KDLayoutConstraint)value).toRectangle());
            } else if (value instanceof Rectangle) {
                contentPane.add((Component)comp, (Rectangle)value);
            }
        }
    }

    private void resetConstraint(ComponentModifyInfo cInfo, JComponent comp) {
        Object value = cInfo.getValue("constraints");
        if (value instanceof Rectangle) {
            comp.setBounds((Rectangle)value);
            Container parent = comp.getParent();
            if (parent instanceof KDTablePanel) {
                ((KDTablePanel)parent).doAutoLayout();
            }
        } else if (value instanceof KDLayoutConstraint && UISegmentAssemblerHelper.isKDLayout(comp.getParent())) {
            Rectangle rectangle = ((KDLayoutConstraint)value).toRectangle();
            Object constraint = comp.getClientProperty("KDLayoutConstraints");
            if (!(constraint instanceof KDLayout.Constraints)) {
                constraint = new KDLayout.Constraints();
                comp.putClientProperty("KDLayoutConstraints", constraint);
            }
            ((KDLayout.Constraints)constraint).originalBounds = rectangle;
            ((KDLayout.Constraints)constraint).anchor = ((KDLayoutConstraint)value).anchor;
            comp.setBounds(rectangle);
        }
    }

    private void resetRequired(ComponentModifyInfo cInfo, JComponent comp) {
        Boolean value = cInfo.getBoolean("required");
        if (value == Boolean.TRUE && comp instanceof IKDTextComponent) {
            ((IKDTextComponent)comp).setRequired(true);
            this.service.addRequiredComponent(comp);
        }
    }

    private void resetEnable(ComponentModifyInfo cInfo, JComponent comp) {
        Boolean value = cInfo.getBoolean("enabled");
        if (value != null) {
            comp.setEnabled(value);
        }
    }

    private void modifyHorizontalAlignment(ComponentModifyInfo cInfo, JComponent comp) {
        Integer value;
        if (comp instanceof JTextField && (value = cInfo.getInteger("horizontalAlignment")) != null) {
            ((JTextField)comp).setHorizontalAlignment(value);
        }
    }

    private void modifyDisplayFormat(ComponentModifyInfo cInfo, JComponent comp) {
        String display;
        if (comp instanceof KDBizPromptBox && !StringUtils.isEmpty((String)(display = cInfo.getString("displayFormat")))) {
            ((KDBizPromptBox)comp).setDisplayFormat(display);
        }
    }

    private void modifyFilterItem(ComponentModifyInfo cInfo, JComponent comp) {
        String filterExpr;
        if (comp instanceof KDBizPromptBox && !StringUtils.isEmpty((String)(filterExpr = cInfo.getString("f7FilterItem")))) {
            EntityViewInfo v = new EntityViewInfo();
            try {
                v.setFilter(filterExpr);
                ((KDBizPromptBox)comp).setEntityViewInfo(v);
            }
            catch (ParserException e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
        }
    }
}

