/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ComponentModifyInfo {
    private String name;
    public static final String displayFormat = "displayFormat";
    public static final String filterItem = "f7FilterItem";
    public static final String horizontalAlignment = "horizontalAlignment";
    public static final String enable = "enabled";
    public static final String require = "required";
    public static final String visible = "visible";
    public static final String text = "text";
    public static final String boundLabelText = "boundLabelText";
    public static final String boundLabelLength = "boundLabelLength";
    public static final String boundLabelUnderline = "boundLabelUnderline";
    public static final String boundLabelAlignment = "boundLabelAlignment";
    public static final String maxLength = "maxLength";
    public static final String constraints = "constraints";
    public static final String parent = "parent";
    private Map<String, Object> propertyValues = new HashMap<String, Object>();
    private static final Logger logger = Logger.getLogger(ComponentModifyInfo.class);

    public ComponentModifyInfo(ComponentInfo newComp, ComponentInfo oldComp) {
        if (newComp != null && !StringUtils.isEmpty((String)newComp.getName()) && oldComp != null && newComp != oldComp) {
            this.name = newComp.getName();
            this.initProeprtyValues(newComp, oldComp);
        }
    }

    protected boolean isModified(String key) {
        return this.propertyValues.containsKey(key);
    }

    protected boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }

    protected Object getValue(String propertyName) {
        return this.propertyValues.get(propertyName);
    }

    protected String getString(String propertyName) {
        Object value = this.propertyValues.get(propertyName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected Boolean getBoolean(String propertyName) {
        Object value = this.propertyValues.get(propertyName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    protected Integer getInteger(String propertyName) {
        Object value = this.propertyValues.get(propertyName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    protected void initProeprtyValues(ComponentInfo newComp, ComponentInfo oldComp) {
        this.initF7(newComp, oldComp);
        this.initHorizontalalignment(newComp, oldComp);
        this.initEnable(newComp, oldComp);
        this.initRequire(newComp, oldComp);
        this.initVisible(newComp, oldComp);
        this.initText(newComp, oldComp);
        this.initLabelContainer(newComp, oldComp);
        this.initConstraints(newComp, oldComp);
        this.initParent(newComp, oldComp);
        this.initMaxLength(newComp, oldComp);
    }

    protected void initF7(ComponentInfo newComp, ComponentInfo oldComp) {
        String classType = newComp.getClassType();
        if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(classType)) {
            this.initDisplayformat(newComp, oldComp);
            this.initFilteritem(newComp, oldComp);
        }
    }

    protected void initDisplayformat(ComponentInfo newComp, ComponentInfo oldComp) {
        String display2;
        String display = newComp.getExtendedProperty(displayFormat);
        if (!this.equals(display, display2 = oldComp.getExtendedProperty(displayFormat))) {
            this.propertyValues.put(displayFormat, display);
        }
    }

    protected void initFilteritem(ComponentInfo newComp, ComponentInfo oldComp) {
        String filterExpr2;
        String filterExpr = newComp.getExtendedProperty(filterItem);
        if (!this.equals(filterExpr, filterExpr2 = oldComp.getExtendedProperty(filterItem))) {
            this.propertyValues.put(filterItem, filterExpr);
        }
    }

    protected void initHorizontalalignment(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(horizontalAlignment);
        PropertyInfo property2 = oldComp.getPropertyByName(horizontalAlignment);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            try {
                this.propertyValues.put(horizontalAlignment, Integer.valueOf(value));
            }
            catch (Exception e) {
                logger.info((Object)e, (Throwable)e);
            }
        }
    }

    protected void initEnable(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(enable);
        PropertyInfo property2 = oldComp.getPropertyByName(enable);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            if ("false".equalsIgnoreCase(value)) {
                this.propertyValues.put(enable, Boolean.FALSE);
            } else {
                this.propertyValues.put(enable, Boolean.TRUE);
            }
        }
    }

    protected void initRequire(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyBindingCollection bindings = newComp.getPropertyBindings();
        if (!bindings.isEmpty()) {
            PropertyInfo property = newComp.getPropertyByName(require);
            PropertyInfo property2 = oldComp.getPropertyByName(require);
            if (property != null && !this.equals(property, property2)) {
                String value = property.getValue();
                if ("true".equalsIgnoreCase(value)) {
                    this.propertyValues.put(require, Boolean.TRUE);
                } else {
                    this.propertyValues.put(require, Boolean.FALSE);
                }
            }
        }
    }

    protected void initVisible(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(visible);
        PropertyInfo property2 = oldComp.getPropertyByName(visible);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            if ("false".equalsIgnoreCase(value)) {
                this.propertyValues.put(visible, Boolean.FALSE);
            } else {
                this.propertyValues.put(visible, Boolean.TRUE);
            }
        }
    }

    protected void initText(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(text);
        PropertyInfo property2 = oldComp.getPropertyByName(text);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            this.propertyValues.put(text, value);
        }
    }

    protected void initLabelContainer(ComponentInfo newComp, ComponentInfo oldComp) {
        String classType = newComp.getClassType();
        if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(classType)) {
            this.initBoundlabeltext(newComp, oldComp);
            this.initBoundlabellength(newComp, oldComp);
            this.initBoundlabelunderline(newComp, oldComp);
            this.initBoundlabelalignment(newComp, oldComp);
        }
    }

    protected void initBoundlabeltext(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(boundLabelText);
        PropertyInfo property2 = oldComp.getPropertyByName(boundLabelText);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            this.propertyValues.put(boundLabelText, value);
        }
    }

    protected void initBoundlabellength(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(boundLabelLength);
        PropertyInfo property2 = oldComp.getPropertyByName(boundLabelLength);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            try {
                this.propertyValues.put(boundLabelLength, Integer.valueOf(value));
            }
            catch (Exception e) {
                logger.info((Object)e, (Throwable)e);
            }
        }
    }

    protected void initBoundlabelunderline(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(boundLabelUnderline);
        PropertyInfo property2 = oldComp.getPropertyByName(boundLabelUnderline);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            if ("false".equalsIgnoreCase(value)) {
                this.propertyValues.put(boundLabelUnderline, Boolean.FALSE);
            } else {
                this.propertyValues.put(boundLabelUnderline, Boolean.TRUE);
            }
        }
    }

    protected void initBoundlabelalignment(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(boundLabelAlignment);
        PropertyInfo property2 = oldComp.getPropertyByName(boundLabelAlignment);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            try {
                this.propertyValues.put(boundLabelAlignment, Integer.valueOf(value));
            }
            catch (Exception e) {
                logger.info((Object)e, (Throwable)e);
            }
        }
    }

    protected void initConstraints(ComponentInfo newComp, ComponentInfo oldComp) {
        Object constraint = newComp.getConstraint();
        Object constraint2 = oldComp.getConstraint();
        if (constraint != null && !constraint.equals(constraint2)) {
            this.propertyValues.put(constraints, constraint);
        }
    }

    protected void initParent(ComponentInfo newComp, ComponentInfo oldComp) {
        ComponentInfo parent = newComp.getParent();
        ComponentInfo parent2 = oldComp.getParent();
        if (parent != null && parent2 != null) {
            String name = parent.getName();
            String name2 = parent2.getName();
            if (!StringUtils.isEmpty((String)name) && !name.equals(name2)) {
                this.propertyValues.put(parent, name);
            }
        }
    }

    protected void initMaxLength(ComponentInfo newComp, ComponentInfo oldComp) {
        PropertyInfo property = newComp.getPropertyByName(maxLength);
        PropertyInfo property2 = oldComp.getPropertyByName(maxLength);
        if (property != null && !this.equals(property, property2)) {
            String value = property.getValue();
            try {
                this.propertyValues.put(maxLength, Integer.valueOf(value));
            }
            catch (Exception e) {
                logger.info((Object)e, (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    protected boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    protected boolean equals(PropertyInfo property1, PropertyInfo property2) {
        if (property1 == null) {
            return property2 == null;
        }
        if (property2 == null) {
            return false;
        }
        return this.equals(property1.getValue(), property2.getValue());
    }
}

