/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class FocusTraversalPolicy {
    private CoreUI baseUI;
    private Map localCtx;
    private Component component;

    protected FocusTraversalPolicy(CoreUI baseUI, Map localCtx) {
        this.baseUI = baseUI;
        this.localCtx = localCtx;
    }

    public void doFocusTraversalPolicy(ComponentInfo parent) {
        Component[] components = this.getComponents(parent);
        if (components != null && components.length > 0) {
            this.baseUI.setFocusTraversalPolicy((java.awt.FocusTraversalPolicy)new UIFocusTraversalPolicy(components));
            this.baseUI.setFocusCycleRoot(true);
            this.component = components[0];
            this.handleAddOnShow();
        }
    }

    private void handleAddOnShow() {
        if (this.baseUI instanceof EditUI) {
            ((EditUI)this.baseUI).getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)new UILifeCycleImp(){

                public void handOnShow() {
                    FocusTraversalPolicy.this.component.requestFocusInWindow();
                }
            });
        }
    }

    private Component[] getComponents(ComponentInfo parent) {
        int i;
        ArrayList<JComponent> componentsList = new ArrayList<JComponent>();
        ArrayList result = new ArrayList();
        HashMap tmp = new HashMap();
        ArrayList tmp1 = new ArrayList();
        HashMap tmp2 = new HashMap();
        ArrayList tmp21 = new ArrayList();
        ComponentCollection col = parent.getComponents();
        int size = col.size();
        for (i = 0; i < size; ++i) {
            ComponentInfo allComponent = col.get(i);
            Integer listTabIndex = new Integer(allComponent.getTabIndex());
            ComponentInfo[] childCol = this.order(allComponent);
            if (childCol.length > 0) {
                this.setChildTmps(allComponent, tmp, tmp1, tmp2, tmp21);
                continue;
            }
            this.setTmps(allComponent, allComponent, listTabIndex, tmp, tmp1, tmp2, tmp21);
        }
        Collections.sort(tmp1);
        if (tmp1.size() == 0) {
            return null;
        }
        for (i = 0; i < tmp1.size(); ++i) {
            Integer listTabIndex = (Integer)tmp1.get(i);
            List tmpList = (List)tmp.get(listTabIndex);
            for (int j = 0; j < tmpList.size(); ++j) {
                if (tmpList.get(j) == null) continue;
                result.add(tmpList.get(j));
            }
        }
        Collections.sort(tmp21);
        for (i = 0; i < tmp21.size(); ++i) {
            List tmpList = (List)tmp2.get(tmp21.get(i));
            for (int j = 0; j < tmpList.size(); ++j) {
                if (tmpList.get(j) == null) continue;
                result.add(tmpList.get(j));
            }
        }
        for (i = 0; i < result.size(); ++i) {
            JComponent component;
            ComponentInfo cInfo = (ComponentInfo)result.get(i);
            if (!this.localCtx.containsKey(cInfo.getName()) || (component = (JComponent)this.localCtx.get(cInfo.getName())) == null) continue;
            componentsList.add(component);
        }
        return componentsList.toArray(new Component[componentsList.size()]);
    }

    private void setChildTmps(ComponentInfo parent, Map tmp, List tmp1, Map tmp2, List tmp21) {
        ComponentInfo[] childCol = this.order(parent);
        for (int j = 0; j < childCol.length; ++j) {
            ComponentInfo ctrl = childCol[j];
            if (ctrl == null) continue;
            Integer listTabIndex = new Integer(ctrl.getTabIndex());
            ComponentInfo[] childCol2 = this.order(ctrl);
            if (childCol2.length > 0) {
                this.setChildTmps(ctrl, tmp, tmp1, tmp2, tmp21);
                continue;
            }
            this.setTmps(ctrl, parent, listTabIndex, tmp, tmp1, tmp2, tmp21);
        }
    }

    private void setTmps(ComponentInfo ctrl, ComponentInfo parent, Integer listTabIndex, Map tmp, List tmp1, Map tmp2, List tmp21) {
        if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDSeparator".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTree".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTreeView".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDSlider".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDProgressBar".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDPanel".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDScrollPane".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDSplitPane".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDToolBar".equals(ctrl.getClassType()) || "javax.swing.JToolBar.Separator".equals(ctrl.getClassType())) {
            return;
        }
        double rowOrder = 0.0;
        double x = 0.0;
        if (Integer.parseInt(listTabIndex.toString()) > 0) {
            if (tmp.containsKey(listTabIndex)) {
                List tmpList = (List)tmp.get(listTabIndex);
                tmpList.add(ctrl);
                tmp.put(listTabIndex, tmpList);
            } else {
                ArrayList<ComponentInfo> tmpList = new ArrayList<ComponentInfo>();
                tmpList.add(ctrl);
                tmp.put(listTabIndex, tmpList);
                tmp1.add(listTabIndex);
            }
        } else {
            if (parent.getConstraint() instanceof Rectangle) {
                rowOrder = ((Rectangle)parent.getConstraint()).getY();
                x = ((Rectangle)parent.getConstraint()).getX();
            }
            if (tmp2.containsKey(new Double(rowOrder))) {
                List tmpList = (List)tmp2.get(new Double(rowOrder));
                boolean flag = false;
                for (int k = 0; k < tmpList.size(); ++k) {
                    ComponentInfo cInfo = ((ComponentInfo)tmpList.get(k)).getParent();
                    if (!(cInfo.getConstraint() instanceof Rectangle) || !(x < ((Rectangle)cInfo.getConstraint()).getX())) continue;
                    tmpList.add(k, ctrl);
                    flag = true;
                    break;
                }
                if (!flag) {
                    tmpList.add(ctrl);
                }
                tmp2.put(new Double(rowOrder), tmpList);
            } else {
                ArrayList<ComponentInfo> tmpList = new ArrayList<ComponentInfo>();
                tmpList.add(ctrl);
                tmp2.put(new Double(rowOrder), tmpList);
                tmp21.add(new Double(rowOrder));
            }
        }
    }

    private ComponentInfo[] order(ComponentInfo cInfo) {
        if (cInfo == null) {
            return new ComponentInfo[0];
        }
        Object[] components = cInfo.getComponents().toArray();
        Arrays.sort(components, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof ComponentInfo && arg1 instanceof ComponentInfo) {
                    ComponentInfo info0 = (ComponentInfo)arg0;
                    ComponentInfo info1 = (ComponentInfo)arg1;
                    if (info0.getConstraint() instanceof Integer && info1.getConstraint() instanceof Integer) {
                        Integer index0 = (Integer)info0.getConstraint();
                        Integer index1 = (Integer)info1.getConstraint();
                        return index0.compareTo(index1);
                    }
                    return -1;
                }
                return -1;
            }
        });
        ComponentInfo[] cs = new ComponentInfo[components.length];
        System.arraycopy(components, 0, cs, 0, components.length);
        return cs;
    }
}

