/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.bs.ml.client.MLClientUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class FormatXmlHelper {
    public static String getFormatXml(ComponentInfo tableControl, ResourceBundleHelper helper) {
        PropertyInfo property = tableControl.getProperties().get("formatXml");
        if (property == null) {
            return null;
        }
        String formatxml = "";
        boolean isMultiLanguages = false;
        String currentCode = BOSLocaleUtil.getShortCode((Locale)LocaleUtils.getDefaultOriginLocale());
        boolean isZH = currentCode != null && currentCode.equals(BOSLocaleUtil.getShortCode((Locale)BOSLocaleUtil.ZH_CN));
        try {
            isMultiLanguages = !isZH && ResourceListenerManager.isMultiLanguages() && MLClientUtils.getLanguageComboModel((boolean)false).getSize() > 0;
        }
        catch (Throwable t) {
            isMultiLanguages = ResourceListenerManager.isMultiLanguages();
        }
        if (isMultiLanguages) {
            formatxml = property.getValue(BOSLocaleUtil.ZH_CN);
            StringBuffer sb = new StringBuffer();
            sb.append(formatxml);
            int rows = 0;
            int g = 0;
            while ((g = sb.indexOf("<t:Row", g)) >= 0) {
                ++rows;
                g += 6;
            }
            String[] columnNames = KDTableDesignerHelper.getTableInfoFrom((String)formatxml).getColumnNameList();
            int eIndex = 0;
            String startToken = "<t:Cell>";
            String endToken = "</t:Cell>";
            block3: for (g = 0; g < rows; ++g) {
                for (int t = 0; t < columnNames.length; ++t) {
                    String name = columnNames[t];
                    int[] find = FormatXmlHelper.indexof(sb.toString(), eIndex);
                    if (find == null) continue block3;
                    startToken = sb.substring(find[0], find[1] + 1);
                    int sIndex = find[0];
                    eIndex = sb.indexOf("</t:Cell>", sIndex);
                    if (eIndex == -1) continue block3;
                    if (g != 0) {
                        name = name + "_Row" + (g + 1);
                    }
                    String defalutName = sb.substring(sIndex + startToken.length(), eIndex);
                    String repName = FormatXmlHelper.createTitle(name, g, tableControl.getName(), defalutName, helper);
                    sb.replace(sIndex + startToken.length(), eIndex, repName);
                    eIndex = sIndex + startToken.length() + repName.length() + "</t:Cell>".length();
                }
            }
            formatxml = sb.toString();
        } else {
            formatxml = property.getValue();
        }
        return formatxml;
    }

    private static int[] indexof(String context, int start_pos) {
        int second;
        String a = "<t:Cell";
        String b = ">";
        int first = context.indexOf(a, start_pos);
        if (first != -1 && (second = context.indexOf(b, first + a.length())) != -1) {
            return new int[]{first, second};
        }
        return null;
    }

    private static String createTitle(String columnName, int headIndex, String prefix, String suggenstName, ResourceBundleHelper helper) {
        String title = "";
        try {
            title = helper.getString(prefix + "." + columnName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)title) || title.equalsIgnoreCase("null") || title.toLowerCase().indexOf("not matched") >= 0) {
            title = suggenstName;
        }
        return title;
    }
}

