/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.layout.BooleanPropertyValue;
import com.kingdee.bos.ui.layout.IntegerPropertyValue;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.bos.ui.layout.StringPropertyValue;
import com.kingdee.bos.ui.layout.UIComponentConfigInfo;
import com.kingdee.bos.ui.layout.UIKDMenuConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTabbedPaneConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTableConfigInfo;
import com.kingdee.bos.ui.layout.UIKDToolbarConfigInfo;
import com.kingdee.bos.ui.layout.UILayoutConfigInfo;
import com.kingdee.eas.ep.client.runtime.NewUILayoutExecutorHelper;
import com.kingdee.eas.ep.client.runtime.UISegmentAssemblerHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.UILifeCycleHander;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class NewUILayoutExecutor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.expression.UILayoutExecutor");
    private UILayoutConfigInfo cfgUI;
    DataBinder dataBinder;
    BizUnitInfo bizUnit;
    EntityObjectInfo entity;
    UILifeCycleHander handler;
    private CoreUI ui = null;
    private Map localCtx;
    private boolean isExecuting = false;
    public static final String CONTAINER = "container";

    public NewUILayoutExecutor(CoreUI targetUI, Context ctx, Map localCtx, UILayoutConfigInfo cfgUI, DataBinder dataBinder, UILifeCycleHander handler) {
        this.cfgUI = cfgUI;
        this.localCtx = localCtx;
        this.dataBinder = dataBinder;
        this.handler = handler;
        this.ui = targetUI;
    }

    public void execute() throws Exception {
        if (!this.isExecuting && this.cfgUI != null) {
            UIComponentConfigInfo cInfo;
            int i;
            this.ui.setUITitle(this.cfgUI.getTitle());
            List col = this.cfgUI.getMainPanelComponentConfig();
            int n = col.size();
            for (i = 0; i < n; ++i) {
                cInfo = (UIComponentConfigInfo)col.get(i);
                if (cInfo.getName().isNull() || !this.localCtx.containsKey(cInfo.getName().getStringValue())) continue;
                JComponent component = (JComponent)this.localCtx.get(cInfo.getName().getStringValue());
                KDRectangle rect = null;
                if (!cInfo.getConstraint().isNull()) {
                    rect = cInfo.getConstraint().getValue();
                }
                if ("CoreUI".equals(cInfo.getName().getStringValue()) && rect != null) {
                    Rectangle rectangle = rect.getRectangle();
                    Rectangle bounds = component.getBounds();
                    if (bounds.equals(rectangle)) continue;
                    component.setBounds(rectangle);
                    component.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
                    if (!(component.getLayout() instanceof KDLayout)) continue;
                    component.putClientProperty("OriginalBounds", rectangle);
                    continue;
                }
                KDLabelContainer lblContainer = this.getLabelContainer(component);
                if (lblContainer != null) {
                    BooleanPropertyValue labelUnderline;
                    IntegerPropertyValue labelAlign;
                    component = lblContainer;
                    IntegerPropertyValue labelLength = cInfo.getLabelLength();
                    if (!labelLength.isNull()) {
                        lblContainer.setBoundLabelLength(cInfo.getLabelLength().getValue().intValue(), false);
                    }
                    if (!(labelAlign = cInfo.getLabelAlign()).isNull()) {
                        lblContainer.setBoundLabelAlignment(cInfo.getLabelAlign().getValue().intValue(), false);
                    }
                    if (!(labelUnderline = cInfo.getLabelUnderline()).isNull()) {
                        lblContainer.setBoundLabelUnderline(cInfo.getLabelUnderline().getValue().booleanValue(), false);
                    }
                }
                Container container = null;
                StringPropertyValue containerValue = cInfo.getContainer();
                if (!containerValue.isNull() && this.localCtx.containsKey(containerValue.getStringValue())) {
                    container = (Container)this.localCtx.get(containerValue.getStringValue());
                }
                this.layoutComponent(container, component, rect);
            }
            col = this.cfgUI.getKDTableConfigInfo();
            n = col.size();
            for (i = 0; i < n; ++i) {
                cInfo = (UIKDTableConfigInfo)col.get(i);
                if (cInfo.getName().isNull() || !this.localCtx.containsKey(cInfo.getName().getStringValue())) continue;
                JComponent table = (JComponent)this.localCtx.get(cInfo.getName().getStringValue());
                this.reOrderEntryColumn(table, (UIKDTableConfigInfo)cInfo);
            }
            col = this.cfgUI.getKDTabbedPaneConfigInfo();
            n = col.size();
            for (i = 0; i < n; ++i) {
                cInfo = (UIKDTabbedPaneConfigInfo)col.get(i);
                if (cInfo.getName().isNull() || !this.localCtx.containsKey(cInfo.getName().getStringValue())) continue;
                JComponent tabbedpane = (JComponent)this.localCtx.get(cInfo.getName().getStringValue());
                this.reOrderTabbedPane(tabbedpane, (UIKDTabbedPaneConfigInfo)cInfo);
            }
            col = this.cfgUI.getKDToolbarConfigInfo();
            n = col.size();
            for (i = 0; i < n; ++i) {
                cInfo = (UIKDToolbarConfigInfo)col.get(i);
                if (cInfo.getName().isNull() || !this.localCtx.containsKey(cInfo.getName().getStringValue())) continue;
                JComponent toolbar = (JComponent)this.localCtx.get(cInfo.getName().getStringValue());
                this.reOrderToolbar(toolbar, (UIKDToolbarConfigInfo)cInfo);
            }
            col = this.cfgUI.getKDMenuConfigInfo();
            n = col.size();
            for (i = 0; i < n; ++i) {
                cInfo = (UIKDMenuConfigInfo)col.get(i);
                if (cInfo.getName().isNull() || !this.localCtx.containsKey(cInfo.getName().getStringValue())) continue;
                JComponent menu = (JComponent)this.localCtx.get(cInfo.getName().getStringValue());
                this.reOrderMenu(menu, (UIKDMenuConfigInfo)cInfo);
            }
        }
        this.isExecuting = true;
    }

    private void reOrderEntryColumn(JComponent table, UIKDTableConfigInfo cInfo) {
        if (table instanceof KDTable && cInfo != null) {
            NewUILayoutExecutorHelper.reOrderTableColumn((KDTable)table, cInfo);
        }
    }

    private void reOrderTabbedPane(JComponent tabPane, UIKDTabbedPaneConfigInfo cInfo) {
        if (tabPane instanceof KDTabbedPane && cInfo != null) {
            NewUILayoutExecutorHelper.reOrderTabbedPane((KDTabbedPane)tabPane, cInfo);
        }
    }

    private void reOrderToolbar(JComponent toolbar, UIKDToolbarConfigInfo cInfo) {
        if (toolbar instanceof KDToolBar && cInfo != null) {
            NewUILayoutExecutorHelper.reOrderToolbar((KDToolBar)toolbar, cInfo);
        }
    }

    private void reOrderMenu(JComponent menu, UIKDMenuConfigInfo cInfo) {
        if (cInfo != null) {
            if (menu instanceof KDMenu) {
                NewUILayoutExecutorHelper.reOrderMenu((KDMenu)menu, cInfo);
            } else if (menu instanceof KDMenuBar) {
                NewUILayoutExecutorHelper.reOrderMenuBar((KDMenuBar)menu, cInfo);
            }
        }
    }

    private KDLabelContainer getLabelContainer(JComponent component) {
        Container tmp = component;
        if (tmp.getParent() == null) {
            return null;
        }
        if (tmp.getParent() instanceof JViewport) {
            tmp = tmp.getParent();
        }
        if (tmp.getParent() instanceof KDScrollPane) {
            tmp = tmp.getParent();
        }
        if (tmp.getParent() instanceof KDLabelContainer) {
            return (KDLabelContainer)tmp.getParent();
        }
        return null;
    }

    private void layoutComponent(Container container, JComponent component, KDRectangle rect) {
        Object constraint;
        if (rect == null) {
            constraint = component.getClientProperty("KDLayoutConstraints");
            rect = constraint != null && constraint instanceof KDLayout.Constraints ? new KDRectangle(((KDLayout.Constraints)constraint).originalBounds, ((KDLayout.Constraints)constraint).anchor) : new KDRectangle(component.getBounds());
        } else if (UISegmentAssemblerHelper.isKDLayout(component)) {
            component.putClientProperty("OriginalBounds", rect.getRectangle());
        }
        if (container == null || container.equals(component.getParent())) {
            KDTable table;
            if (component instanceof KDTable && (table = (KDTable)component).getParent() != null && table.getParent().getParent() != null) {
                if (table.getParent().getParent() instanceof DetailPanel) {
                    component = (JComponent)table.getParent().getParent();
                } else if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(table.getParent().getParent().getClass().getName())) {
                    return;
                }
            }
            if (UISegmentAssemblerHelper.isKDLayout(component.getParent())) {
                constraint = component.getClientProperty("KDLayoutConstraints");
                if (constraint != null && constraint instanceof KDLayout.Constraints) {
                    ((KDLayout.Constraints)constraint).originalBounds = new Rectangle(rect.getRectangle());
                    ((KDLayout.Constraints)constraint).anchor = rect.getAnchor();
                }
                component.setBounds(new Rectangle(rect.getRectangle()));
            } else {
                component.setBounds(new Rectangle(rect.getRectangle()));
            }
        } else {
            JComponent contentPane = UISegmentAssemblerHelper.getContentPane((JComponent)container);
            if (UISegmentAssemblerHelper.isKDLayout(container)) {
                KDLayout.Constraints constraint2 = new KDLayout.Constraints(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), rect.getAnchor());
                component.setBounds(new Rectangle(rect.getRectangle()));
                contentPane.add((Component)component, constraint2);
            } else {
                component.setBounds(new Rectangle(rect.getRectangle()));
                contentPane.add((Component)component, new Rectangle(rect.getRectangle()));
            }
        }
    }

    public void destroy() {
    }
}

