/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import com.kingdee.bos.ui.layout.UIKDMenuConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTabbedPaneConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTableConfigInfo;
import com.kingdee.bos.ui.layout.UIKDToolbarConfigInfo;
import com.kingdee.eas.ep.client.runtime.DynamicExtendService;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class NewUILayoutExecutorHelper {
    private static final Logger logger = Logger.getLogger(NewUILayoutExecutorHelper.class);
    public static final String CONFIGURE_ORDER = "_Configure_Order";

    public static void initComponent(ComponentInfo cInfo, Component comp) {
        if (cInfo == null || comp == null) {
            return;
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox promt = (KDBizPromptBox)comp;
            String sQueryPK = cInfo.getExtendedProperty("defaultF7Query");
            if (!StringUtils.isEmpty((String)sQueryPK)) {
                promt.setQueryInfo(sQueryPK);
                NewUILayoutExecutorHelper.setFormatter(promt, cInfo);
                NewUILayoutExecutorHelper.setFilter(promt, cInfo);
                NewUILayoutExecutorHelper.setSelector(promt, cInfo);
            }
        } else if (comp instanceof KDComboBox) {
            KDComboBox combo = (KDComboBox)comp;
            String property = cInfo.getExtendedProperty("enumclassname");
            if (!StringUtils.isEmpty((String)property)) {
                try {
                    List enumList = new ArrayList();
                    enumList = NewUILayoutExecutorHelper.getEnumList(property);
                    if (enumList != null && enumList.size() > 0) {
                        combo.addItems(enumList.toArray());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        } else if (comp instanceof KDTextField || comp instanceof KDTextArea) {
            NewUILayoutExecutorHelper.setMaxLength(comp, cInfo);
        } else if (comp instanceof KDFormattedTextField) {
            KDFormattedTextField formatField = (KDFormattedTextField)comp;
            NewUILayoutExecutorHelper.setMinimumValue(formatField, cInfo);
            NewUILayoutExecutorHelper.setMaximumValue(formatField, cInfo);
            NewUILayoutExecutorHelper.setDataType(formatField, cInfo);
            NewUILayoutExecutorHelper.setPrecision(formatField, cInfo);
            formatField.setSupportedEmpty(true);
            NewUILayoutExecutorHelper.setFormatString(formatField, cInfo);
        }
    }

    private static void setFormatString(KDFormattedTextField comp, ComponentInfo cInfo) {
        JFormattedTextField.AbstractFormatterFactory factory;
        String format = cInfo.getExtendedProperty("formatString");
        if (!StringUtils.isEmpty((String)format) && (factory = comp.getFormatterFactory()) instanceof DefaultFormatterFactory) {
            ((DefaultFormatterFactory)factory).setDisplayFormatter(new NumberFormatter(new DecimalFormat(format)));
        }
    }

    private static void setDataType(KDFormattedTextField comp, ComponentInfo cInfo) {
        PropertyBindingCollection bindings = cInfo.getPropertyBindings();
        if (bindings.size() > 0 && "int".equals(bindings.get(0).getFieldType())) {
            comp.setDataType(0);
        } else {
            comp.setDataType(1);
        }
    }

    private static void setPrecision(KDFormattedTextField comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("precision");
        if (property != null) {
            try {
                int precision = Integer.valueOf(property.getValue());
                if (precision != -1) {
                    comp.setPrecision(precision);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void setMaxLength(Component comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("maxLength");
        if (property != null) {
            try {
                int maxLength = Integer.parseInt(property.getValue());
                if (maxLength > 0) {
                    if (comp instanceof KDTextField) {
                        ((KDTextField)comp).setMaxLength(maxLength);
                    } else if (comp instanceof KDTextArea) {
                        ((KDTextArea)comp).setMaxLength(maxLength);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void setMaximumValue(KDFormattedTextField comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("maximumValue");
        if (property != null) {
            BigDecimal max = new BigDecimal("1.0E18");
            try {
                String MAXIMUMVALUE = property.getValue().replaceAll("\"", "");
                if (!StringUtils.isEmpty((String)MAXIMUMVALUE)) {
                    max = new BigDecimal(MAXIMUMVALUE);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            comp.setMaximumValue((Comparable)max);
        }
    }

    private static void setMinimumValue(KDFormattedTextField comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("minimumValue");
        if (property != null) {
            BigDecimal min = new BigDecimal("-1.0E18");
            try {
                String MINIMUMVALUE = property.getValue().replaceAll("\"", "");
                if (!StringUtils.isEmpty((String)MINIMUMVALUE)) {
                    min = new BigDecimal(MINIMUMVALUE);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            comp.setMinimumValue((Comparable)min);
        }
    }

    private static void setFormatter(KDBizPromptBox promt, ComponentInfo cInfo) {
        Object objField = NewUILayoutExecutorHelper.getBindFieldObject(cInfo);
        String display = cInfo.getExtendedProperty("displayFormat");
        if (StringUtils.isEmpty((String)display)) {
            Class<?> clas;
            display = objField instanceof AbstractDataBaseInfo ? "$name$" : (NewUILayoutExecutorHelper.existMethod(clas = objField.getClass(), "getName") ? "$name$" : (NewUILayoutExecutorHelper.existMethod(clas, "getNumber") ? "$number$" : "$id$"));
        }
        promt.setDisplayFormat(display);
        if (objField instanceof AbstractDataBaseInfo) {
            promt.setEditFormat("$number$");
            promt.setCommitFormat("$number$");
        } else {
            promt.setEditFormat(display);
            promt.setCommitFormat(display);
        }
    }

    private static void setFilter(KDBizPromptBox promt, ComponentInfo cInfo) {
        String filterExpr = cInfo.getExtendedProperty("f7FilterItem");
        if (!StringUtils.isEmpty((String)filterExpr)) {
            EntityViewInfo v = new EntityViewInfo();
            try {
                v.setFilter(filterExpr);
            }
            catch (ParserException e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
            promt.setEntityViewInfo(v);
        }
    }

    private static void setSelector(KDBizPromptBox promt, ComponentInfo cInfo) {
        String selector = cInfo.getExtendedProperty("defaultf7uiname");
        if (!StringUtils.isEmpty((String)selector)) {
            promt.setDefaultF7UIName(selector.trim());
            NewUILayoutExecutorHelper.setSelector(selector, promt);
        } else {
            selector = cInfo.getExtendedProperty("f7UsedListUIClassName");
            NewUILayoutExecutorHelper.setSelector(selector, promt);
        }
    }

    private static boolean existMethod(Class<? extends Object> cls, String methodName) {
        try {
            cls.getMethod("getName", new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static List getEnumList(String enumpk) {
        MetaDataPK entitypk = MetaDataPK.create((String)enumpk);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)entitypk);
        if (bizEnum.isDynamic()) {
            return DynamicEnum.getEnumList((String)enumpk);
        }
        return EnumUtils.getEnumList((String)enumpk);
    }

    private static Object getBindFieldObject(ComponentInfo cInfo) {
        PropertyBindingInfo propBindInfo = cInfo.getPropertyBindings().get(0);
        String propType = propBindInfo.getFieldType();
        Object obj = null;
        try {
            Class<?> objClass = Class.forName(propType);
            obj = objClass.newInstance();
        }
        catch (Exception e2) {
            logger.error((Object)"NewUILayoutExecutorHelper.getBindFieldObject", (Throwable)e2);
        }
        return obj;
    }

    public static void initKDTable(CoreUI coreUI, UIObjectInfo uiObject, ComponentInfo tableControl, KDTable kdtEntrys, TableInfo tableInfo, DynamicExtendService service) {
        if (coreUI == null || tableControl == null || kdtEntrys == null || tableInfo == null) {
            return;
        }
        String formatXmlExt = tableControl.getExtendedProperty("extend_formatxml");
        TableInfoHelper.parseFormatXmlExt((TableInfo)tableInfo, (String)formatXmlExt);
        String orders = tableControl.getExtendedProperty("column_order");
        NewUILayoutExecutorHelper.reOrderTableFormatXml(tableInfo, orders);
        String formatXml = KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo);
        System.out.println(formatXml);
        logger.error((Object)formatXml);
        List columns = tableInfo.getColumns();
        String[] bindFields = new String[columns.size()];
        Map map = NewUILayoutExecutorHelper.getPropertyMap(uiObject, tableControl);
        logger.info((Object)"----start bindfield----------");
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            String columnName = columnInfo.getName();
            String bindField = (String)map.get(columnName);
            bindFields[i] = bindField == null ? "" : bindField;
            logger.info((Object)("columnName:" + columnName + ";bindField:" + bindFields[i]));
        }
        logger.info((Object)"----end bindfield----------");
        String bindObjectName = NewUILayoutExecutorHelper.getBindingObject(tableControl);
        NewUILayoutExecutorHelper.setTableRequired(kdtEntrys, tableInfo, service);
        HashMap tableEditorRenderMap = NewUILayoutExecutorHelper.getTableEditorAndRenderToMap(kdtEntrys);
        kdtEntrys.removeColumns();
        logger.info((Object)"\u91cd\u65b0\u8bbe\u7f6ekdtEntrys\u7684formatXml");
        kdtEntrys.setFormatXml(formatXml);
        if (!StringUtils.isEmpty((String)bindObjectName)) {
            logger.info((Object)"\u91cd\u65b0\u7ed1\u5b9akdtEntrys\u7684bindContents");
            kdtEntrys.putBindContents(bindObjectName, bindFields);
            logger.info((Object)"\u91cd\u65b0\u6784\u5efakdtEntrys\u7684\u5217");
        }
        kdtEntrys.checkParsed(true);
        kdtEntrys.getGroupManager().setGroup(true);
        if (!StringUtils.isEmpty((String)bindObjectName)) {
            NewUILayoutExecutorHelper.registerBinding4Table(kdtEntrys, tableControl, coreUI.getDataBinder());
        }
        NewUILayoutExecutorHelper.setTableEditorAndRenderToMap(kdtEntrys, tableEditorRenderMap);
        if (coreUI instanceof EditUI && tableControl != null) {
            NewUILayoutExecutorHelper.initCellEditor(tableControl, kdtEntrys, tableInfo);
            NewUILayoutExecutorHelper.setTableSum((EditUI)coreUI, kdtEntrys, tableControl, tableInfo);
        }
        if (coreUI instanceof ListUI) {
            ((ListUI)coreUI).setCfgFormatXml(formatXml);
        }
        NewUILayoutExecutorHelper.setTableDateFormat(kdtEntrys, tableControl);
    }

    private static String getBindingObject(ComponentInfo tableControl) {
        String bindObjectName = null;
        int n = tableControl.getPropertyBindings().size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = tableControl.getPropertyBindings().get(i);
            if (pbInfo == null || StringUtils.isEmpty((String)pbInfo.getBindingObject())) continue;
            bindObjectName = pbInfo.getBindingObject();
            break;
        }
        return bindObjectName;
    }

    private static void setTableDateFormat(KDTable table, ComponentInfo tableControl) {
        PropertyBindingCollection col = tableControl.getPropertyBindings();
        for (int i = 0; i < col.size(); ++i) {
            String columnKey = StringUtils.replace((String)col.get(i).getPropertyName(), (String)".text", (String)"");
            IColumn column = table.getColumn(columnKey);
            if (column == null || !"java.util.Date".equals(col.get(i).getFieldType()) || column.getStyleAttributes().getNumberFormat() != null) continue;
            if (CtrlFormatUtilities.getDateFormatString() != null) {
                table.getColumn(columnKey).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
                continue;
            }
            column.getStyleAttributes().setNumberFormat("yyyy-mm-dd");
        }
    }

    private static boolean reOrderTableFormatXml(TableInfo tableInfo, String order) {
        if (tableInfo == null || StringUtils.isEmpty((String)order) || tableInfo.getMergeBlockCount() > 0) {
            return false;
        }
        String[] orders = order.split("\\|");
        if (orders == null) {
            return false;
        }
        ArrayList<String> listColumnNames = new ArrayList<String>(orders.length);
        int size = orders.length;
        for (int j = 0; j < size; ++j) {
            listColumnNames.add(orders[j]);
        }
        NewUILayoutExecutorHelper.reOrderTableFormatXml(tableInfo, listColumnNames);
        return true;
    }

    public static void reOrderTableFormatXml(TableInfo tableInfo, List list) {
        if (tableInfo == null || list == null) {
            return;
        }
        int m = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int index = NewUILayoutExecutorHelper.getColumnIndexByName(tableInfo, list.get(i).toString());
            if (index == -1) continue;
            NewUILayoutExecutorHelper.moveKDTableColumn(tableInfo, index, m);
            ++m;
        }
    }

    public static int getColumnIndexByName(TableInfo table, String columnName) {
        if (table == null || StringUtils.isEmpty((String)columnName)) {
            return -1;
        }
        String[] names = table.getColumnNameList();
        int size = names.length;
        for (int i = 0; i < size; ++i) {
            if (!columnName.equals(names[i])) continue;
            return i;
        }
        return -1;
    }

    public static void moveKDTableColumn(TableInfo table, int from, int to) {
        if (table != null && from >= 0 && to >= 0 && from != to && table.getHeaderCount() > 0) {
            int count;
            int n = table.getHeaderCount();
            for (int i = 0; i < n; ++i) {
                HeaderInfo headerInfo = (HeaderInfo)table.getHeaders().get(i);
                count = headerInfo.getCellCount();
                if (from >= count || to >= count) continue;
                ArrayList cells = headerInfo.getCells();
                Object obj = cells.remove(from);
                cells.add(to, obj);
            }
            count = table.getColumnCount();
            if (from < count && to < count) {
                List columns = table.getColumns();
                Object obj = columns.remove(from);
                columns.add(to, obj);
            }
        }
    }

    private static void setTableEditorAndRenderToMap(KDTable table, HashMap tableEditorRenderMap) {
        if (table == null || table.getColumns() == null || table.getColumns().size() == 0 || tableEditorRenderMap == null) {
            return;
        }
        KDTColumns columns = table.getColumns();
        KDTColumn column = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = columns.getColumn(i);
            if (tableEditorRenderMap.get(column.getKey()) == null) continue;
            HashMap maps = (HashMap)tableEditorRenderMap.get(column.getKey());
            if (maps.get("TableEditor") != null) {
                column.setEditor((ICellEditor)maps.get("TableEditor"));
            }
            if (maps.get("TableRender") == null) continue;
            column.setRenderer((IBasicRender)maps.get("TableRender"));
        }
    }

    private static HashMap getTableEditorAndRenderToMap(KDTable table) {
        if (table == null || table.getColumns() == null || table.getColumns().size() == 0) {
            return null;
        }
        HashMap tableEditorRenderMap = new HashMap();
        KDTColumns columns = table.getColumns();
        KDTColumn column = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = columns.getColumn(i);
            HashMap<String, Object> maps = new HashMap<String, Object>();
            if (column.getEditor() != null) {
                maps.put("TableEditor", column.getEditor());
            }
            if (column.getRenderer() != null) {
                maps.put("TableRender", column.getRenderer());
            }
            tableEditorRenderMap.put(column.getKey(), maps);
        }
        return tableEditorRenderMap;
    }

    public static Map getPropertyMap(UIObjectInfo uiObject, ComponentInfo table) {
        HashMap<String, CharSequence> pm = new HashMap<String, CharSequence>();
        if (table != null) {
            boolean bindQuery = NewUILayoutExecutorHelper.isBindQuery(uiObject, table);
            logger.info((Object)"-----create bind map---------------");
            int n = table.getPropertyBindings().size();
            for (int j = 0; j < n; ++j) {
                PropertyBindingInfo pbInfo = table.getPropertyBindings().get(j);
                if (pbInfo.getPropertyName().indexOf(".text") >= 0) {
                    String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
                    String sbindField = pbInfo.getBingdingField();
                    if (bindQuery || sbindField == null) {
                        pm.put(columnName, sbindField);
                    } else {
                        pm.put(columnName, sbindField.subSequence(sbindField.indexOf(".") + 1, sbindField.length()));
                    }
                    logger.info((Object)("columnName:" + columnName + ";bindField:" + sbindField));
                    continue;
                }
                logger.info((Object)("** " + pbInfo.getPropertyName()));
            }
            logger.info((Object)"-----end bind map---------------");
        }
        return pm;
    }

    private static boolean isBindQuery(UIObjectInfo uiObject, ComponentInfo table) {
        DataObjectCollection dataObjects = uiObject.getDataObjects();
        PropertyBindingCollection bindings = table.getPropertyBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            PropertyBindingInfo bindingInfo = bindings.get(i);
            DataObjectInfo dataObject = dataObjects.getDataObject(bindingInfo.getBindingObject());
            if (dataObject == null || !MetaDataTypeList.UNIONQUERY.toString().equals(dataObject.getObjectType()) && !MetaDataTypeList.JOINQUERY.toString().equals(dataObject.getObjectType())) continue;
            return true;
        }
        return false;
    }

    private static void registerBinding4Table(KDTable kdtEntrys, ComponentInfo tableControl, DataBinder dataBinder) {
        if (kdtEntrys == null || tableControl == null || dataBinder == null || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(tableControl.getClassType())) {
            return;
        }
        int size = tableControl.getPropertyBindings().size();
        for (int i = 0; i < size; ++i) {
            PropertyBindingInfo propbInfo = tableControl.getPropertyBindings().get(i);
            String tempClassName = propbInfo.getFieldType();
            if ("userObject".equals(propbInfo.getPropertyName()) && tempClassName.endsWith("Collection")) {
                tempClassName = tempClassName.substring(0, tempClassName.lastIndexOf("Collection")) + "Info";
                continue;
            }
            Class clazz = NewUILayoutExecutorHelper.getClassName(tempClassName);
            if (clazz == null) continue;
            try {
                if (NewUILayoutExecutorHelper.checkColumnHasBind(dataBinder, propbInfo.getBingdingField(), kdtEntrys)) {
                    logger.info((Object)("'" + propbInfo.getBingdingField() + "' has binded, do not registerBinding again..."));
                    continue;
                }
                dataBinder.registerBinding(propbInfo.getBingdingField(), clazz, (Component)kdtEntrys, propbInfo.getPropertyName());
                logger.info((Object)("entry bind:dataBinder.registerBinding(" + propbInfo.getBingdingField() + "," + clazz + "," + kdtEntrys.getName() + "," + propbInfo.getPropertyName() + ");"));
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"bind fail", (Throwable)ex);
            }
        }
    }

    private static boolean checkColumnHasBind(DataBinder dataBinder, String bindField, KDTable kdtEntrys) {
        ArrayList fields;
        if (dataBinder == null || StringUtils.isEmpty((String)bindField) || kdtEntrys == null) {
            return false;
        }
        DataComponentMap map = dataBinder.getDataComponentMap();
        Field tableField = map.getDetail(kdtEntrys);
        if (tableField != null && (fields = map.getDetailFields(tableField)) != null) {
            for (Field columnField : fields) {
                if (!columnField.getName().equals(bindField)) continue;
                return true;
            }
        }
        return false;
    }

    private static void setTableSum(EditUI editUI, KDTable kdtEntrys, ComponentInfo tableControl, TableInfo tableInfo) {
        if (editUI == null || kdtEntrys == null || tableControl == null || tableInfo == null) {
            return;
        }
        List columns = tableInfo.getColumns();
        ArrayList<String> names = new ArrayList<String>();
        int m = columns.size();
        for (int j = 0; j < m; ++j) {
            ColumnInfo column = (ColumnInfo)columns.get(j);
            if (!Boolean.TRUE.toString().equalsIgnoreCase(column.getExtendedProperty("needSum"))) continue;
            names.add(column.getName());
        }
        if (names.size() > 0) {
            String[] columnFields = new String[names.size()];
            columnFields = names.toArray(columnFields);
            editUI.setRuleTableSumField(kdtEntrys, columnFields);
        }
    }

    private static void setTableRequired(KDTable kdtEntrys, TableInfo tableInfo, DynamicExtendService service) {
        if (kdtEntrys == null || tableInfo == null) {
            return;
        }
        List columns = tableInfo.getColumns();
        ArrayList<String> names = new ArrayList<String>();
        int m = columns.size();
        for (int j = 0; j < m; ++j) {
            ColumnInfo column = (ColumnInfo)columns.get(j);
            IColumn columnOld = kdtEntrys.getColumn(column.getName());
            if (!Boolean.TRUE.toString().equalsIgnoreCase(String.valueOf(column.isRequired())) || columnOld != null && !Boolean.FALSE.toString().equalsIgnoreCase(String.valueOf(columnOld.isRequired()))) continue;
            names.add(column.getName());
        }
        if (names.size() > 0) {
            String[] columnFields = new String[names.size()];
            columnFields = names.toArray(columnFields);
            service.addTableRequiredField(kdtEntrys, columnFields);
        }
    }

    public static void initCellEditor(ComponentInfo tableControl, KDTable kdtEntrys, TableInfo tableInfo) {
        if (tableControl == null || kdtEntrys == null) {
            return;
        }
        if (tableInfo != null) {
            List columns = tableInfo.getColumns();
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                IColumn column;
                String key;
                String defaultUIName;
                String preFixName;
                ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
                KDTDefaultCellEditor editor = NewUILayoutExecutorHelper.getCellEditor(columnInfo, preFixName = tableControl.getName() + "_" + columnInfo.getName(), defaultUIName = tableControl.getExtendedProperty(key = "defaultf7uiname." + tableControl.getName() + "." + columnInfo.getName()), tableControl);
                if (editor == null || (column = kdtEntrys.getColumn(columnInfo.getName())) == null) continue;
                column.setEditor((ICellEditor)editor);
                NewUILayoutExecutorHelper.setColumnStyle(columnInfo, column);
            }
        }
    }

    public static void reOrderTableColumn(KDTable entry, UIKDTableConfigInfo cfgInfo) {
        if (entry != null && cfgInfo != null && !cfgInfo.getColumnOrder().isNull()) {
            String order = cfgInfo.getColumnOrder().getValue();
            logger.info((Object)("------------ load " + entry.getName() + " columns' order -----------"));
            logger.info((Object)(entry.getName() + CONFIGURE_ORDER + ":" + order));
            String[] orders = order.split("\\|");
            ArrayList<String> list = new ArrayList<String>(orders.length);
            int size = orders.length;
            for (int j = 0; j < size; ++j) {
                list.add(orders[j]);
            }
            NewUILayoutExecutorHelper.reOrderTableColumn(entry, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reOrderTableColumn(KDTable entry, List names) {
        boolean moveable = entry.isColumnMoveable();
        try {
            entry.setColumnMoveable(true);
            KDTColumns columns = entry.getColumns();
            int m = 0;
            int columnCount = columns.size();
            int size = names.size();
            for (int j = 0; j < size; ++j) {
                int index = columns.getColumnIndex(names.get(j).toString());
                if (index == -1 || m >= columnCount) continue;
                entry.moveColumn(index, m);
                ++m;
            }
        }
        catch (Exception e) {
            logger.error((Object)("reset " + entry.getName() + " columns' order error"), (Throwable)e);
        }
        finally {
            entry.setColumnMoveable(moveable);
        }
    }

    public static void reOrderToolbar(KDToolBar toolbar, UIKDToolbarConfigInfo cfgInfo) {
        if (toolbar != null && cfgInfo != null) {
            String order = cfgInfo.getToolbarOrder().getValue();
            NewUILayoutExecutorHelper.reOrderToolbar(toolbar, order);
        }
    }

    public static void reOrderToolbar(KDToolBar toolbar, String order) {
        if (toolbar != null && !StringUtils.isEmpty((String)order)) {
            int i;
            Component[] components = toolbar.getToolBarComponents();
            LinkedList<Component> copy = new LinkedList<Component>();
            for (i = 0; i < components.length; ++i) {
                copy.add(components[i]);
            }
            NewUILayoutExecutorHelper.reOrder(copy, order);
            toolbar.removeAllToolBarComponents();
            for (i = 0; i < components.length; ++i) {
                if (components[i] == null) continue;
                toolbar.add((Component)copy.get(i));
            }
        }
    }

    public static void reOrderMenu(KDMenu menu, UIKDMenuConfigInfo cfgInfo) {
        if (menu != null && cfgInfo != null) {
            String order = cfgInfo.getMenuOrder().getValue();
            NewUILayoutExecutorHelper.reOrderMenu(menu, order);
        }
    }

    public static void reOrderMenu(KDMenu menu, String order) {
        if (menu != null && !StringUtils.isEmpty((String)order)) {
            int i;
            int menuCount = menu.getMenuComponentCount();
            LinkedList<Component> copy = new LinkedList<Component>();
            for (i = 0; i < menuCount; ++i) {
                copy.add(menu.getMenuComponent(i));
            }
            NewUILayoutExecutorHelper.reOrder(copy, order);
            menu.removeAll();
            for (i = 0; i < copy.size(); ++i) {
                if (copy.get(i) == null) continue;
                menu.add((Component)copy.get(i));
            }
        }
    }

    public static void reOrderMenuBar(KDMenuBar menubar, UIKDMenuConfigInfo cfgInfo) {
        if (menubar != null && cfgInfo != null) {
            String order = cfgInfo.getMenuOrder().getValue();
            NewUILayoutExecutorHelper.reOrderMenuBar(menubar, order);
        }
    }

    public static void reOrderMenuBar(KDMenuBar menubar, String order) {
        if (menubar != null && !StringUtils.isEmpty((String)order)) {
            int size = menubar.getMenuCount();
            String[] orders = order.split("\\|");
            ArrayList<JMenu> components = new ArrayList<JMenu>();
            for (int j = 0; j < orders.length; ++j) {
                for (int i = 0; i < menubar.getMenuCount(); ++i) {
                    JMenu menu = menubar.getMenu(i);
                    if (menu == null || !orders[j].equals(menu.getName())) continue;
                    components.add(menu);
                }
            }
            for (int i = 0; i < menubar.getMenuCount(); ++i) {
                JMenu menu = menubar.getMenu(i);
                if (menu == null || components.contains(menu)) continue;
                components.add(menu);
            }
            int m = 0;
            Iterator iter = components.iterator();
            while (iter.hasNext()) {
                menubar.add((Component)iter.next(), m);
                ++m;
            }
        }
    }

    private static void reOrder(List<Component> components, String order) {
        String[] orders = order.split("\\|");
        for (int i = 0; i < orders.length; ++i) {
            if (i >= components.size()) continue;
            String compName = orders[i];
            for (int j = i; j < components.size(); ++j) {
                Component comp = components.get(j);
                if (!compName.equals(comp.getName()) && (!"&KDSeparator&".equals(compName) || !(comp instanceof KDSeparator) || i == j)) continue;
                components.remove(j);
                components.add(i, comp);
            }
        }
    }

    public static void reOrderTabbedPane(KDTabbedPane entry, UIKDTabbedPaneConfigInfo cfgInfo) {
        if (entry != null && cfgInfo != null && !cfgInfo.getTabOrder().isNull()) {
            String order = cfgInfo.getTabOrder().getValue();
            logger.info((Object)("------------ load " + entry.getName() + " tabs' order -----------"));
            logger.info((Object)(entry.getName() + CONFIGURE_ORDER + ":" + order));
            if (order == null || order.length() == 0) {
                return;
            }
            String[] orders = order.split("\\|");
            ArrayList<String> list = new ArrayList<String>(orders.length);
            int size = orders.length;
            for (int j = 0; j < size; ++j) {
                list.add(orders[j]);
            }
            try {
                int i;
                int j;
                int columnCount = entry.getTabCount();
                ArrayList<TabInfo> tabs = new ArrayList<TabInfo>(columnCount);
                for (int i2 = 0; i2 < columnCount; ++i2) {
                    Component comp = entry.getComponentAt(i2);
                    String label = entry.getTitleAt(i2);
                    String tooltip = entry.getToolTipTextAt(i2);
                    Icon icon = entry.getIconAt(i2);
                    boolean enabled = entry.isEnabledAt(i2);
                    TabInfo tInfo = new TabInfo(comp, enabled, icon, label, tooltip);
                    tabs.add(tInfo);
                }
                ChangeListener[] listeners = entry.getChangeListeners();
                if (listeners != null) {
                    for (int i3 = 0; i3 < listeners.length; ++i3) {
                        entry.removeChangeListener(listeners[i3]);
                    }
                }
                for (int i4 = 0; i4 < columnCount; ++i4) {
                    entry.remove(0);
                }
                ArrayList reOrders = new ArrayList();
                int size2 = list.size();
                for (j = 0; j < size2; ++j) {
                    int index = NewUILayoutExecutorHelper.getTabIndex(tabs, list.get(j).toString());
                    if (index == -1) continue;
                    reOrders.add(tabs.get(index));
                }
                size2 = tabs.size();
                for (j = 0; j < size2; ++j) {
                    TabInfo tab = (TabInfo)tabs.get(j);
                    if (reOrders.contains(tab)) continue;
                    reOrders.add(tab);
                }
                size2 = reOrders.size();
                for (i = 0; i < size2; ++i) {
                    TabInfo tab = (TabInfo)reOrders.get(i);
                    entry.insertTab(tab.getLabel(), tab.getIcon(), tab.getComp(), tab.getTooltip(), i);
                }
                if (listeners != null) {
                    for (i = 0; i < listeners.length; ++i) {
                        entry.addChangeListener(listeners[i]);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("reset " + entry.getName() + " tabs' order error"), (Throwable)e);
            }
        }
    }

    public static int getTabIndex(List tabs, String name) {
        if (tabs != null && !StringUtils.isEmpty((String)name)) {
            int size = tabs.size();
            for (int i = 0; i < size; ++i) {
                if (!name.equals(((TabInfo)tabs.get(i)).getComp().getName())) continue;
                return i;
            }
        }
        return -1;
    }

    private static void setColumnStyle(ColumnInfo columnInfo, IColumn column) {
        if (column == null || columnInfo == null) {
            return;
        }
        String sQueryPK = columnInfo.getExtendedProperty("defaultF7Query");
        String bindPropertyType = columnInfo.getExtendedProperty("bindpropertytype");
        if (!StringUtils.isEmpty((String)sQueryPK)) {
            String display = columnInfo.getExtendedProperty("dataField");
            if (StringUtils.isEmpty((String)display)) {
                display = "$name$";
            }
            ObjectValueRender render = new ObjectValueRender();
            render.setFormat((IDataFormat)new BizDataFormat(display));
            column.setRenderer((IBasicRender)render);
        }
        if (SQLType.DATETIME.getName().equals(bindPropertyType)) {
            if (columnInfo.getFormatString() != null) {
                column.getStyleAttributes().setNumberFormat(columnInfo.getFormatString());
            } else {
                column.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
            }
        }
        if (SQLType.NUMERIC.getName().equals(bindPropertyType)) {
            String precision = columnInfo.getExtendedProperty("precision");
            int pre = -1;
            if (!StringUtils.isEmpty((String)precision)) {
                try {
                    pre = Integer.parseInt(precision);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            if (StringUtils.isEmpty((String)columnInfo.getFormatString())) {
                String colFormat = "%{0.";
                for (int i = 0; i < pre; ++i) {
                    colFormat = colFormat + "0";
                }
                colFormat = colFormat + "}f";
                column.getStyleAttributes().setNumberFormat(colFormat);
            }
        }
    }

    private static Object getTableColumnBindFieldObject(ComponentInfo cInfo, ColumnInfo columnInfo) {
        Object obj = null;
        int nn = cInfo.getPropertyBindings().size();
        for (int i = 0; i < nn; ++i) {
            PropertyBindingInfo propBindInfo = cInfo.getPropertyBindings().get(i);
            String propName = propBindInfo.getPropertyName();
            String propType = propBindInfo.getFieldType();
            if (propName == null || propType == null) continue;
            try {
                String name = StringUtils.replace((String)propName, (String)".text", (String)"");
                if (!name.equals(columnInfo.getName())) continue;
                Class<?> objClass = Class.forName(propType);
                obj = objClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"\u65b9\u6cd5\uff1aNewUILayoutExecutorHelper.getTableColumnBindFieldObject", (Throwable)e);
            }
            return obj;
        }
        return obj;
    }

    private static KDTDefaultCellEditor getCellEditor(ColumnInfo columnInfo, String preFixName, String defaultUIName, ComponentInfo tableControl) {
        String sQueryPK = columnInfo.getExtendedProperty("defaultF7Query");
        String bindPropertyType = columnInfo.getExtendedProperty("bindpropertytype");
        if (!StringUtils.isEmpty((String)sQueryPK)) {
            String filterExpr;
            KDBizPromptBox _PromptBox = new KDBizPromptBox();
            String display = columnInfo.getExtendedProperty("dataField");
            Object objField = NewUILayoutExecutorHelper.getTableColumnBindFieldObject(tableControl, columnInfo);
            Method methodName = null;
            Method methodNumber = null;
            if (StringUtils.isEmpty((String)display)) {
                if (objField instanceof AbstractDataBaseInfo) {
                    display = "$name$";
                } else {
                    display = "$id$";
                    try {
                        methodName = objField.getClass().getMethod("getName", new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        methodNumber = objField.getClass().getMethod("getNumber", new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (methodName != null) {
                        display = "$name$";
                    } else if (methodNumber != null) {
                        display = "$number$";
                    }
                }
            }
            if (!StringUtils.isEmpty((String)(filterExpr = columnInfo.getExtendedProperty("f7FilterItem")))) {
                EntityViewInfo v = new EntityViewInfo();
                try {
                    v.setFilter(filterExpr);
                    _PromptBox.setEntityViewInfo(v);
                }
                catch (ParserException e1) {
                    logger.error((Object)e1);
                }
            }
            _PromptBox.setQueryInfo(sQueryPK);
            _PromptBox.setVisible(true);
            _PromptBox.setEditable(true);
            _PromptBox.setDisplayFormat(display);
            if (objField instanceof AbstractDataBaseInfo || methodNumber != null) {
                _PromptBox.setEditFormat("$number$");
                _PromptBox.setCommitFormat("$number$");
            } else {
                _PromptBox.setEditFormat(display);
                _PromptBox.setCommitFormat(display);
            }
            if (!StringUtils.isEmpty((String)defaultUIName)) {
                _PromptBox.setDefaultF7UIName(defaultUIName);
                try {
                    Object obj = Class.forName(defaultUIName).newInstance();
                    if (obj instanceof KDPromptSelector) {
                        _PromptBox.setSelector((KDPromptSelector)obj);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            return new KDTDefaultCellEditor((IKDEditor)_PromptBox);
        }
        if (!StringUtils.isEmpty((String)bindPropertyType)) {
            if (DataType.ENUM.getName().equals(bindPropertyType)) {
                String enumClassName = columnInfo.getExtendedProperty("enumclassname");
                if (!StringUtils.isEmpty((String)enumClassName)) {
                    KDComboBox _ComboBox = new KDComboBox();
                    _ComboBox.setName(preFixName + "_ComboBox");
                    _ComboBox.setVisible(true);
                    List enumList = new ArrayList();
                    try {
                        enumList = NewUILayoutExecutorHelper.getEnumList(enumClassName);
                        if (enumList != null && enumList.size() > 0) {
                            _ComboBox.addItems(enumList.toArray());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getLocalizedMessage());
                    }
                    return new KDTDefaultCellEditor((JComboBox)_ComboBox);
                }
            } else {
                if (SQLType.DATETIME.getName().equals(bindPropertyType)) {
                    KDDatePicker _DatePicker = new KDDatePicker();
                    _DatePicker.setName(preFixName + "_DatePicker");
                    _DatePicker.setVisible(true);
                    _DatePicker.setEditable(true);
                    return new KDTDefaultCellEditor(_DatePicker);
                }
                if (SQLType.NVARCHAR.getName().equals(bindPropertyType)) {
                    KDTextField _TextField = new KDTextField();
                    _TextField.setName(preFixName + "_TextField");
                    String maxtLength = columnInfo.getExtendedProperty("maxLength");
                    if (!StringUtils.isEmpty((String)maxtLength)) {
                        int length = 255;
                        try {
                            length = Integer.parseInt(maxtLength);
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                        }
                        _TextField.setMaxLength(length);
                    }
                    return new KDTDefaultCellEditor((JTextField)_TextField);
                }
                if (DataType.BOOLEAN.getName().equals(bindPropertyType)) {
                    KDCheckBox _CheckBox = new KDCheckBox();
                    _CheckBox.setName(preFixName + "_CheckBox");
                    return new KDTDefaultCellEditor((JCheckBox)_CheckBox);
                }
                if (SQLType.INT.getName().equals(bindPropertyType) || SQLType.NUMERIC.getName().equals(bindPropertyType)) {
                    KDFormattedTextField _TextField = new KDFormattedTextField();
                    _TextField.setName(preFixName + "_TextField");
                    _TextField.setVisible(true);
                    _TextField.setEditable(true);
                    _TextField.setHorizontalAlignment(2);
                    if (SQLType.INT.getName().equals(bindPropertyType)) {
                        _TextField.setDataType(0);
                    } else {
                        _TextField.setDataType(1);
                        String minValue = columnInfo.getExtendedProperty("minimumValue");
                        if (!StringUtils.isEmpty((String)minValue)) {
                            minValue = minValue.replaceAll("\"", "");
                            _TextField.setMinimumValue((Comparable)new BigDecimal(minValue));
                        } else {
                            _TextField.setMinimumValue((Comparable)new BigDecimal("-9.999999999E7"));
                        }
                        String maxValue = columnInfo.getExtendedProperty("maximumValue");
                        if (!StringUtils.isEmpty((String)maxValue)) {
                            maxValue = maxValue.replaceAll("\"", "");
                            _TextField.setMaximumValue((Comparable)new BigDecimal(maxValue));
                        } else {
                            _TextField.setMaximumValue((Comparable)new BigDecimal("9.999999999E7"));
                        }
                        String precision = columnInfo.getExtendedProperty("precision");
                        int pre = -1;
                        if (!StringUtils.isEmpty((String)precision)) {
                            try {
                                pre = Integer.parseInt(precision);
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage());
                            }
                        }
                        _TextField.setPrecision(pre < 0 ? 0 : pre);
                        _TextField.setSupportedEmpty(true);
                    }
                    return new KDTDefaultCellEditor((JTextField)_TextField);
                }
            }
        }
        return null;
    }

    public static String getBindField(ComponentInfo cInfo) {
        if (cInfo == null) {
            return null;
        }
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (StringUtils.isEmpty((String)pbInfo.getBingdingField())) continue;
            return pbInfo.getBingdingField();
        }
        return null;
    }

    private static String getColumnBindField(ComponentInfo cInfo, String columnName) {
        if (cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String tableColumnName = "";
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            return pbInfo.getBingdingField();
        }
        return null;
    }

    private static PropertyBindingInfo getColumnPropertyBinding(ComponentInfo cInfo, String columnName) {
        if (cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            String tableColumnName;
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            return pbInfo;
        }
        return null;
    }

    public static BizUnitInfo loadBizUnit(MetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
                bizUnit = bizUnitCtrl.getValue((IMetaDataPK)pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return bizUnit;
    }

    public static String parseStrToDisplayField(String sDisField) {
        if (StringUtils.isEmpty((String)sDisField)) {
            return "$name$";
        }
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        boolean bAddDisField = false;
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            String sKey = "";
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }

    public static Class getClassName(String name) {
        Class<?> clazz;
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        if ("String".equals(name)) {
            return String.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"ClassNotFoundException! Class not found when registerBinding in UILayoutExecutor!");
            return Object.class;
        }
        return clazz;
    }

    public static void removeCfgCell(EntityObjectInfo entity, ComponentInfo tableControl, KDTable kdtEntrys, DataBinder dataBinder) {
        if (entity == null || tableControl == null || kdtEntrys == null) {
            return;
        }
        PropertyInfo property = tableControl.getProperties().get("formatXml");
        if (property != null) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
            List columns = tableInfo.getColumns();
            ArrayList<com.kingdee.bos.metadata.entity.PropertyInfo> propList = new ArrayList<com.kingdee.bos.metadata.entity.PropertyInfo>(5);
            ArrayList<PropertyBindingInfo> pbList = new ArrayList<PropertyBindingInfo>(5);
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
                String bindField = NewUILayoutExecutorHelper.getColumnBindField(tableControl, columnInfo.getName());
                prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindField);
                if (prop == null || !prop.isConfigured()) continue;
                propList.add(prop);
                pbList.add(NewUILayoutExecutorHelper.getColumnPropertyBinding(tableControl, columnInfo.getName()));
            }
            if (propList.size() == 0) {
                logger.info((Object)"no configure columns");
                return;
            }
            int n2 = pbList.size();
            for (int i = 0; i < n2; ++i) {
                PropertyBindingInfo pbInfo = (PropertyBindingInfo)pbList.get(i);
                Class clazz = NewUILayoutExecutorHelper.getClassName(pbInfo.getFieldType());
                if (clazz == null) continue;
                dataBinder.unRegisterBinding(pbInfo.getBingdingField(), clazz, (Component)kdtEntrys, pbInfo.getPropertyName());
                logger.info((Object)("entry unRegisterBind:dataBinder.unRegisterBinding(" + pbInfo.getBingdingField() + "," + clazz + "," + kdtEntrys.getName() + "," + pbInfo.getPropertyName() + ");"));
            }
            int n3 = propList.size();
            for (int i = 0; i < n3; ++i) {
                prop = (com.kingdee.bos.metadata.entity.PropertyInfo)propList.get(i);
                IColumn column = kdtEntrys.getColumn(prop.getName());
                if (column == null) continue;
                kdtEntrys.removeColumn(column.getColumnIndex());
                logger.info((Object)("delete column:" + column.getKey()));
            }
        }
    }

    public static boolean containPropertyByName(ComponentInfo component, String name) {
        PropertyInfo prop;
        return component != null && (prop = component.getPropertyByName(name)) != null;
    }

    public static int getLabelLength(ComponentInfo component) {
        PropertyInfo prop;
        if (component != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(component.getClassType()) && (prop = component.getPropertyByName("boundLabelLength")) != null) {
            try {
                return Integer.parseInt(prop.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean getLabelUnderLine(ComponentInfo component) {
        PropertyInfo prop;
        if (component != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(component.getClassType()) && (prop = component.getPropertyByName("boundLabelUnderline")) != null) {
            try {
                return Boolean.valueOf(prop.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static void setSelector(String selector, KDBizPromptBox promt) {
        block5: {
            if (!StringUtils.isEmpty((String)selector)) {
                try {
                    Object obj = Class.forName(selector).newInstance();
                    if (obj instanceof KDPromptSelector) {
                        promt.setSelector((KDPromptSelector)obj);
                        break block5;
                    }
                    logger.info((Object)"is not instanceof KDPromptSelector");
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                logger.info((Object)"selector is null,do not set selector for KDBizPromptBox");
            }
        }
    }

    static class TabInfo {
        Component comp = null;
        String label = null;
        String tooltip = null;
        Icon icon = null;
        boolean enabled = true;

        public TabInfo(Component comp, boolean enabled, Icon icon, String label, String tooltip) {
            this.comp = comp;
            this.enabled = enabled;
            this.icon = icon;
            this.label = label;
            this.tooltip = tooltip;
        }

        public Component getComp() {
            return this.comp;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

