/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ep.client.runtime.UIConfigureExecutor;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.NewUILifeCycleHander;
import com.kingdee.eas.framework.client.UILifeCycleHander;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OrgUnitDataChangeListener
implements DataChangeListener {
    private CoreUI ui;
    private IMetaDataPK pk;
    private UIConfigureExecutor executor;
    private Logger logger = Logger.getLogger(OrgUnitDataChangeListener.class);

    public OrgUnitDataChangeListener(CoreUI ui, IMetaDataPK pk, UIConfigureExecutor executor) {
        this.ui = ui;
        this.pk = pk;
        this.executor = executor;
    }

    public void dataChanged(DataChangeEvent eventObj) {
        try {
            if (eventObj != null) {
                if (eventObj.getNewValue() != null && eventObj.getNewValue() instanceof OrgUnitInfo) {
                    OrgUnitInfo orgUnit = (OrgUnitInfo)eventObj.getNewValue();
                    if (orgUnit.getId() != null) {
                        DataComponentMap dcMap;
                        ArrayList headerFields;
                        DataBinder binder = this.ui.getDataBinder();
                        if (binder != null && binder.getDataComponentMap() != null && (headerFields = (dcMap = binder.getDataComponentMap()).getHeaderFields()) != null && headerFields.size() > 0) {
                            int length = headerFields.size();
                            Field field = null;
                            ComponentProperty compProp = null;
                            KDBizPromptBox bizOrg = this.getMainOrgFromOrgContextManager(this.ui);
                            if (bizOrg == null) {
                                bizOrg = this.getMainBizOrg(this.ui);
                            }
                            for (int i = 0; i < length; ++i) {
                                field = (Field)headerFields.get(i);
                                compProp = dcMap.getComponentProperty(field);
                                if (compProp.getComponent() != bizOrg) continue;
                                BindingUtility.storeData((IObjectValue)binder.getValueObject(), (Field)field, (ComponentProperty)compProp);
                                break;
                            }
                        }
                        this.executor.executeUIConfigure(this.ui, this.pk, this.ui.getMainType(), orgUnit.getId().toString());
                    } else {
                        this.executor.executeUIConfigure(this.ui, this.pk, this.ui.getMainType(), "");
                    }
                } else {
                    this.executor.executeUIConfigure(this.ui, this.pk, this.ui.getMainType(), "");
                }
                this.ui.fireAfterDEPOrgUnitDataChange(eventObj);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)"UILifeCycleHander.dataChanged()");
            this.logger.info((Object)e);
        }
    }

    private KDBizPromptBox getMainOrgFromOrgContextManager(CoreUI ui) {
        IMultiOrgSupport mos;
        if (ui != null && this.getOrgContextManager(ui) != null && (mos = this.getOrgContextManager(ui).getOwner()) != null) {
            return mos.getMainOrg();
        }
        return null;
    }

    private KDBizPromptBox getMainBizOrg(CoreUI ui) {
        UILifeCycleHander lifeCycleHandler = ui.getUILifeCycleHandler();
        if (lifeCycleHandler instanceof NewUILifeCycleHander) {
            return ((NewUILifeCycleHander)lifeCycleHandler).getMainBizOrg();
        }
        return null;
    }

    private OrgContextManager getOrgContextManager(CoreUI ui) {
        UILifeCycleHander lifeCycleHandler = ui.getUILifeCycleHandler();
        if (lifeCycleHandler instanceof NewUILifeCycleHander) {
            return ((NewUILifeCycleHander)lifeCycleHandler).getOrgContextManager();
        }
        return null;
    }
}

