/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.ep.client.depend.RunTimeUtil;
import com.kingdee.eas.framework.util.NullVerifier;
import com.kingdee.eas.util.AbortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class RequireUtil {
    private static Logger logger = Logger.getLogger(RunTimeUtil.class);
    private Map requiredTables = new HashMap();
    private List requiredComps = new ArrayList();

    public void addRequiredComponent(JComponent comp) {
        this.requiredComps.add(comp);
    }

    public void addTableRequiredField(KDTable table, String[] requiredColumnFields) {
        this.requiredTables.put(table, requiredColumnFields);
    }

    public void checkRequire() {
        try {
            this.checkHead();
            this.checkEntrys();
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error when check require", (Throwable)e);
        }
    }

    private void checkHead() throws Exception {
        JComponent[] comps = this.requiredComps.toArray(new JComponent[this.requiredComps.size()]);
        new NullVerifier(comps).verify();
    }

    private void checkEntrys() throws Exception {
        for (KDTable table : this.requiredTables.keySet()) {
            String[] requiredColumnFields = (String[])this.requiredTables.get(table);
            new NullVerifier(table, requiredColumnFields).verify();
        }
    }

    public void addTableRequiredField(KDTable table, String requiredColumnFields) {
        if (this.requiredTables.containsKey(table)) {
            String[] oldRequiredColumnFields = (String[])this.requiredTables.get(table);
            HashSet<String> fieldSet = new HashSet<String>();
            fieldSet.addAll(Arrays.asList(oldRequiredColumnFields));
            fieldSet.add(requiredColumnFields);
            this.addTableRequiredField(table, fieldSet.toArray(new String[fieldSet.size()]));
        } else {
            this.addTableRequiredField(table, new String[]{requiredColumnFields});
        }
    }

    public void removeRequiredComponent(JComponent comp) {
        this.requiredComps.remove(comp);
    }

    public void removeTableRequiredField(KDTable table, String requiredColumnFields) {
        if (this.requiredTables.containsKey(table)) {
            String[] oldRequiredColumnFields = (String[])this.requiredTables.get(table);
            HashSet<String> fieldSet = new HashSet<String>();
            fieldSet.addAll(Arrays.asList(oldRequiredColumnFields));
            fieldSet.remove(requiredColumnFields);
            this.addTableRequiredField(table, fieldSet.toArray(new String[fieldSet.size()]));
        }
    }
}

