/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bizrule.RuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.face.IEditUIConfigureInfo;
import com.kingdee.bos.ui.layout.UILayoutConfigInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.runtime.NewUILayoutExecutor;
import com.kingdee.eas.ep.client.runtime.OrgUnitDataChangeListener;
import com.kingdee.eas.ep.client.runtime.RequireUtil;
import com.kingdee.eas.ep.client.runtime.uischeme.BackUpInfoFactory;
import com.kingdee.eas.ep.client.runtime.uischeme.IBackUpInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.NewUILifeCycleHander;
import com.kingdee.eas.framework.client.UILifeCycleHander;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.framework.expression.BizRuleSetExecutor;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class UIConfigureExecutor {
    private Logger logger = Logger.getLogger(UIConfigureExecutor.class);
    private String oldMainOrgID = null;
    private List backupStatus = null;
    private IEditUIConfigureInfo backupConfigure = null;
    private BizRuleSetExecutor ruleSetExecutor = null;
    private NewUILayoutExecutor layoutExecutor = null;
    private CoreUI ui = null;
    protected List cfgControls = new ArrayList();
    protected Map localCtx = null;
    protected RequireUtil requireUtil = null;

    public UIConfigureExecutor(CoreUI ui) {
        this.ui = ui;
    }

    public UIConfigureExecutor(CoreUI ui, RequireUtil requireUtil) {
        this.ui = ui;
        this.requireUtil = requireUtil;
    }

    public void executeUIConfigure(String id) {
        IEditUIConfigureInfo bizConfigure = this.getBizConfigure(id);
        if (bizConfigure != null) {
            this.executeUIConfigure(bizConfigure);
        }
    }

    public void executeUIConfigure() {
        if (this.ui.getMetaDataPK() == null) {
            return;
        }
        IMetaDataPK pk = this.ui.getMetaDataPK();
        OrgType orgType = this.ui.getMainType();
        if (orgType == null) {
            this.executeUIConfigure(this.ui, pk, orgType, "");
        } else {
            KDBizPromptBox orgF7 = this.getMainOrgFromOrgContextManager(this.ui);
            if (orgF7 != null) {
                this.logger.info((Object)"[UILifeCycleHander]found main org from org context manager...");
                orgF7.addDataChangeListener((DataChangeListener)new OrgUnitDataChangeListener(this.ui, pk, this));
            } else if (this.getMainBizOrg(this.ui) != null) {
                this.logger.info((Object)"[UILifeCycleHander]found main biz org from ui.getMainBizOrg()...");
                this.getMainBizOrg(this.ui).addDataChangeListener((DataChangeListener)new OrgUnitDataChangeListener(this.ui, pk, this));
            }
            OrgUnitInfo orgUnit = (OrgUnitInfo)this.ui.getUIContext().get(this.ui.getMainType());
            if (orgUnit != null) {
                String orgid = "";
                if (orgUnit.getId() != null) {
                    orgid = orgUnit.getId().toString();
                }
                this.executeUIConfigure(this.ui, pk, orgType, orgid);
            }
        }
    }

    public void executeUIConfigure(CoreUI ui, IMetaDataPK pk, OrgType orgType, String mainOrgID) {
        if (ui == null || pk == null) {
            return;
        }
        if (orgType == null) {
            IEditUIConfigureInfo configure = this.getBizConfigure(pk, mainOrgID);
            this.executeUIConfigure(configure);
        } else {
            if (this.oldMainOrgID == null && this.backupStatus == null) {
                this.backupStatus = this.backupUIStatus(this.getLocalCtx(ui));
            }
            if (!StringUtils.isEmpty((String)mainOrgID) && !mainOrgID.equals(this.oldMainOrgID)) {
                IEditUIConfigureInfo configure = this.getBizConfigure(pk, mainOrgID);
                if (configure != null) {
                    this.oldMainOrgID = mainOrgID;
                    this.destroyUIConfigure(ui);
                    this.executeUIConfigure(configure);
                    this.backupConfigure = configure;
                } else if (!StringUtils.isEmpty((String)this.oldMainOrgID)) {
                    this.oldMainOrgID = null;
                    this.destroyUIConfigure(ui);
                    this.backupConfigure = null;
                }
            } else if (!StringUtils.isEmpty((String)mainOrgID) && mainOrgID.equals(this.oldMainOrgID)) {
                ui.getUILifeCycleHandler().clearLinkRuleListener();
                RuleSetInfo ruleSet = this.getBizRuleSet(this.backupConfigure);
                this.executeRuleSet(ruleSet);
            } else if (StringUtils.isEmpty((String)mainOrgID) && !StringUtils.isEmpty((String)this.oldMainOrgID)) {
                this.oldMainOrgID = null;
                this.destroyUIConfigure(ui);
                this.backupConfigure = null;
            }
        }
    }

    public void executeUIConfigure(IEditUIConfigureInfo configure) {
        if (configure == null) {
            return;
        }
        UILayoutConfigInfo uiLayout = UIConfigureExecutor.loadConfigureInfo(configure);
        this.executeUILayout(uiLayout);
        RuleSetInfo ruleSet = this.getBizRuleSet(configure);
        this.executeRuleSet(ruleSet);
    }

    private void executeUILayout(UILayoutConfigInfo uiLayout) {
        if (uiLayout != null) {
            this.layoutExecutor = new NewUILayoutExecutor(this.ui, ContextManager.getContext(), this.getLocalCtx(this.ui), uiLayout, this.ui.getDataBinder(), this.ui.getUILifeCycleHandler());
            try {
                this.layoutExecutor.execute();
            }
            catch (Exception e) {
                this.logger.error((Object)"error when execute UILayout ", (Throwable)e);
            }
        }
    }

    private void executeRuleSet(RuleSetInfo ruleSet) {
        if (ruleSet != null) {
            this.ruleSetExecutor = new BizRuleSetExecutor(this.ui, ContextManager.getContext(), this.getLocalCtx(this.ui), ruleSet, this.requireUtil);
            try {
                this.ruleSetExecutor.execute();
            }
            catch (Exception e) {
                this.logger.error((Object)"error when execute RuleSet ", (Throwable)e);
            }
        }
    }

    public void destroyUIConfigure(CoreUI ui) {
        ui.getUILifeCycleHandler().clearLinkRuleListener();
        if (this.ruleSetExecutor != null || this.layoutExecutor != null) {
            Map localCtx = this.getLocalCtx(ui);
            this.restoreUIStatus(localCtx, this.backupStatus);
            if (this.layoutExecutor != null) {
                this.layoutExecutor.destroy();
            }
            if (this.ruleSetExecutor != null) {
                this.ruleSetExecutor.destroy();
            }
        }
        ui.revalidate();
    }

    private void addComponentsToMap(Component[] components, Map map) {
        this.addComponentsToMap(components, map, true);
    }

    private void addComponentsToMap(Component[] components, Map map, boolean deep) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            String cName = components[i].getName();
            if (StringUtils.isEmpty((String)cName)) {
                cName = String.valueOf(Math.abs(new SecureRandom().nextInt()));
            }
            if (map.get(cName) == null) {
                map.put(cName, components[i]);
            }
            if (!(components[i] instanceof Container) || !deep || ((Container)components[i]).getComponents().length <= 0) continue;
            this.addComponentsToMap(((Container)components[i]).getComponents(), map);
        }
    }

    private Map getLocalCtx(CoreUI coreUI) {
        if (this.localCtx == null) {
            this.localCtx = new HashMap();
            this.localCtx.put("owner", coreUI);
            this.localCtx.put("CoreUI", coreUI);
            this.addComponentsToMap(coreUI.getComponents(), this.localCtx);
            this.addComponentsToMap((Component[])coreUI.getUIMultiToolBar(), this.localCtx, false);
            this.addComponentsToMap(new Component[]{coreUI.getUIMenuBar()}, this.localCtx);
        }
        return this.localCtx;
    }

    public IEditUIConfigureInfo getBizConfigure(IMetaDataPK pk, String mainOrgID) {
        if (mainOrgID == null) {
            mainOrgID = "";
        }
        try {
            if (pk != null) {
                String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                String currentUserOrgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                currentUserId = StringUtils.isEmpty((String)currentUserId) ? "" : currentUserId;
                currentUserOrgId = StringUtils.isEmpty((String)currentUserOrgId) ? "" : currentUserOrgId;
                Object obj = DynamicObjectFactory.getCachedRemoteInstance().invoke(BOSObjectType.create((String)"D67C2220"), "getEditUIBizConfig", new Object[]{currentUserId, currentUserOrgId, mainOrgID, pk.getFullName()});
                if (obj instanceof IEditUIConfigureInfo) {
                    return (IEditUIConfigureInfo)obj;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error when get EditUIConfigureInfo ", (Throwable)e);
        }
        return null;
    }

    private IEditUIConfigureInfo getBizConfigure(String id) {
        if (!StringUtils.isEmpty((String)id)) {
            try {
                IObjectCollection uicfgCol = DynamicObjectFactory.getCachedRemoteInstance().getCollection(BOSObjectType.create((String)"8C73443D"), "WHERE ID = '" + id + "'");
                if (uicfgCol != null && uicfgCol.size() > 0) {
                    int n = uicfgCol.size();
                    for (int i = 0; i < n; ++i) {
                        if (!(uicfgCol.getObject(i) instanceof IEditUIConfigureInfo)) continue;
                        return (IEditUIConfigureInfo)uicfgCol.getObject(i);
                    }
                }
            }
            catch (BOSException e) {
                this.logger.error((Object)"error when get EditUIConfigureInfo ", (Throwable)e);
            }
        }
        return null;
    }

    private RuleSetInfo getBizRuleSet(IEditUIConfigureInfo configure) {
        if (configure == null || configure.getBizRuleSet() == null) {
            return null;
        }
        try {
            String ruleSetXml = configure.getBizRuleSet();
            return (RuleSetInfo)new RuleSetCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(ruleSetXml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static UILayoutConfigInfo loadConfigureInfo(IEditUIConfigureInfo configure) {
        if (configure == null) {
            return null;
        }
        try {
            String configJson = configure.getUIObject();
            UILayoutConfigInfo info = UILayoutConfigInfo.toUILayoutConfigInfo((String)configJson);
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List backupUIStatus(Map localCtx) {
        ArrayList<IBackUpInfo> status = new ArrayList<IBackUpInfo>();
        if (localCtx != null) {
            for (Object key : localCtx.keySet()) {
                Object value = localCtx.get(key);
                if (!(value instanceof JComponent)) continue;
                IBackUpInfo backUpInfo = BackUpInfoFactory.createBackUpInfo((JComponent)value);
                status.add(backUpInfo);
            }
        }
        return status;
    }

    public void restoreUIStatus(Map localCtx, List status) {
        if (status != null) {
            int n = status.size();
            for (int i = 0; i < n; ++i) {
                IBackUpInfo backUpInfo = (IBackUpInfo)status.get(i);
                if (backUpInfo == null) continue;
                backUpInfo.rollBack();
            }
        }
    }

    private KDBizPromptBox getMainOrgFromOrgContextManager(CoreUI ui) {
        IMultiOrgSupport mos;
        if (ui != null && this.getOrgContextManager(ui) != null && (mos = this.getOrgContextManager(ui).getOwner()) != null) {
            return mos.getMainOrg();
        }
        return null;
    }

    private KDBizPromptBox getMainBizOrg(CoreUI ui) {
        UILifeCycleHander lifeCycleHandler = ui.getUILifeCycleHandler();
        if (lifeCycleHandler instanceof NewUILifeCycleHander) {
            return ((NewUILifeCycleHander)lifeCycleHandler).getMainBizOrg();
        }
        return null;
    }

    private OrgContextManager getOrgContextManager(CoreUI ui) {
        UILifeCycleHander lifeCycleHandler = ui.getUILifeCycleHandler();
        if (lifeCycleHandler instanceof NewUILifeCycleHander) {
            return ((NewUILifeCycleHander)lifeCycleHandler).getOrgContextManager();
        }
        return null;
    }

    public BizRuleSetExecutor getRuleSetExecutor() {
        return this.ruleSetExecutor;
    }
}

