/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.eas.ep.client.runtime.ComponentModifyInfo;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIObjectInfoProxy {
    private static final Logger logger = Logger.getLogger(UIObjectInfoProxy.class);
    private IMetaDataPK pk;
    private List<ComponentModifyInfo> modifyComps = new ArrayList<ComponentModifyInfo>();
    private List<ComponentInfo> newComps = new ArrayList<ComponentInfo>();
    private List<ComponentInfo> tables = new ArrayList<ComponentInfo>();
    private UIObjectInfo uiObjectInfo;
    private Map<String, Object> propertyValues = new HashMap<String, Object>();
    public static final String TITLE = "title";

    protected UIObjectInfoProxy(IMetaDataPK pk) {
        if (pk != null) {
            this.pk = pk;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            UIObjectInfo model = (UIObjectInfo)loader.get(MetaDataTypeList.UIOBJECT, pk);
            if (!UictUtils.isEmptyMD((AbstractMDValue)model)) {
                this.uiObjectInfo = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)model);
                UIObjectInfo stand = this.getStand(model);
                this.compare(this.uiObjectInfo, stand);
            }
        }
    }

    private void compare(UIObjectInfo merge, UIObjectInfo stand) {
        ComponentInfo mergeMain = merge.getMainPanelComponent();
        if (mergeMain != null) {
            ComponentCollection standComponents = stand.isDynamic() ? new ComponentCollection() : stand.getComponents();
            ComponentCollection mergeComponents = mergeMain.getComponents();
            this.compare(mergeComponents, standComponents);
        }
        if (stand.isDynamic() || !StringUtils.equals((String)stand.getTitle(), (String)merge.getTitle())) {
            this.propertyValues.put(TITLE, merge.getTitle());
        }
    }

    private UIObjectInfo getStand(UIObjectInfo model) {
        if (model.isDynamic()) {
            return model;
        }
        try {
            DynamicStateManager.beginUseMaster();
            UIObjectInfo uIObjectInfo = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)model);
            return uIObjectInfo;
        }
        finally {
            DynamicStateManager.endUseMaster();
        }
    }

    private void compare(ComponentCollection merges, ComponentCollection stands) {
        int n = merges.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo merge = merges.get(i);
            String name = merge.getName();
            this.compare(merge, stands.getComponentInfo(name));
            ComponentCollection children = merge.getComponents();
            this.compare(children, stands);
        }
    }

    private void compare(ComponentInfo merge, ComponentInfo stand) {
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(merge.getClassType())) {
            this.tables.add(merge);
        } else if (merge.isConfigured()) {
            this.newComps.add(merge);
        } else {
            ComponentModifyInfo modify;
            if (stand == null) {
                stand = new ComponentInfo();
            }
            if (!(modify = new ComponentModifyInfo(merge, stand)).isEmpty()) {
                this.modifyComps.add(modify);
            }
        }
    }

    public List<ComponentModifyInfo> getModifyComponents() {
        return this.modifyComps;
    }

    public List<ComponentInfo> getNewComponents() {
        return this.newComps;
    }

    public List<ComponentInfo> getTables() {
        return this.tables;
    }

    protected boolean isModified(String key) {
        return this.propertyValues.containsKey(key);
    }

    protected Object getValue(String propertyName) {
        return this.propertyValues.get(propertyName);
    }

    public IMetaDataPK getMetaDataPK() {
        return this.pk;
    }

    public UIObjectInfo getUIObjectInfo() {
        return this.uiObjectInfo;
    }
}

