/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.tablepanel.KDTablePanel;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.ActionServicePropertyHelper;
import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.ep.BillEntryCustomAgent;
import com.kingdee.eas.ep.client.runtime.ComponentModifier;
import com.kingdee.eas.ep.client.runtime.ComponentModifyInfo;
import com.kingdee.eas.ep.client.runtime.DynamicExtendService;
import com.kingdee.eas.ep.client.runtime.FocusTraversalPolicy;
import com.kingdee.eas.ep.client.runtime.FormatXmlHelper;
import com.kingdee.eas.ep.client.runtime.NewUILayoutExecutorHelper;
import com.kingdee.eas.ep.client.runtime.UIObjectInfoProxy;
import com.kingdee.eas.ep.client.runtime.UISegmentAssemblerHelper;
import com.kingdee.eas.ep.client.runtime.bizrule.BizRuleHandler;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.HMDUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class UISegmentAssembler {
    private static final Logger logger = Logger.getLogger(UISegmentAssembler.class);
    private CoreUI baseUI;
    private UIObjectInfoProxy proxy;
    private EntityObjectInfo bindEntity;
    private ResourceBundleHelper helper;
    private List<String> entrys = new ArrayList<String>();
    private DynamicExtendService service;
    private Map<String, Component> localCtx;

    public UISegmentAssembler(CoreUI baseUI, UIObjectInfoProxy proxy, DynamicExtendService service) {
        this.baseUI = baseUI;
        this.proxy = proxy;
        this.service = service;
        UIObjectInfo mergeModel = proxy.getUIObjectInfo();
        this.helper = new ResourceBundleHelper(mergeModel.getPackage() + ".Abstract" + mergeModel.getName());
        this.bindEntity = this.getBindEntity(mergeModel);
        this.localCtx = this.getLocalCtx(baseUI);
    }

    private EntityObjectInfo getBindEntity(UIObjectInfo ui) {
        DataObjectCollection col = ui.getDataObjects();
        for (int i = 0; i < col.size(); ++i) {
            DataObjectInfo doInfo = col.get(i);
            if (!doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) continue;
            MetaDataPK entitypk = MetaDataPK.create((String)doInfo.getType());
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo bindEntity = loader.getEntity((IMetaDataPK)entitypk);
            if (bindEntity == null) continue;
            return bindEntity;
        }
        return null;
    }

    private void resizeFrame(ComponentInfo mainPanel) {
        if (mainPanel == null) {
            return;
        }
        Object constraint = mainPanel.getConstraint();
        Rectangle rect = null;
        if (constraint instanceof KDLayoutConstraint) {
            rect = new Rectangle(((KDLayoutConstraint)constraint).toRectangle());
        } else if (constraint instanceof Rectangle) {
            rect = new Rectangle((Rectangle)constraint);
        } else {
            return;
        }
        Rectangle bounds = this.baseUI.getBounds();
        if (!bounds.equals(rect)) {
            this.baseUI.setBounds(rect);
            this.baseUI.setPreferredSize(new Dimension(rect.width, rect.height));
            if (this.baseUI.getLayout() instanceof KDLayout) {
                this.baseUI.putClientProperty((Object)"OriginalBounds", (Object)rect);
            }
        }
    }

    private void handleBizRule() {
        BizRuleHandler ruleHander = new BizRuleHandler(this.baseUI);
        Collection<Component> values = this.localCtx.values();
        for (Component object : values) {
            if (!(object instanceof JComponent)) continue;
            ruleHander.handler((JComponent)object);
        }
    }

    private void doTitle() {
        if (this.proxy.isModified("title")) {
            String value = (String)this.proxy.getValue("title");
            if (!StringUtils.isEmpty((String)value)) {
                this.baseUI.setUITitle(value);
            } else {
                this.baseUI.setUITitle("");
            }
        }
    }

    public void doCreate() {
        UIObjectInfo mergeModel = this.proxy.getUIObjectInfo();
        this.doAction(mergeModel.getActions());
        this.doToolBar(mergeModel.getToolbarsPanel());
        this.doMenuBar(mergeModel.getMenubarComponent());
        this.createComponents();
        this.handleBizRule();
        ComponentInfo mainPanel = mergeModel.getMainPanelComponent();
        if (mainPanel != null) {
            this.resizeFrame(mainPanel);
        }
    }

    private void createComponents() {
        List<ComponentInfo> components = this.proxy.getNewComponents();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = components.get(i);
            UISegmentAssemblerHelper.ComponentParam cp = UISegmentAssemblerHelper.getComponentParam(this.helper, component);
            this.createComponent(component, cp);
        }
        List<ComponentInfo> tables = this.proxy.getTables();
        int n2 = tables.size();
        for (int i = 0; i < n2; ++i) {
            ComponentInfo table = tables.get(i);
            UISegmentAssemblerHelper.ComponentParam cp = UISegmentAssemblerHelper.getComponentParam(this.helper, table);
            this.assemblerTable(table, cp);
        }
    }

    public void doModify() {
        ComponentModifier modifier = new ComponentModifier(this.service, this.localCtx);
        List<ComponentModifyInfo> components = this.proxy.getModifyComponents();
        for (ComponentModifyInfo modify : components) {
            modifier.doModify(modify);
        }
        this.doTitle();
        UIObjectInfo mergeModel = this.proxy.getUIObjectInfo();
        ComponentInfo mainPanel = mergeModel.getMainPanelComponent();
        if (mainPanel != null) {
            FocusTraversalPolicy traver = new FocusTraversalPolicy(this.baseUI, this.localCtx);
            traver.doFocusTraversalPolicy(mainPanel);
        }
    }

    private void assemblerTable(ComponentInfo cInfo, UISegmentAssemblerHelper.ComponentParam cp) {
        String formatXml;
        JComponent component = (JComponent)this.localCtx.get(cInfo.getName());
        if (component == null) {
            component = this.createTable(cInfo, cp);
            this.localCtx.put(cInfo.getName(), component);
        }
        if (!StringUtils.isEmpty((String)(formatXml = FormatXmlHelper.getFormatXml(cInfo, this.helper)))) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)formatXml);
            if (cInfo.isConfigured() || tableInfo.isConfigured()) {
                cInfo.setConfigured(true);
                UIObjectInfo mergeModel = this.proxy.getUIObjectInfo();
                NewUILayoutExecutorHelper.initKDTable(this.baseUI, mergeModel, cInfo, (KDTable)component, tableInfo, this.service);
            }
        }
        JComponent round = UISegmentAssemblerHelper.getRoundedComponent((JComponent)((KDTable)component));
        Container swingParent = this.getSwingParent(cInfo);
        this.layoutComponent(swingParent, round, cInfo);
        this.resetParam(round, UISegmentAssemblerHelper.getRoundedComponent(cInfo));
    }

    private Container getSwingParent(ComponentInfo cInfo) {
        Component object;
        ComponentInfo componentParent = cInfo.getParent();
        if (componentParent != null && (object = this.localCtx.get(componentParent.getName())) instanceof Container) {
            return (Container)object;
        }
        return null;
    }

    private void resetRequired(JComponent component, ComponentInfo cInfo) {
        String propValue;
        PropertyInfo property;
        if ((cInfo.getComponents() == null || cInfo.getComponents().size() == 0) && (property = cInfo.getPropertyByName("required")) != null && "true".equalsIgnoreCase(propValue = property.getValue()) && (cInfo.isConfigured() || !cInfo.isConfigured() && !((IKDTextComponent)component).isRequired())) {
            ((IKDTextComponent)component).setRequired(true);
            this.service.addRequiredComponent(component);
        }
    }

    private void doToolBar(ComponentInfo toolBarPanel) {
        ComponentCollection toolbars = toolBarPanel.getComponents();
        int size = toolbars.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo toolbarInfo = toolbars.get(i);
            ComponentCollection col = toolbarInfo.getComponents();
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                ComponentInfo cInfo = col.get(j);
                if (!cInfo.isConfigured()) continue;
                UISegmentAssemblerHelper.ComponentParam cp = UISegmentAssemblerHelper.getComponentParam(this.helper, cInfo);
                this.createComponent(cInfo, cp);
            }
            JComponent toolbar = (JComponent)this.localCtx.get(toolbarInfo.getName());
            if (!(toolbar instanceof KDToolBar)) continue;
            Object[] components = col.toArray();
            this.sort(components);
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < components.length; ++j) {
                if (!(components[j] instanceof ComponentInfo)) continue;
                ComponentInfo comp = (ComponentInfo)components[j];
                if ("com.kingdee.bos.ctrl.swing.KDSeparator".equals(comp.getClassType())) {
                    sb.append("&KDSeparator&");
                } else {
                    sb.append(comp.getName());
                }
                if (j == components.length - 1) continue;
                sb.append("|");
            }
            NewUILayoutExecutorHelper.reOrderToolbar((KDToolBar)toolbar, sb.toString());
        }
    }

    private void doMenuBar(ComponentInfo menu) {
        if (menu != null) {
            ComponentCollection menus = menu.getComponents();
            int size = menus.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo menuInfo = menus.get(i);
                if (menuInfo.isConfigured()) {
                    UISegmentAssemblerHelper.ComponentParam cp = UISegmentAssemblerHelper.getComponentParam(this.helper, menuInfo);
                    this.createComponent(menuInfo, cp);
                }
                if (!"com.kingdee.bos.ctrl.swing.KDMenu".equals(menuInfo.getClassType())) continue;
                this.doMenuBar(menuInfo);
            }
            JComponent com = (JComponent)this.localCtx.get(menu.getName());
            if (com instanceof KDMenu || com instanceof KDMenuBar) {
                Object[] components = menus.toArray();
                this.sort(components);
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < components.length; ++j) {
                    if (!(components[j] instanceof ComponentInfo)) continue;
                    sb.append(((ComponentInfo)components[j]).getName() + "|");
                }
                String order = sb.toString().trim();
                if (order.endsWith("|")) {
                    order = order.substring(0, order.length() - 1);
                }
                if (com instanceof KDMenu) {
                    NewUILayoutExecutorHelper.reOrderMenu((KDMenu)com, order);
                } else if (com instanceof KDMenuBar) {
                    NewUILayoutExecutorHelper.reOrderMenuBar((KDMenuBar)com, order);
                }
            }
        }
    }

    private void sort(Object[] components) {
        Arrays.sort(components, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                assert (arg0 instanceof ComponentInfo);
                assert (arg1 instanceof ComponentInfo);
                ComponentInfo info0 = (ComponentInfo)arg0;
                ComponentInfo info1 = (ComponentInfo)arg1;
                assert (info0.getConstraint() instanceof Integer);
                assert (info1.getConstraint() instanceof Integer);
                Integer index0 = (Integer)info0.getConstraint();
                Integer index1 = (Integer)info1.getConstraint();
                return index0.compareTo(index1);
            }
        });
    }

    private Map<String, Component> getLocalCtx(CoreUI coreUI) {
        if (this.localCtx == null) {
            this.localCtx = new HashMap<String, Component>();
            this.localCtx.put("CoreUI", (Component)coreUI);
            this.addComponentsToMap(coreUI.getComponents(), this.localCtx);
            this.addComponentsToMap((Component[])coreUI.getUIMultiToolBar(), this.localCtx);
            this.addComponentsToMap(new Component[]{coreUI.getUIMenuBar()}, this.localCtx);
        }
        return this.localCtx;
    }

    private void addComponentsToMap(Component[] components, Map<String, Component> map) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            String cName = components[i].getName();
            if (!StringUtils.isEmpty((String)cName) && map.get(cName) == null) {
                map.put(cName, components[i]);
            }
            if (!(components[i] instanceof Container) || ((Container)components[i]).getComponents().length <= 0) continue;
            this.addComponentsToMap(((Container)components[i]).getComponents(), map);
        }
    }

    private void layoutComponent(Container container, JComponent component, ComponentInfo cInfo) {
        Rectangle rect = UISegmentAssemblerHelper.getBounds(cInfo);
        if (rect == null) {
            return;
        }
        int anchor = UISegmentAssemblerHelper.getAnchor(cInfo);
        if (container == null || container.equals(component.getParent())) {
            if (UISegmentAssemblerHelper.isKDLayout(component.getParent())) {
                Object constraint = component.getClientProperty("KDLayoutConstraints");
                if (constraint != null && constraint instanceof KDLayout.Constraints) {
                    ((KDLayout.Constraints)constraint).originalBounds = rect;
                    ((KDLayout.Constraints)constraint).anchor = anchor;
                }
                component.setBounds(rect);
            } else {
                component.setBounds(rect);
            }
        } else {
            JComponent contentPane = UISegmentAssemblerHelper.getContentPane((JComponent)container);
            if (UISegmentAssemblerHelper.isKDLayout(container)) {
                KDLayout.Constraints constraint = new KDLayout.Constraints(rect.x, rect.y, rect.width, rect.height, anchor);
                component.setBounds(rect);
                contentPane.add((Component)component, constraint);
            } else {
                component.setBounds(rect);
                contentPane.add((Component)component, rect);
            }
        }
    }

    private Component createComponent(ComponentInfo cInfo, UISegmentAssemblerHelper.ComponentParam cp) {
        if (cInfo == null) {
            return null;
        }
        JComponent control = null;
        JComponent round = null;
        String classType = cInfo.getClassType();
        try {
            control = (JComponent)Class.forName(classType).newInstance();
            control.setName(cInfo.getName());
            this.localCtx.put(control.getName(), control);
            NewUILayoutExecutorHelper.initComponent(cInfo, control);
            if (control instanceof IKDTextComponent) {
                this.resetRequired(control, cInfo);
            }
            control.setOpaque(true);
            this.registerBindings(cInfo, control);
            this.bindAction(control, cp.action);
            control.setEnabled(cp.enabled);
            this.setHorizontalAlignment(control, cp);
            this.setText(control, cp.text);
            this.setIcon(control, cInfo);
            this.setTitle(control, cp.text);
            if (control instanceof KDPanel || control instanceof KDContainer) {
                this.initLayout(control, cInfo);
            }
            round = this.createRound(cInfo, control, cp);
            round.setVisible(cp.visible);
            ComponentInfo roundInfo = UISegmentAssemblerHelper.getRoundedComponent(cInfo);
            Container container = this.getSwingParent(roundInfo);
            if (container != null) {
                this.addToParent(container, round, roundInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"UISegmentAssembler createComponent error", (Throwable)e);
            return null;
        }
        return control;
    }

    private void setTitle(Component comp, String text) {
        try {
            Method method = comp.getClass().getMethod("setTitle", String.class);
            method.invoke((Object)comp, text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setIcon(Component comp, ComponentInfo cInfo) {
        String icon;
        PropertyInfo property;
        if ("com.kingdee.bos.ctrl.swing.KDButton".equals(cInfo.getClassType()) && (property = cInfo.getPropertyByName("icon")) != null && (icon = property.getValue()) != null) {
            ((KDButton)comp).setIcon(EASResource.getIcon((String)icon));
        }
    }

    private void setText(Component comp, String text) {
        try {
            Method method = comp.getClass().getMethod("setText", String.class);
            method.invoke((Object)comp, text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initLayout(Component comp, ComponentInfo cInfo) {
        JComponent contentPane = UISegmentAssemblerHelper.getContentPane((JComponent)comp);
        boolean kdLayout = UISegmentAssemblerHelper.isKDLayout(cInfo);
        if (kdLayout) {
            contentPane.setLayout((LayoutManager)new KDLayout());
            contentPane.putClientProperty("OriginalBounds", UISegmentAssemblerHelper.getComponentOriginalBounds(cInfo));
        } else {
            contentPane.setLayout(null);
        }
    }

    private void addToParent(Container parent, Component child, ComponentInfo childInfo) {
        JComponent container = UISegmentAssemblerHelper.getContentPane((JComponent)parent);
        if (container instanceof KDTabbedPane) {
            if (child.isVisible()) {
                ((KDTabbedPane)container).add(child, childInfo.getConstraint());
            }
        } else if (container instanceof KDToolBar || container instanceof KDMenu || container instanceof KDMenuBar) {
            container.add(child);
        } else {
            Rectangle rect = UISegmentAssemblerHelper.getBounds(childInfo);
            if (UISegmentAssemblerHelper.isKDLayout(container)) {
                KDLayout.Constraints cons = new KDLayout.Constraints(UISegmentAssemblerHelper.getAnchor(childInfo), rect);
                ((JComponent)child).putClientProperty("KDLayoutConstraints", cons);
            }
            child.setBounds(rect);
            if (container instanceof KDTablePanel) {
                ((KDTablePanel)container).add(child, (Object)rect);
            } else {
                container.add(child);
            }
        }
    }

    private JComponent createRound(ComponentInfo cInfo, JComponent control, UISegmentAssemblerHelper.ComponentParam cp) {
        if (cInfo.getParent() != null) {
            if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType()) && !this.localCtx.containsKey((cInfo = cInfo.getParent()).getName())) {
                KDScrollPane scrollPaneNoteField = new KDScrollPane();
                scrollPaneNoteField.getViewport().add((Component)control, null);
                control = scrollPaneNoteField;
                control.setName(cInfo.getName());
                this.localCtx.put(control.getName(), control);
            }
            if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType()) && !this.localCtx.containsKey((cInfo = cInfo.getParent()).getName())) {
                KDLabelContainer lblContainer = new KDLabelContainer();
                lblContainer.setBoundLabelText(cp.boundLabelText);
                lblContainer.setBoundLabelLength(cp.boundLabelLength);
                lblContainer.setBoundLabelUnderline(cp.boundLabelUnderline);
                lblContainer.setBoundLabelAlignment(cp.boundLabelAlignment);
                lblContainer.getBoundLabel().setOpaque(true);
                lblContainer.setBoundEditor(control);
                control = lblContainer;
                control.setName(cInfo.getName());
                this.localCtx.put(control.getName(), control);
            }
        }
        return control;
    }

    private JComponent createTable(ComponentInfo cInfo, UISegmentAssemblerHelper.ComponentParam cp) {
        com.kingdee.bos.metadata.entity.PropertyInfo property;
        String field;
        KDTable table = new KDTable();
        table.setName(cInfo.getName());
        String buildDetail = cInfo.getExtendedProperty("buildDetail");
        if (this.bindEntity != null && "true".equals(buildDetail) && !StringUtils.isEmpty((String)(field = this.getBindFieldForEntry(cInfo))) && (property = this.bindEntity.getPropertyByName(field)) instanceof LinkPropertyInfo && property.isConfigured()) {
            RelationshipInfo rsi = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo entryEntity = rsi.getSupplierObject();
            BillEntryCustomAgent obj = new BillEntryCustomAgent();
            obj.setPK((IMetaDataPK)MetaDataPK.create((String)entryEntity.getFullName()));
            obj.setBOSType(entryEntity.getType());
            this.entrys.add(field);
            DataBinder databinder = this.baseUI.getDataBinder();
            boolean isUseAgent = this.baseUI.isUseAgent();
            HMDUtils.buildDetail((CoreUI)this.baseUI, (DataBinder)databinder, (KDTable)table, (AbstractObjectValue)obj, null, (boolean)isUseAgent);
        }
        return table;
    }

    private String getBindFieldForEntry(ComponentInfo cInfo) {
        PropertyBindingCollection bindings = cInfo.getPropertyBindings();
        PropertyBindingInfo pbinfo = bindings.get("userObject");
        if (pbinfo != null) {
            return pbinfo.getBingdingField();
        }
        return null;
    }

    private void setHorizontalAlignment(Component control, UISegmentAssemblerHelper.ComponentParam cp) {
        Method method = null;
        try {
            method = control.getClass().getMethod("setHorizontalAlignment", Integer.TYPE);
            method.invoke((Object)control, new Integer(cp.horizontalAlignment));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getEntrys() {
        return this.entrys;
    }

    private void resetParam(JComponent component, ComponentInfo cInfo) {
        if (component != null && cInfo != null) {
            Method method2;
            UISegmentAssemblerHelper.ComponentParam cp = UISegmentAssemblerHelper.getComponentParam(this.helper, cInfo);
            ComponentInfo parentInfo = cInfo.getParent();
            if (parentInfo != null) {
                if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(parentInfo.getClassType())) {
                    Container parent = component.getParent();
                    if (parent != null && parent instanceof KDTabbedPane && !cp.visible) {
                        ((KDTabbedPane)parent).remove((Component)component);
                    }
                } else {
                    component.setVisible(cp.visible);
                }
            }
            if (component instanceof KDButton || component instanceof KDRadioButton || component instanceof KDCheckBox || component instanceof KDLabel) {
                try {
                    method2 = component.getClass().getMethod("setText", String.class);
                    method2.invoke((Object)component, cp.text);
                }
                catch (Exception method2) {}
            } else if (component instanceof KDContainer) {
                try {
                    method2 = component.getClass().getMethod("setTitle", String.class);
                    method2.invoke((Object)component, cp.text);
                }
                catch (Exception method3) {}
            } else if (component instanceof KDLabelContainer) {
                KDLabelContainer lblContainer = (KDLabelContainer)component;
                lblContainer.setBoundLabelText(cp.boundLabelText);
                lblContainer.setBoundLabelLength(cp.boundLabelLength);
                lblContainer.setBoundLabelUnderline(cp.boundLabelUnderline);
                lblContainer.setBoundLabelAlignment(cp.boundLabelAlignment);
            }
        }
    }

    private void registerBindings(ComponentInfo cInfo, Component comp) {
        if (cInfo == null || comp == null) {
            logger.error((Object)"ComponentInfo or Component is null in registerBindings!");
            return;
        }
        int nn = cInfo.getPropertyBindings().size();
        for (int i = 0; i < nn; ++i) {
            PropertyBindingInfo propbInfo = cInfo.getPropertyBindings().get(i);
            if (cInfo.isHerited() && propbInfo.isHerited() && !propbInfo.isOverride()) {
                return;
            }
            String tempClassName = propbInfo.getFieldType();
            Class clazz = NewUILayoutExecutorHelper.getClassName(tempClassName);
            if (clazz == null) continue;
            try {
                DataBinder databinder = this.baseUI.getDataBinder();
                databinder.registerBinding(propbInfo.getBingdingField(), clazz, comp, propbInfo.getPropertyName());
                logger.info((Object)("head bind:dataBinder.registerBinding(" + propbInfo.getBingdingField() + "," + clazz + "," + comp.getName() + "," + propbInfo.getPropertyName() + ");"));
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"bind fail", (Throwable)ex);
            }
        }
    }

    private void bindAction(Component control, String actionName) {
        if (control != null && !StringUtils.isEmpty((String)actionName)) {
            Method method = null;
            try {
                ActionManager manager;
                ItemAction action;
                method = control.getClass().getMethod("setAction", Action.class);
                if (method != null && (action = (manager = this.baseUI.getActionManager()).getAction(actionName)) != null) {
                    method.invoke((Object)control, (IItemAction)ActionProxyFactory.getProxy((Object)action, (Class[])new Class[]{IItemAction.class}, (Map)this.baseUI.getServiceContext4Dyn()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doAction(ActionCollection actions) {
        if (actions == null) {
            return;
        }
        ActionManager manager = this.baseUI.getActionManager();
        int size = actions.size();
        for (int i = 0; i < size; ++i) {
            ActionInfo actionInfo = actions.get(i);
            if (manager.getActionSet().containsKey(actionInfo.getName())) continue;
            ItemAction actionInstance = new ItemAction((IUIObject)this.baseUI);
            actionInstance.putValue("Name", (Object)actionInfo.getName());
            actionInstance.setActionName(actionInfo.getClassName());
            actionInstance.setEnabled(actionInfo.isEnabled());
            actionInstance.setDaemonRun(actionInfo.isDaemonRun());
            if (actionInfo.isBindWorkFlow()) {
                actionInstance.setBindWorkFlow(true);
            }
            ActionExtendPropertyHelper helper = new ActionExtendPropertyHelper(actionInfo.getActionExtendProperty());
            List pairs = helper.getKeyValuePairs();
            int j1 = pairs.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                String key = ((String[])pairs.get(i1))[0];
                String value = ((String[])pairs.get(i1))[1];
                actionInstance.setExtendProperty(key, value);
            }
            List services = ActionServicePropertyHelper.parseServiceItems((String)actionInfo.getServices());
            int j2 = services.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                ServiceItem item = (ServiceItem)services.get(i2);
                if (item == null || StringUtils.isEmpty((String)item.getServiceClass())) continue;
                try {
                    Object obj = Class.forName(item.getServiceClass()).newInstance();
                    if (!(obj instanceof IBindService)) continue;
                    actionInstance.addService((IBindService)obj);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"\"item.getServiceClass()\" is not correct!", (Throwable)e);
                }
            }
            manager.registerAction(actionInfo.getName(), actionInstance);
        }
    }

    public CoreUI getBaseUI() {
        return this.baseUI;
    }

    public DynamicExtendService getService() {
        return this.service;
    }
}

