/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class UISegmentAssemblerHelper {
    private static final Logger logger = Logger.getLogger(UISegmentAssemblerHelper.class);

    public static ComponentParam getComponentParam(ResourceBundleHelper helper, ComponentInfo cInfo) {
        String propValue;
        ComponentParam cp = new ComponentParam();
        if (cInfo == null) {
            return cp;
        }
        ComponentInfo roundInfo = UISegmentAssemblerHelper.getRoundedComponent(cInfo);
        PropertyInfo property = cInfo.getPropertyByName("required");
        if (property != null) {
            propValue = property.getValue();
            cp.required = propValue != null && propValue.equalsIgnoreCase("true");
        }
        if ((property = roundInfo.getPropertyByName("enabled")) != null) {
            propValue = property.getValue();
            cp.enabled = propValue == null || !propValue.equalsIgnoreCase("false");
        }
        if ((property = cInfo.getPropertyByName("horizontalAlignment")) != null && property.getValue() != null) {
            int propValue2;
            cp.horizontalAlignment = propValue2 = Integer.parseInt(property.getValue());
        }
        if ((property = cInfo.getPropertyByName("visible")) != null) {
            String propValue3 = property.getValue();
            cp.visible = propValue3 == null || !propValue3.equalsIgnoreCase("false");
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(roundInfo.getClassType())) {
            cp.boundLabelText = StringUtils.isEmpty((String)roundInfo.getAlias()) ? roundInfo.getName() : roundInfo.getAlias();
        } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDWorkButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDMenu".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDMenuItem".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("text");
            if (property != null) {
                cp.text = UISegmentAssemblerHelper.getPropertyValue(helper, roundInfo, property);
            }
            if ((property = roundInfo.getPropertyByName("action")) != null) {
                cp.action = property.getValue();
            }
        } else if ("com.kingdee.bos.ctrl.swing.KDContainer".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("title");
            if (property != null) {
                cp.text = UISegmentAssemblerHelper.getPropertyValue(helper, roundInfo, property);
            }
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("boundLabelText");
            if (property != null) {
                cp.boundLabelText = UISegmentAssemblerHelper.getPropertyValue(helper, roundInfo, property);
            }
            if ((property = roundInfo.getPropertyByName("boundLabelLength")) != null) {
                cp.boundLabelLength = Integer.parseInt(property.getValue());
            }
            if ((property = roundInfo.getPropertyByName("boundLabelUnderline")) != null) {
                cp.boundLabelUnderline = Boolean.valueOf(property.getValue());
            }
            if ((property = roundInfo.getPropertyByName("boundLabelAlignment")) != null) {
                cp.boundLabelAlignment = Integer.parseInt(property.getValue());
            }
        } else {
            property = roundInfo.getPropertyByName("text");
            if (property != null) {
                cp.boundLabelText = UISegmentAssemblerHelper.getPropertyValue(helper, roundInfo, property);
            }
        }
        return cp;
    }

    public static Rectangle getComponentOriginalBounds(ComponentInfo component) {
        Rectangle rect = new Rectangle(0, 0, 1, 1);
        if (component != null) {
            Object constraint = component.getConstraint();
            if (constraint != null && (constraint instanceof Rectangle || constraint instanceof KDLayoutConstraint)) {
                if (constraint instanceof Rectangle) {
                    rect.x = ((Rectangle)constraint).x;
                    rect.y = ((Rectangle)constraint).y;
                    rect.width = ((Rectangle)constraint).width;
                    rect.height = ((Rectangle)constraint).height;
                } else if (constraint instanceof KDLayoutConstraint) {
                    rect.x = ((KDLayoutConstraint)constraint).x;
                    rect.y = ((KDLayoutConstraint)constraint).y;
                    rect.width = ((KDLayoutConstraint)constraint).width;
                    rect.height = ((KDLayoutConstraint)constraint).height;
                }
            } else if (component.getParent() != null) {
                Rectangle parentBounds = UISegmentAssemblerHelper.getComponentOriginalBounds(component.getParent());
                if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(component.getParent().getClassType())) {
                    rect.width = parentBounds.width - 1;
                    rect.height = parentBounds.height - 33;
                    if (rect.width < 1) {
                        rect.width = 1;
                    }
                    if (rect.height < 1) {
                        rect.height = 1;
                    }
                } else if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(component.getParent().getClassType())) {
                    int dividerLocation = -1;
                    PropertyInfo prop = component.getParent().getPropertyByName("dividerLocation");
                    if (prop != null && !StringUtils.isEmpty((String)prop.getValue())) {
                        dividerLocation = Integer.parseInt(prop.getValue());
                    }
                    if ("left".equals(constraint)) {
                        rect.width = dividerLocation == -1 ? (parentBounds.width - 10) / 2 - 1 : dividerLocation - 1;
                        rect.height = parentBounds.height - 1;
                    } else if ("right".equals(constraint)) {
                        rect.width = dividerLocation == -1 ? (parentBounds.width - 10) / 2 - 1 : parentBounds.width - dividerLocation - 10 - 1;
                        rect.height = parentBounds.height - 1;
                    } else if ("top".equals(constraint)) {
                        rect.height = dividerLocation == -1 ? (parentBounds.height - 10) / 2 - 1 : dividerLocation - 1;
                        rect.width = parentBounds.width - 1;
                    } else if ("bottom".equals(constraint)) {
                        rect.height = dividerLocation == -1 ? (parentBounds.height - 10) / 2 - 1 : parentBounds.height - dividerLocation - 10 - 1;
                        rect.width = parentBounds.width - 1;
                    }
                    if (rect.width < 1) {
                        rect.width = 1;
                    }
                    if (rect.height < 1) {
                        rect.height = 1;
                    }
                } else {
                    rect.x = parentBounds.x;
                    rect.y = parentBounds.y;
                    rect.width = parentBounds.width;
                    rect.height = parentBounds.height;
                }
            }
        }
        return rect;
    }

    private static String getPropertyValue(ResourceBundleHelper helper, ComponentInfo cInfo, PropertyInfo property) {
        String value = "";
        if (ResourceListenerManager.isMultiLanguages()) {
            try {
                value = helper.getString(cInfo.getName() + "." + property.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isEmpty((String)value) || value.toLowerCase().indexOf("not matched") >= 0) {
                value = property.getValue();
            }
        } else {
            value = property.getValue();
            if (StringUtils.isEmpty((String)value)) {
                try {
                    value = helper.getString(cInfo.getName() + "." + property.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    public static boolean isKDLayout(Container component) {
        if ((component = UISegmentAssemblerHelper.getContentPane((JComponent)component)) == null) {
            return false;
        }
        return component.getLayout() != null && component.getLayout() instanceof KDLayout;
    }

    public static boolean isKDLayout(ComponentInfo cInfo) {
        if (cInfo == null || !cInfo.isContainer()) {
            return false;
        }
        LayoutInfo layout = cInfo.getLayoutInfo();
        return layout != null && "KDLayout".equalsIgnoreCase(layout.getType());
    }

    public static boolean isXYLayout(Container component) {
        if ((component = UISegmentAssemblerHelper.getContentPane((JComponent)component)) == null) {
            return false;
        }
        return component.getLayout() == null;
    }

    public static boolean isXYLayout(ComponentInfo cInfo) {
        if (cInfo == null || !cInfo.isContainer()) {
            return false;
        }
        LayoutInfo layout = cInfo.getLayoutInfo();
        return layout != null && "XYLayout".equalsIgnoreCase(layout.getType());
    }

    public static Rectangle getBounds(ComponentInfo component) {
        Object constraint = component.getConstraint();
        if (constraint != null) {
            if (constraint instanceof Rectangle) {
                return (Rectangle)constraint;
            }
            if (constraint instanceof KDLayoutConstraint) {
                return ((KDLayoutConstraint)constraint).toRectangle();
            }
        }
        return null;
    }

    public static int getAnchor(ComponentInfo component) {
        Object constraint = component.getConstraint();
        if (constraint instanceof KDLayoutConstraint) {
            return ((KDLayoutConstraint)constraint).anchor;
        }
        return 0;
    }

    public static JComponent getContentPane(JComponent component) {
        if (component instanceof KDContainer) {
            return ((KDContainer)component).getContentPane();
        }
        return component;
    }

    public static JComponent getRoundedComponent(JComponent component) {
        KDTable table;
        if (component instanceof KDTable && (table = (KDTable)component).getParent() != null && table.getParent().getParent() != null && table.getParent().getParent() instanceof DetailPanel) {
            return (JComponent)table.getParent().getParent();
        }
        if (component != null) {
            if (component instanceof KDTextArea && component.getParent() instanceof KDScrollPane) {
                component = (JComponent)component.getParent();
            }
            if (component.getParent() instanceof KDLabelContainer) {
                component = (JComponent)component.getParent();
            }
        }
        return component;
    }

    public static ComponentInfo getRoundedComponent(ComponentInfo component) {
        if (component != null) {
            if (("com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(component.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(component.getClassType())) && component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDScrollPane".equalsIgnoreCase(component.getParent().getClassType())) {
                component = component.getParent();
            }
            if (component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getParent().getClassType())) {
                component = component.getParent();
            }
        }
        return component;
    }

    public static class ComponentParam {
        public String boundLabelText = "";
        public int boundLabelLength = 100;
        public boolean boundLabelUnderline = false;
        public int boundLabelAlignment = 7;
        public Color foreground = new Color(0, 0, 0);
        public boolean enabled = true;
        public boolean required = false;
        public boolean visible = true;
        public String text = "";
        public String action = "";
        public int horizontalAlignment = 2;
    }
}

