/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime.bizrule;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.ep.RuleCollection;
import com.kingdee.eas.ep.RuleSetInfo;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.client.UIParamUtil;
import com.kingdee.eas.ep.client.editor.bizrule.RuleManager;
import com.kingdee.eas.ep.client.runtime.bizrule.IBizRuleHandler;
import com.kingdee.eas.ep.client.runtime.bizrule.UIParamAdapter;
import com.kingdee.eas.ep.client.runtime.bizrule.listener.RuleActionListener;
import com.kingdee.eas.ep.client.runtime.bizrule.listener.RuleChangeListener;
import com.kingdee.eas.ep.client.runtime.bizrule.listener.RuleDataChangeListener;
import com.kingdee.eas.ep.client.runtime.bizrule.listener.RuleDocumentListener;
import com.kingdee.eas.ep.client.runtime.bizrule.listener.RuleKDTEditListener;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.NewUILifeCycleHander;
import com.kingdee.eas.framework.client.UILifeCycleHander;
import java.awt.Container;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class BizRuleHandler
implements IBizRuleHandler {
    private static final Logger logger = Logger.getLogger(BizRuleHandler.class);
    private UIParam scriptParam;
    private RuleSetInfo ruleSet;
    private CoreUI ui;

    public BizRuleHandler(CoreUI ui) {
        this.ui = ui;
        this.scriptParam = new UIParamAdapter();
        UIParamUtil.createUIParam((Container)ui, this.scriptParam, true);
        IMetaDataPK pk = ui.getMetaDataPK();
        this.ruleSet = RuleManager.getInstance().getRuleSet(pk.getFullName());
    }

    @Override
    public void handler(JComponent component) {
        UILifeCycleHander handler;
        if (component != null && (handler = this.ui.getUILifeCycleHandler()) instanceof NewUILifeCycleHander) {
            String name = component.getName();
            if (component instanceof KDTable) {
                int j = ((KDTable)component).getColumnCount();
                for (int i = 0; i < j; ++i) {
                    IColumn column = ((KDTable)component).getColumn(i);
                    RuleCollection rules = this.ruleSet.getRules(name + "." + column.getKey());
                    if (rules.isEmpty()) continue;
                    EventListener listener = this.createListener(component, rules);
                    if (listener != null) {
                        ((RuleKDTEditListener)((Object)listener)).setColumnName(column.getKey());
                        ((NewUILifeCycleHander)handler).addChangeEventListener(listener, (Object)component);
                        continue;
                    }
                    logger.error((Object)("BizRuleHandler : can't find listener for component : " + component.getClass().getName()));
                }
            } else {
                RuleCollection rules = this.ruleSet.getRules(name);
                if (!rules.isEmpty()) {
                    EventListener listener = this.createListener(component, rules);
                    if (listener != null) {
                        ((NewUILifeCycleHander)handler).addChangeEventListener(listener, (Object)component);
                    } else {
                        logger.error((Object)("BizRuleHandler : can't find listener for component : " + component.getClass().getName()));
                    }
                }
            }
        }
    }

    private EventListener createListener(JComponent component, RuleCollection rules) {
        Object listener = null;
        if (component instanceof KDBizPromptBox) {
            listener = new RuleDataChangeListener(rules, this.scriptParam);
        } else if (component instanceof KDFormattedTextField) {
            listener = new RuleDataChangeListener(rules, this.scriptParam);
        } else if (component instanceof IKDEditor) {
            listener = new RuleDataChangeListener(rules, this.scriptParam);
        } else if (component instanceof JTextComponent) {
            listener = new RuleDocumentListener(rules, this.scriptParam);
        } else if (component instanceof KDSpinner) {
            listener = new RuleChangeListener(rules, this.scriptParam);
        } else if (component instanceof KDTable) {
            listener = new RuleKDTEditListener(rules, this.scriptParam);
        } else if (component instanceof KDCheckBox) {
            listener = new RuleActionListener(rules, this.scriptParam);
        }
        return listener;
    }
}

