/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime.bizrule.listener;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.RuleCollection;
import com.kingdee.eas.ep.RuleInfo;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.client.runtime.bizrule.listener.ScriptBuilder;
import com.kingdee.eas.ep.plugin.ScriptExecuteException;
import com.kingdee.eas.ep.plugin.ScriptExecutorFactotry;
import com.kingdee.eas.ep.plugin.ScriptInfo;
import com.kingdee.eas.util.client.ExceptionHandler;

public abstract class AbstractRuleListener {
    private RuleCollection rules;
    private UIParam scriptParam;

    protected AbstractRuleListener(RuleCollection rules, UIParam scriptParam) {
        this.rules = rules;
        this.scriptParam = scriptParam;
    }

    protected void execute() {
        if (this.rules != null && !this.rules.isEmpty()) {
            for (int i = 0; i < this.rules.size(); ++i) {
                RuleInfo rule = this.rules.get(i);
                ActionInfo condition = rule.getCondition();
                Object result = this.excuteAction(condition);
                if (!Boolean.TRUE.equals(result)) continue;
                ActionInfo action = rule.getAction();
                this.excuteAction(action);
            }
        }
    }

    private Object excuteAction(ActionInfo action) {
        Object result = Boolean.TRUE;
        if (action != null) {
            ScriptBuilder sb = new ScriptBuilder(action);
            String script = sb.getScript();
            ScriptInfo scriptInfo = new ScriptInfo(script, false, null);
            try {
                result = ScriptExecutorFactotry.getClientInstance().execute(this.scriptParam, null, scriptInfo);
            }
            catch (ScriptExecuteException e) {
                ExceptionHandler.handle((Throwable)((Object)e));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return result;
    }
}

