/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime.bizrule.listener;

import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.ParamType;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.util.StringUtils;

public class ScriptBuilder {
    private ActionInfo action;

    ScriptBuilder(ActionInfo action) {
        this.action = action;
    }

    String getScript() {
        if (this.action == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.action.getInstanceClass())) {
            buffer.append("new ");
            buffer.append(this.action.getInstanceClass());
            buffer.append("(");
        }
        RuleParameterCollection parameters = this.action.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            RuleParameterInfo parameterInfo = parameters.get(i);
            buffer.append(this.getParamterScript(parameterInfo));
            if (i == parameters.size() - 1) continue;
            buffer.append(" , ");
        }
        if (!StringUtils.isEmpty((String)this.action.getInstanceClass())) {
            buffer.append(")");
            buffer.append(".execute()");
        }
        return buffer.toString();
    }

    private String getParamterScript(RuleParameterInfo param) {
        ParamType type = param.getType();
        String value = param.getValue();
        if (ParamType.component.equals((Object)type)) {
            return this.getComponent(value);
        }
        if (ParamType.components.equals((Object)type)) {
            return this.getComponents(value);
        }
        if (ParamType.constant.equals((Object)type)) {
            return this.getConstant(value);
        }
        if (ParamType.constants.equals((Object)type)) {
            return this.getConstants(value);
        }
        if (ParamType.script.equals((Object)type)) {
            return value;
        }
        return "";
    }

    private String getComponent(String compName) {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)compName) && compName.indexOf(".") > 0) {
            String[] split = StringUtils.split((String)compName, (String)".");
            buffer.append("pluginCtx.getColumn(\"");
            buffer.append(split[0]);
            buffer.append("\" , \"");
            buffer.append(split[1]);
            buffer.append("\")");
        } else {
            buffer.append("pluginCtx.getComponent(\"");
            buffer.append(compName);
            buffer.append("\")");
        }
        return buffer.toString();
    }

    private String getComponents(String compNames) {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)compNames)) {
            buffer.append("[");
            String[] split = compNames.indexOf(",") > 0 ? compNames.split(",") : new String[]{compNames};
            for (int i = 0; i < split.length; ++i) {
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(this.getComponent(split[i]));
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    private String getConstant(String value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\"");
        buffer.append(value);
        buffer.append("\"");
        return buffer.toString();
    }

    private String getConstants(String value) {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)value)) {
            buffer.append("[");
            String[] split = value.indexOf(",") > 0 ? value.split(",") : new String[]{value};
            for (int i = 0; i < split.length; ++i) {
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(this.getConstant(split[i]));
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

