/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime.bizrule.process;

import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.runtime.bizrule.process.IProcess;
import java.awt.Component;
import java.awt.EventQueue;

public class TakeBaseData
implements IProcess {
    private TakebaseDataForHead takeHead;
    private TakebaseDataForEntry takeEntry;

    public TakeBaseData(KDBizPromptBox source, String[] fieldNames, Component[] targets) {
        this.takeHead = new TakebaseDataForHead(source, fieldNames, targets);
    }

    public TakeBaseData(ICell source, String[] fieldNames, ICell[] targets) {
        this.takeEntry = new TakebaseDataForEntry(source, fieldNames, targets);
    }

    @Override
    public void execute() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TakeBaseData.this.takeHead != null) {
                    TakeBaseData.this.takeHead.execute();
                } else if (TakeBaseData.this.takeEntry != null) {
                    TakeBaseData.this.takeEntry.execute();
                }
            }
        });
    }

    private class TakebaseDataForEntry
    implements IProcess {
        private ICell source;
        private String[] fieldNames;
        private ICell[] targets;

        private TakebaseDataForEntry(ICell source, String[] fieldNames, ICell[] targets) {
            this.source = source;
            this.fieldNames = fieldNames;
            this.targets = targets;
        }

        @Override
        public void execute() {
            IObjectValue valueObject = (IObjectValue)this.source.getValue();
            if (valueObject != null && this.fieldNames.length > 0 && this.fieldNames.length == this.targets.length) {
                for (int i = 0; i < this.fieldNames.length; ++i) {
                    String fieldName = this.fieldNames[i];
                    ICell cell = this.targets[i];
                    cell.setValue(valueObject.get(fieldName));
                }
            }
        }
    }

    private class TakebaseDataForHead
    implements IProcess {
        private KDBizPromptBox source;
        private String[] fieldNames;
        private Component[] targets;

        private TakebaseDataForHead(KDBizPromptBox source, String[] fieldNames, Component[] targets) {
            this.source = source;
            this.fieldNames = fieldNames;
            this.targets = targets;
        }

        @Override
        public void execute() {
            IObjectValue valueObject = (IObjectValue)this.source.getData();
            if (valueObject != null && this.fieldNames.length > 0 && this.fieldNames.length == this.targets.length) {
                for (int i = 0; i < this.fieldNames.length; ++i) {
                    String fieldName = this.fieldNames[i];
                    Component target = this.targets[i];
                    this.doTake(valueObject, fieldName, target);
                }
            }
        }

        private void doTake(IObjectValue valueObject, String fieldName, Component target) {
            Field field = new Field(fieldName);
            String propertyName = DataBindUtils.getPropertyName(target.getClass());
            ComponentProperty compProp = new ComponentProperty(propertyName, target);
            BindingUtility.loadData((IObjectValue)valueObject, (Field)field, (ComponentProperty)compProp);
        }
    }
}

