/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime.uischeme;

import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.ep.client.runtime.uischeme.IBackUpInfo;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class CommonBackUpInfo
implements IBackUpInfo {
    protected JComponent target;
    protected Map status;

    public CommonBackUpInfo(JComponent component) {
        this.target = component;
        this.status = this.backUpComponent(component);
    }

    @Override
    public void rollBack() {
        this.rollBack(this.getTarget(), this.getStatus());
    }

    protected void rollBack(JComponent target, Map status) {
        Object obj;
        Object value = status.get("enabled");
        if (value != null && value instanceof Boolean) {
            target.setEnabled((Boolean)value);
        }
        if ((value = status.get("visible")) != null && value instanceof Boolean) {
            target.setVisible((Boolean)value);
        }
        if (target instanceof IKDTextComponent && (value = status.get("required")) != null && value instanceof Boolean) {
            ((IKDTextComponent)target).setRequired(((Boolean)value).booleanValue());
        }
        if ((obj = status.get("_constraint")) != null && obj instanceof KDLayout.Constraints) {
            KDLayout.Constraints old = (KDLayout.Constraints)obj;
            KDLayout.Constraints constraint = new KDLayout.Constraints(old.originalBounds.x, old.originalBounds.y, old.originalBounds.width, old.originalBounds.height, old.anchor);
            target.putClientProperty("KDLayoutConstraints", constraint);
        }
        if ((obj = status.get("_bounds")) != null && obj instanceof Rectangle) {
            Rectangle rec = new Rectangle();
            rec.setBounds((Rectangle)obj);
            target.setBounds(rec);
        }
    }

    protected Map backUpComponent(JComponent component) {
        HashMap<String, Serializable> entry = new HashMap<String, Serializable>();
        entry.put("visible", new Boolean(component.isVisible()));
        entry.put("enabled", new Boolean(component.isEnabled()));
        if (component instanceof IKDTextComponent) {
            entry.put("required", new Boolean(((IKDTextComponent)component).isRequired()));
        }
        if (component.getClientProperty("KDLayoutConstraints") != null) {
            KDLayout.Constraints old = (KDLayout.Constraints)component.getClientProperty("KDLayoutConstraints");
            KDLayout.Constraints constraint = new KDLayout.Constraints(old.originalBounds.x, old.originalBounds.y, old.originalBounds.width, old.originalBounds.height, old.anchor);
            entry.put("_constraint", (Serializable)constraint);
        }
        if (component.getBounds() != null) {
            Rectangle rec = new Rectangle();
            rec.setBounds(component.getBounds());
            entry.put("_bounds", rec);
        }
        return entry;
    }

    public JComponent getTarget() {
        return this.target;
    }

    public Map getStatus() {
        return this.status;
    }
}

