/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.runtime.uischeme;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.eas.ep.client.runtime.NewUILayoutExecutorHelper;
import com.kingdee.eas.ep.client.runtime.uischeme.CommonBackUpInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class KDTableBackUpInfo
extends CommonBackUpInfo {
    public KDTableBackUpInfo(JComponent component) {
        super(component);
    }

    @Override
    protected Map backUpComponent(JComponent component) {
        Map entry = super.backUpComponent(component);
        KDTable table = (KDTable)component;
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        entry.put(component, columns);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IColumn column = table.getColumn(i);
            ColumnInfo back = this.createCopy(column);
            columns.add(back);
        }
        return entry;
    }

    @Override
    protected void rollBack(JComponent target, Map status) {
        super.rollBack(target, status);
        List columns = (List)status.get(this.getTarget());
        ArrayList<String> columnNames = new ArrayList<String>();
        KDTable table = (KDTable)this.getTarget();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo back = (ColumnInfo)columns.get(i);
            String name = back.getName();
            IColumn column = table.getColumn(name);
            this.backUpColumn(column, back);
            columnNames.add(name);
        }
        NewUILayoutExecutorHelper.reOrderTableColumn(table, columnNames);
    }

    private ColumnInfo createCopy(IColumn column) {
        ColumnInfo newColumn = new ColumnInfo();
        newColumn.setName(column.getKey());
        newColumn.setHide(column.getStyleAttributes().isHided());
        newColumn.setLock(column.getStyleAttributes().isLocked());
        newColumn.setRequired(column.isRequired());
        return newColumn;
    }

    private void backUpColumn(IColumn column, ColumnInfo back) {
        column.getStyleAttributes().setHided(back.isHide());
        column.getStyleAttributes().setLocked(back.isLock());
        column.setRequired(back.isRequired());
    }
}

