/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.script.ClassNameProvider;
import com.kingdee.eas.ep.client.script.ClassProvider;
import com.kingdee.eas.ep.client.script.ClassProviderImp;
import com.kingdee.eas.ep.client.script.PackageProvider;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class AutoImportAction
extends AbstractAction {
    private static final long serialVersionUID = -329529260654970384L;
    private static final Logger logger = CoreUIObject.getLogger(AutoImportAction.class);
    private ClassNameProvider nameProvider = new ClassNameProvider();
    private PackageProvider packageProvider = new PackageProvider();
    private ClassProvider classProvider;

    public AutoImportAction(int type) {
        this.classProvider = new ClassProviderImp(type);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private Set<String> getUnImportClasses(String script) {
        Set packages = this.packageProvider.getPackages(script);
        Set names = this.nameProvider.getClassNames(script);
        HashSet<String> result = new HashSet<String>();
        for (String name : names) {
            if (this.contains(packages, name)) continue;
            result.add(name);
        }
        return result;
    }

    private boolean contains(Set<String> packages, String className) {
        for (String next : packages) {
            if (!this.exist(next + "." + className)) continue;
            return true;
        }
        return false;
    }

    private boolean exist(String className) {
        try {
            Class<?> forName = Class.forName(className);
            return forName != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void install(JTextComponent c) {
        ActionMap actionMap = c.getActionMap();
        InputMap inputMap = c.getInputMap(1);
        actionMap.put("AUTO IMPORT", this);
        KeyStroke t_import = KeyStroke.getKeyStroke(79, 3);
        inputMap.put(t_import, "AUTO IMPORT");
        c.setActionMap(actionMap);
    }
}

