/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassNameProvider {
    private static final String javaName = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    private static final String prefix = "[\\s;(=,]";
    private static final String new_regex = "[\\s;(=,]new\\s+([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*\\(";
    private static final String static_regex = "[\\s;(=,]([a-zA-Z_$][a-zA-Z0-9_$]*)\\.[a-zA-Z_$][a-zA-Z0-9_$]*[;\\s*\\(\\)]";
    private static final String variable_regex = "(?:,\\s*|var\\s+)([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*[=;]";

    protected Set getClassNames(String source) {
        Set result = this.getMatchResult(source, new_regex);
        result.addAll(this.getMatchResult(source, static_regex));
        result.removeAll(this.getMatchResult(source, variable_regex));
        result.remove("pluginCtx");
        result.remove("methodCtx");
        return result;
    }

    private Set getMatchResult(String source, String regex) {
        HashSet<String> result = new HashSet<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String str = matcher.group(1);
            if (StringUtils.isEmpty((String)str)) continue;
            result.add(str);
        }
        return result;
    }
}

