/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.eas.ep.client.script.ClassProvider;
import com.kingdee.eas.ep.client.script.Expression;
import com.kingdee.eas.ep.client.script.Type;
import com.kingdee.eas.ep.client.script.Variable;
import com.kingdee.eas.ep.client.script._Rectangle;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Domain {
    public static final String VAR = "var";
    public static final String NEW = "new";
    private List variables = new ArrayList();
    private String[] space = null;
    private _Rectangle rec = new _Rectangle();
    private Domain parent = null;
    private ClassProvider provider = null;

    public Domain(ClassProvider provider) {
        this.provider = provider;
    }

    private String getClassName(String name) {
        Class c;
        if (this.provider != null && (c = this.provider.getClass(name)) != null) {
            return c.getName();
        }
        return null;
    }

    private String getSpaceClassName(String name) {
        String c = null;
        if (name.indexOf(46) > 0) {
            c = this.getClassName(name);
        } else if ('A' <= name.charAt(0) && name.charAt(0) <= 'Z' && this.space != null) {
            for (int i = 0; i < this.space.length && (c = this.getClassName(this.space[i] + "." + name)) == null; ++i) {
            }
        }
        return c;
    }

    public void addVariable(Variable v) {
        if (v != null) {
            this.variables.add(v);
        }
    }

    public void setSpace(String[] space) {
        this.space = space;
    }

    public void setRectangle(_Rectangle rec) {
        this.rec = rec;
    }

    public _Rectangle getRectangle() {
        return this.rec;
    }

    public Domain getParent() {
        return this.parent;
    }

    public void setParent(Domain parent) {
        this.parent = parent;
    }

    public String[] getSpace() {
        return this.space;
    }

    public Variable getVariable(String name) {
        String c;
        Variable v = null;
        int size = this.variables.size();
        for (int i = 0; i < size; ++i) {
            Variable t = (Variable)this.variables.get(i);
            if (!name.equals(t.getName())) continue;
            v = t;
            break;
        }
        if (v == null && (c = this.getSpaceClassName(name)) != null) {
            v = new Variable(name, new Expression(c));
            this.addVariable(v);
        }
        if (v == null && this.parent != null) {
            v = this.parent.getVariable(name);
        }
        return v;
    }

    public void addVariable(String exp) {
        if (StringUtils.isEmpty((String)exp)) {
            return;
        }
        String assign = exp.trim();
        if (assign.startsWith(VAR)) {
            assign = assign.substring(VAR.length());
        }
        if (assign.indexOf("=") <= 0 || assign.indexOf(59) <= assign.indexOf("=")) {
            return;
        }
        String name = assign.substring(0, assign.indexOf("=")).trim();
        String value = assign.substring(assign.indexOf("=") + 1, assign.indexOf(59)).trim();
        Variable v = new Variable(name, this.buildExpression(value));
        this.addVariable(v);
    }

    private Expression constantExp(String exp) {
        if (exp.startsWith("'") && exp.endsWith("'") || exp.startsWith("\"") && exp.endsWith("\"")) {
            return new Expression(String.class.getName());
        }
        if ("true".equals(exp) || "false".equals(exp)) {
            return new Expression(Boolean.TYPE.getName());
        }
        if (this.isNumeric(exp)) {
            if (exp.indexOf(46) >= 0) {
                return new Expression(BigDecimal.class.getName());
            }
            return new Expression(Integer.TYPE.getName());
        }
        return null;
    }

    private boolean isNumeric(String exp) {
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private Expression newInstanceExp(String exp) {
        String type = null;
        if (exp.startsWith(NEW) && exp.indexOf(40) > NEW.length()) {
            type = this.getSpaceClassName(exp.substring(NEW.length() + 1, exp.indexOf(40)));
        }
        if (type != null) {
            Expression e = new Expression();
            e.setType(type);
            return e;
        }
        return null;
    }

    public Expression buildExpression(String exp) {
        if (StringUtils.isEmpty((String)exp)) {
            return null;
        }
        Expression constExp = this.constantExp(exp = exp.trim());
        if (constExp != null) {
            return constExp;
        }
        Expression newExp = this.newInstanceExp(exp);
        if (newExp != null) {
            return newExp;
        }
        Bracket[] bs = Bracket.buildBracket(this.getIndex(exp, '('), this.getIndex(exp, ')'));
        Bracket[] bsOuter = Bracket.getOuter(bs);
        Bracket max = this.getMax(bsOuter);
        if (max != null) {
            while (max.left == 0 && max.right == exp.length() - 1) {
                exp = exp.substring(1, max.right).trim();
                bs = Bracket.buildBracket(this.getIndex(exp, '('), this.getIndex(exp, ')'));
                bsOuter = Bracket.getOuter(bs);
                max = this.getMax(bsOuter);
            }
        }
        Bracket min = this.getMin(bsOuter);
        int iDot = this.getOuterDot(exp, max);
        if (max != null) {
            if (!this.isFollowByDot(exp, min.right) && !this.isFrontCharactor(exp, min.left)) {
                Expression e = new Expression(this.getSpaceClassName(exp.substring(min.left + 1, min.right)));
                return e;
            }
            if (iDot == -1) {
                Expression e = new Expression();
                e.setType(this.getSpaceClassName(exp.substring(max.left + 1, max.right)));
                return e;
            }
            if (max.right >= iDot) {
                Type root = null;
                String methodName = null;
                List params = null;
                String str = exp.substring(0, iDot);
                root = this.isValidVariable(str) ? this.getVariable(str) : this.buildExpression(str);
                methodName = exp.substring(iDot + 1, max.left);
                params = this.buildParams(exp.substring(max.left + 1, max.right));
                Expression e = new Expression();
                e.setRoot(root);
                e.setMethodName(methodName);
                e.setParams(params);
                return e;
            }
        } else {
            Expression e = new Expression();
            e.setRoot(this.getVariable(exp));
            return e;
        }
        return null;
    }

    private List buildParams(String params) {
        ArrayList<Expression> ps = new ArrayList<Expression>();
        if (StringUtils.isEmpty((String)params)) {
            return ps;
        }
        if (params.indexOf(44) > 0) {
            Bracket[] bs = Bracket.buildBracket(this.getIndex(params, '('), this.getIndex(params, ')'));
            if (bs == null || bs.length == 0) {
                String[] ss = params.split(",");
                for (int i = 0; i < ss.length; ++i) {
                    Expression type = this.buildExpression(ss[i]);
                    ps.add(type);
                }
            } else {
                int[] pp = this.getIndex(params, ',');
                for (int i = 0; i < pp.length; ++i) {
                    for (int j = 0; j < bs.length; ++j) {
                        if (!bs[j].indexInBracket(pp[i])) continue;
                        pp[i] = -1;
                    }
                }
                int start = 0;
                for (int i = 0; i < pp.length; ++i) {
                    if (pp[i] <= 0) continue;
                    ps.add(this.buildExpression(params.substring(start, pp[i])));
                    start = pp[i] + 1;
                }
                ps.add(this.buildExpression(params.substring(start)));
            }
        } else {
            Expression type = this.buildExpression(params);
            ps.add(type);
        }
        return ps;
    }

    private Bracket getMax(Bracket[] bs) {
        if (bs == null || bs.length == 0) {
            return null;
        }
        Bracket max = bs[0];
        for (int i = 1; i < bs.length; ++i) {
            if (max.left >= bs[i].left) continue;
            max = bs[i];
        }
        return max;
    }

    private Bracket getMin(Bracket[] bs) {
        if (bs == null || bs.length == 0) {
            return null;
        }
        Bracket min = bs[0];
        for (int i = 1; i < bs.length; ++i) {
            if (min.left <= bs[i].left) continue;
            min = bs[i];
        }
        return min;
    }

    private int getOuterDot(String exp, Bracket max) {
        if (max == null || exp.indexOf(46) < 0) {
            return exp.indexOf(46);
        }
        int index = exp.lastIndexOf(46, max.left);
        if (index < 0) {
            index = exp.indexOf(46, max.right);
        }
        return index;
    }

    private boolean isValidVariable(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        str = str.trim();
        boolean isValid = true;
        for (int i = 0; i < str.length(); ++i) {
            isValid = isValid && this.isValidVariableChar(str.charAt(i));
        }
        return isValid;
    }

    private boolean isValidVariableChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '.';
    }

    private boolean isValidChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    private boolean isFrontCharactor(String exp, int p) {
        for (int i = p - 1; i >= 0; --i) {
            char c = exp.charAt(i);
            if (Character.isWhitespace(c)) {
                continue;
            }
            return this.isValidChar(c);
        }
        return false;
    }

    private boolean isFollowByDot(String exp, int p) {
        for (int i = p + 1; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (Character.isWhitespace(c)) {
                continue;
            }
            return c == '.';
        }
        return false;
    }

    private int[] getIndex(String exp, char c) {
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int index = exp.indexOf(c);
        while (index >= 0) {
            indexs.add(new Integer(index));
            index = exp.indexOf(c, index + 1);
        }
        int[] is = new int[indexs.size()];
        int size = indexs.size();
        for (int i = 0; i < size; ++i) {
            is[i] = (Integer)indexs.get(i);
        }
        return is;
    }

    private static class Bracket {
        int left = -1;
        int right = -1;

        public Bracket(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public boolean indexInBracket(int i) {
            return i > this.left && i < this.right;
        }

        public boolean isIn(Bracket b) {
            if (b == null) {
                return false;
            }
            return this.left > b.left && this.right < b.right;
        }

        public static Bracket[] getOuter(Bracket[] bs) {
            if (bs == null) {
                return null;
            }
            ArrayList<Bracket> b = new ArrayList<Bracket>();
            for (int i = 0; i < bs.length; ++i) {
                boolean isIn = false;
                for (int j = 0; j < bs.length; ++j) {
                    isIn = isIn || bs[i].isIn(bs[j]);
                }
                if (isIn) continue;
                b.add(bs[i]);
            }
            return b.toArray(new Bracket[b.size()]);
        }

        public static Bracket[] buildBracket(int[] lefts, int[] rights) {
            if (lefts.length != rights.length) {
                return new Bracket[0];
            }
            Bracket[] bs = new Bracket[lefts.length];
            block0: for (int i = lefts.length - 1; i >= 0; --i) {
                for (int j = 0; j <= i; ++j) {
                    if (rights[j] <= lefts[i]) continue;
                    int tmp = rights[j];
                    for (int k = j; k < i; ++k) {
                        rights[k] = rights[k + 1];
                    }
                    rights[i] = tmp;
                    bs[i] = new Bracket(lefts[i], rights[i]);
                    continue block0;
                }
            }
            return bs;
        }
    }
}

