/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.eas.ep.client.script.SubStringAnalyzer;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.lucene.ep.analysis.Analyzer;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.Field;
import org.apache.lucene.ep.index.IndexWriter;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;

public class IndexJars {
    private static Set packages = new HashSet();
    private static String dirName = null;
    private static final Logger logger = Logger.getLogger(IndexJars.class);

    public static void index(String indexDir, String jarDir) throws Exception {
        File INDEX_DIR = new File(indexDir);
        if (INDEX_DIR.exists()) {
            logger.info((Object)("Cannot save index to '" + INDEX_DIR + "' directory, please delete it first"));
            return;
        }
        if (StringUtils.isEmpty((String)jarDir)) {
            logger.info((Object)("Document directory '" + jarDir + "' does not exist or is not readable, please check the path"));
            return;
        }
        Date start = new Date();
        IndexWriter writer = new IndexWriter((Directory)FSDirectory.open(INDEX_DIR), (Analyzer)new SubStringAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
        String[] splits = StringUtils.split((String)jarDir, (String)";");
        for (int i = 0; i < splits.length; ++i) {
            String split = splits[i];
            File JAR_DIR = new File(split);
            if (!JAR_DIR.exists() && !JAR_DIR.canRead()) continue;
            dirName = JAR_DIR.getPath();
            logger.info((Object)("Indexing to directory '" + INDEX_DIR + "'..."));
            IndexJars.indexDir(writer, JAR_DIR);
            logger.info((Object)"Indexing packages ...");
            IndexJars.indexPackages(writer);
            dirName = null;
        }
        logger.info((Object)"Optimizing...");
        writer.optimize();
        writer.close();
        Date end = new Date();
        logger.info((Object)(end.getTime() - start.getTime() + " total milliseconds"));
        packages.clear();
    }

    private static void indexPackages(IndexWriter writer) throws Exception {
        if (!packages.isEmpty()) {
            for (String p : packages) {
                Document doc = new Document();
                doc.add(new Field("path", "", Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add(new Field("name", p, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add(new Field("contents", p, Field.Store.YES, Field.Index.ANALYZED));
                writer.addDocument(doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void indexDir(IndexWriter writer, File dir) throws Exception {
        block7: {
            block8: {
                if (!dir.canRead()) break block7;
                if (!dir.isDirectory()) break block8;
                String[] files = dir.list();
                if (files == null) break block7;
                for (int i = 0; i < files.length; ++i) {
                    IndexJars.indexDir(writer, new File(dir, files[i]));
                }
                break block7;
            }
            logger.info((Object)("Indexing to file '" + dir.getName() + "'..."));
            try (JarFile jar = null;){
                jar = new JarFile(dir);
                IndexJars.indexJar(writer, jar);
            }
        }
    }

    private static void indexJar(IndexWriter writer, JarFile jar) throws Exception {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Document doc = IndexJars.getDoc(entry, jar);
            if (doc == null) continue;
            writer.addDocument(doc);
        }
    }

    private static Document getDoc(JarEntry entry, JarFile jar) {
        if (entry == null) {
            return null;
        }
        String name = StringUtils.replace((String)entry.getName(), (String)"/", (String)".");
        if (!entry.isDirectory() && name.endsWith(".class") && name.indexOf("$") <= 0) {
            Document doc = new Document();
            String className = name.substring(0, name.lastIndexOf("."));
            String path = jar.getName();
            if (path.indexOf(dirName) >= 0) {
                path = path.substring(dirName.length() + 1);
            }
            doc.add(new Field("path", path, Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add(new Field("name", className, Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add(new Field("contents", name, Field.Store.YES, Field.Index.ANALYZED));
            return doc;
        }
        if (entry.isDirectory()) {
            packages.add(name.substring(0, name.lastIndexOf(".")));
        }
        return null;
    }

    private static void initLog4j() {
        Properties prts = new Properties();
        try {
            prts.load(IndexJars.class.getResourceAsStream("log4j.properties"));
            PropertyConfigurator.configure((Properties)prts);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        String indexDir = null;
        String jarDir = null;
        if (args != null && args.length == 2) {
            indexDir = args[0];
            jarDir = args[1];
        }
        IndexJars.initLog4j();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        if (indexDir == null) {
            logger.info((Object)"Please choose a directory for saving index: ");
            indexDir = in.readLine();
        }
        if (jarDir == null) {
            logger.info((Object)"Please choose a jar directory for index: ");
            jarDir = in.readLine();
        }
        if (!StringUtils.isEmpty((String)jarDir) && !StringUtils.isEmpty((String)indexDir)) {
            String[] jars = StringUtils.split((String)jarDir, (String)";");
            for (int i = 0; i < jars.length; ++i) {
                IndexJars.index(indexDir, jars[i]);
            }
        }
    }
}

