/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.eas.ep.client.script.ClassProvider;
import com.kingdee.eas.ep.client.script.ClassProviderImp;
import com.kingdee.eas.ep.client.script.Domain;
import com.kingdee.eas.ep.client.script.Expression;
import com.kingdee.eas.ep.client.script.Variable;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class Interpreter {
    private static Logger logger = Logger.getLogger(Interpreter.class);
    private Map spaces;
    private int lineNo;
    private Stack domains;
    private List lstDomain;
    private String script;
    private Domain global;
    private ClassProvider provider;

    public Interpreter(String script, ClassProvider provider) {
        this.script = script;
        this.provider = provider;
        this.global = new Domain(provider);
        this.lineNo = 0;
        this.spaces = new HashMap();
        this.global.getRectangle().setFrom(0, this.lineNo);
        this.domains = new Stack();
        this.lstDomain = new ArrayList();
        this.init(provider.getType());
        this.domains.push(this.global);
        this.lstDomain.add(this.global);
    }

    private void init(int type) {
        Expression e = null;
        if (type == 1) {
            e = new Expression("com.kingdee.eas.ep.app.BeanParam");
        } else if (type == 0) {
            e = new Expression("com.kingdee.eas.ep.client.UIParam");
        } else if (type == 2) {
            e = new Expression("com.kingdee.eas.ep.web.DepWebParam");
        }
        this.global.addVariable(new Variable("pluginCtx", e));
        e = new Expression("com.kingdee.eas.ep.plugin.ExtendMethodInfo");
        this.global.addVariable(new Variable("methodCtx", e));
    }

    public Domain getGlobal() {
        return this.global;
    }

    public Domain getDomain(int x, int y) {
        Domain d = null;
        for (int i = this.lstDomain.size() - 1; i >= 0; --i) {
            d = (Domain)this.lstDomain.get(i);
            if (!d.getRectangle().locate(x, y)) continue;
            return d;
        }
        return null;
    }

    public Domain parse() {
        if (StringUtils.isEmpty((String)this.script)) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(this.script));
        try {
            BraceFilter filter = new BraceFilter();
            filter.addFilter(new SemicolonFilter());
            Segment last = null;
            String line = null;
            int spaceLine = 0;
            line = reader.readLine();
            this.lineNo = 1;
            while (line != null) {
                if (StringUtils.isEmpty((String)line)) {
                    if (++spaceLine > 20) break;
                    line = reader.readLine();
                    ++this.lineNo;
                    continue;
                }
                spaceLine = 0;
                Segment[] ss = filter.split(new Segment(0, line));
                if (ss != null) {
                    for (int i = 0; i < ss.length; ++i) {
                        if (this.parseImporter(ss[i].content)) continue;
                        this.parseSegment(last, ss[i]);
                        this.parseExpression(ss[i]);
                        last = ss[i];
                    }
                }
                line = reader.readLine();
                ++this.lineNo;
            }
            if (line != null) {
                this.global.getRectangle().xTo = line.length();
            }
            this.global.getRectangle().yTo = this.lineNo;
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return (Domain)this.domains.peek();
    }

    private void parseExpression(Segment s) {
        Domain d = (Domain)this.domains.peek();
        d.addVariable(s.content);
    }

    private void parseSegment(Segment last, Segment s) {
        Domain d;
        int i;
        if (s.content.indexOf(123) >= 0) {
            i = s.content.indexOf(123);
            while (i >= 0) {
                int wIn;
                d = new Domain(this.provider);
                d.getRectangle().xFrom = i + s.index;
                d.getRectangle().yFrom = this.lineNo;
                String spaceName = null;
                if (s.content.lastIndexOf("with(", i) >= 0) {
                    wIn = s.content.lastIndexOf("with(", i);
                    spaceName = s.content.substring(s.content.indexOf(40, wIn) + 1, s.content.indexOf(41, wIn));
                } else if (last != null && last.content.indexOf("with(") >= 0 && last.content.indexOf(123) < 0) {
                    wIn = last.content.lastIndexOf("with(", i);
                    spaceName = s.content.substring(s.content.indexOf(40, wIn) + 1, s.content.indexOf(41, wIn));
                }
                if (spaceName != null) {
                    d.setSpace(this.convertToArray((List)this.spaces.get(spaceName.trim())));
                }
                d.setParent((Domain)this.domains.peek());
                this.domains.push(d);
                this.lstDomain.add(d);
                i = s.content.indexOf(123, i + 1);
            }
        }
        if (s.content.indexOf(125) >= 0) {
            i = s.content.indexOf(125);
            while (i >= 0) {
                d = (Domain)this.domains.pop();
                d.getRectangle().xTo = i + s.index;
                d.getRectangle().yTo = this.lineNo;
                i = s.content.indexOf(125, i + 1);
            }
        }
    }

    private String[] convertToArray(List l) {
        if (l == null) {
            return new String[0];
        }
        return l.toArray(new String[l.size()]);
    }

    private boolean parseImporter(String imp) {
        if (StringUtils.isEmpty((String)imp)) {
            return false;
        }
        if (imp.indexOf("var") >= 0 && imp.indexOf("JavaImporter()") > 0) {
            String name = imp.substring(imp.indexOf("var") + "var".length(), imp.indexOf(61));
            this.spaces.put(name.trim(), new ArrayList());
            return true;
        }
        if (imp.indexOf("importPackage(") > 0 && imp.indexOf("Packages.") > 0) {
            List list;
            String name = imp.substring(0, imp.lastIndexOf(46, imp.indexOf("importPackage(")));
            int iPack = imp.indexOf("Packages.");
            String type = imp.substring(iPack + "Packages.".length(), imp.indexOf(41, iPack));
            if (!StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)type) && (list = (List)this.spaces.get(name.trim())) != null) {
                list.add(type.trim());
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        StringBuffer script = new StringBuffer();
        script.append("var easNames = JavaImporter();     \n\r");
        script.append("easNames.importPackage(Packages.com.kingdee.eas.base.codingrule);  \n\r");
        script.append("with(easNames){     \t\n\r");
        script.append("var editData = (com.kingdee.bos.dao.IObjectValue)pluginCtx.getDataObject();       \n\r");
        script.append("var bizOrgUnit= pluginCtx.getKDBizPromptBox(\"prmtSaleOrgUnit\");   \n\r");
        script.append("var number = CodingRuleManagerFactory.getRemoteInstance().getNumber(editData, (java.lang.String)bizOrgUnit.getId()); \n\r");
        script.append("pluginCtx.getKDTextField(\"txtNumber\").setText(number);   \n\r");
        script.append("}");
        new Interpreter(script.toString(), new ClassProviderImp(1)).parse();
    }

    static interface Filter {
        public Segment[] split(Segment var1);

        public void addFilter(Filter var1);

        public Filter next();
    }

    static abstract class BaseFilter
    implements Filter {
        private Filter next = null;

        BaseFilter() {
        }

        @Override
        public void addFilter(Filter f) {
            if (this.next == null) {
                this.next = f;
            } else {
                this.next.addFilter(f);
            }
        }

        @Override
        public Filter next() {
            return this.next;
        }

        protected Segment[] nextSplit(Segment[] ss) {
            if (this.next != null) {
                if (ss == null) {
                    return new Segment[0];
                }
                ArrayList ls = new ArrayList();
                for (int i = 0; i < ss.length; ++i) {
                    this.addSegments(ls, this.next.split(ss[i]));
                }
                return ls.toArray(new Segment[ls.size()]);
            }
            return ss;
        }

        private void addSegments(List l, Segment[] ss) {
            if (ss != null && l != null) {
                for (int i = 0; i < ss.length; ++i) {
                    l.add(ss[i]);
                }
            }
        }
    }

    static class SemicolonFilter
    extends BaseFilter {
        SemicolonFilter() {
        }

        @Override
        public Segment[] split(Segment s) {
            int index = s.content.indexOf(59);
            if (index < 0) {
                return new Segment[]{s};
            }
            ArrayList<Segment> ls = new ArrayList<Segment>();
            int start = 0;
            while (index >= 0) {
                ls.add(new Segment(s.index + start, s.content.substring(start, index + 1)));
                start = index + 1;
                index = s.content.indexOf(59, start);
            }
            if (start < s.content.length()) {
                ls.add(new Segment(s.index + start, s.content.substring(start)));
            }
            Segment[] ss = ls.toArray(new Segment[ls.size()]);
            ss = this.nextSplit(ss);
            return ss;
        }
    }

    static class BraceFilter
    extends BaseFilter {
        BraceFilter() {
        }

        @Override
        public Segment[] split(Segment s) {
            int index = s.content.indexOf(123);
            if (index < 0) {
                return new Segment[]{s};
            }
            ArrayList<Segment> ls = new ArrayList<Segment>();
            int start = 0;
            while (index >= 0) {
                ls.add(new Segment(s.index + start, s.content.substring(start, index + 1)));
                start = index + 1;
                index = s.content.indexOf(123, start);
            }
            if (start < s.content.length()) {
                ls.add(new Segment(s.index + start, s.content.substring(start)));
            }
            return this.nextSplit(ls.toArray(new Segment[ls.size()]));
        }
    }

    private static class Segment {
        int index;
        String content;

        Segment(int index, String content) {
            this.index = index;
            this.content = content;
        }
    }
}

