/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.eas.ep.client.script.ClassProvider;
import com.kingdee.eas.ep.client.script.ClassProviderImp;
import com.kingdee.eas.ep.client.script.Domain;
import com.kingdee.eas.ep.client.script.Expression;
import com.kingdee.eas.ep.client.script.Interpreter;
import com.kingdee.eas.ep.client.script.ScriptCompletionProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.apache.log4j.Logger;
import org.fife.ep.ui.autocomplete.FunctionCompletion;
import org.fife.ep.ui.autocomplete.ParameterizedCompletion;

public class MethodCompletionProvider
extends ScriptCompletionProvider {
    private Map refMap = null;
    private ClassProvider classProvider;
    private static final Logger logger = Logger.getLogger(MethodCompletionProvider.class);

    public MethodCompletionProvider(int type) {
        this.classProvider = new ClassProviderImp(type);
    }

    private boolean isSplitChar(char ch) {
        return ch == '\n' || ch == '=' || ch == ';' || ch == '\r';
    }

    private String getReferenceClassName(JTextComponent tc) {
        int line;
        int dot = tc.getCaretPosition();
        Segment s = new Segment();
        Document doc = tc.getDocument();
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(dot));
        int offs = elem.getStartOffset();
        int len = dot - offs;
        if (len <= 0) {
            return null;
        }
        try {
            Expression e;
            doc.getText(offs, len, s);
            String lineText = s.toString();
            boolean haveDot = false;
            for (offs = s.offset + len - 1; offs >= s.offset && (Character.isWhitespace(s.array[offs]) || s.array[offs] == '.'); --offs) {
                if (s.array[offs] != '.') continue;
                haveDot = true;
            }
            if (!haveDot && lineText.indexOf(46) > 0) {
                while (offs >= s.offset && s.array[offs] != '.') {
                    --offs;
                }
                --offs;
            }
            int end = offs;
            while (offs >= s.offset && !this.isSplitChar(s.array[offs])) {
                --offs;
            }
            String text = new String(s.array, offs + 1, end - offs);
            Interpreter interpreter = new Interpreter(tc.getText(), this.classProvider);
            interpreter.parse();
            Domain d = interpreter.getDomain(lineText.lastIndexOf(46), line + 1);
            if (d != null && (e = d.buildExpression(text)) != null) {
                return e.getType(this.classProvider);
            }
            return null;
        }
        catch (BadLocationException ble) {
            logger.error((Object)"MethodCompletionProvider.getReferenceClassName", (Throwable)ble);
            return null;
        }
    }

    private void buildRefMap(String script) {
        if (this.refMap == null) {
            this.refMap = new HashMap();
        } else {
            this.refMap.clear();
        }
    }

    @Override
    protected List getCompletionByInputText(JTextComponent tc, String inputText) {
        ArrayList<FunctionCompletion> comps = new ArrayList<FunctionCompletion>();
        this.buildRefMap(tc.getText());
        Class c = this.classProvider.getClass(this.getReferenceClassName(tc));
        if (c != null) {
            Method[] ms = c.getMethods();
            for (int i = 0; i < ms.length; ++i) {
                Method m = ms[i];
                String name = m.getName().toLowerCase(Locale.ENGLISH);
                if (!name.startsWith(inputText.toLowerCase(Locale.ENGLISH))) continue;
                FunctionCompletion f = new FunctionCompletion(this, m.getName(), m.getReturnType().toString());
                ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
                Class<?>[] pType = m.getParameterTypes();
                for (int j = 0; j < pType.length; ++j) {
                    params.add(new ParameterizedCompletion.Parameter(pType[j].getName(), "arg" + j));
                }
                f.setParams(params);
                f.setShortDescription(m.toString());
                comps.add(f);
            }
        }
        return comps;
    }
}

