/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.eas.ep.client.ScriptArea;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageProvider {
    private static final String javaName = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    private static final String packageName = "[a-zA-Z_$][a-zA-Z0-9_$\\.]*";
    private static final String prefix = "importPackage\\s*\\(Packages\\.";
    private static final String suffix = "\\s*\\)\\s*;?[\r\n]*";
    private static final String package_regex = "importPackage\\s*\\(Packages\\.([a-zA-Z_$][a-zA-Z0-9_$\\.]*)\\s*\\)\\s*;?[\r\n]*";
    private static final String declare_regex = "var\\s([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*=\\s*JavaImporter\\s*\\(\\s*\\);?[\r\n]*";

    public Set getPackages(String script) {
        HashSet<String> result = new HashSet<String>();
        Pattern pattern = Pattern.compile(package_regex);
        Matcher matcher = pattern.matcher(script);
        while (matcher.find()) {
            String str = matcher.group(1);
            if (StringUtils.isEmpty((String)str)) continue;
            result.add(str);
        }
        return result;
    }

    public void insertPackage(ScriptArea area, List packages) {
        Pattern pattern = Pattern.compile(declare_regex);
        String script = area.getText();
        Matcher matcher = pattern.matcher(script);
        int end = 0;
        String varName = "importer";
        if (matcher.find()) {
            varName = matcher.group(1);
            end = matcher.end();
            String packageScript = this.createPackageScript(varName, packages);
            area.insert(packageScript, end);
        } else {
            StringBuffer builder = new StringBuffer();
            builder.append("var importer = JavaImporter();\n");
            String packageScript = this.createPackageScript(varName, packages);
            builder.append(packageScript);
            builder.append("with(importer){\n");
            area.insert(builder.toString(), 0);
            area.append("\n}");
        }
    }

    private String createPackageScript(String varName, List packages) {
        StringBuffer builder = new StringBuffer();
        for (int i = 0; i < packages.size(); ++i) {
            String next = (String)packages.get(i);
            builder.append(varName);
            builder.append(".importPackage(Packages.");
            builder.append(next);
            builder.append(");\n");
        }
        return builder.toString();
    }
}

