/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.model.KingdeeListModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.script.AbstractResourceImportUI;
import com.kingdee.eas.ep.client.script.IndexJars;
import com.kingdee.eas.ep.client.script.SearchClass;
import com.kingdee.eas.ep.client.script.SearchResult;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;

public class ResourceImportUI
extends AbstractResourceImportUI {
    private static final long serialVersionUID = 3636023804009805883L;
    private static final Logger logger = CoreUIObject.getLogger(ResourceImportUI.class);
    private int choice = 2;
    private List packages = new LinkedList();
    private List classNames = new LinkedList();
    private IndexCreator creator;
    private boolean readyForSearch;
    private int index = 0;

    public ResourceImportUI() throws Exception {
        this.initUIContentLayout();
        this.resultList.setCellRenderer((ListCellRenderer)((Object)new ResultListRender()));
        this.registListeners();
    }

    private void registListeners() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceImportUI.this.destroyWindow();
            }
        });
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceImportUI.this.confirm();
            }
        });
        Document document = this.conditionField.getDocument();
        document.addDocumentListener(new ConditionListener());
        this.resultList.addMouseListener((MouseListener)new ResultClickListener());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Set set = (Set)this.getUIContext().get("classNames");
        if (set != null && !set.isEmpty()) {
            this.classNames.addAll(set);
            this.conditionField.setText((String)this.classNames.get(0));
        } else {
            this.btnPrevious.setVisible(false);
            this.btnNext.setVisible(false);
        }
        this.resetBtn();
    }

    private void confirm() {
        this.next();
        this.choice = 0;
        this.destroyWindow();
    }

    @Override
    protected void btnPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.Previous();
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        this.next();
    }

    private void doSearch(String name) {
        this.initIndex();
        if (this.readyForSearch) {
            SearchResult results = SearchClass.search(name);
            KingdeeListModel model = (KingdeeListModel)this.resultList.getModel();
            model.removeAllElements();
            for (int i = 0; i < results.size(); ++i) {
                SearchResult.Element element = results.getElement(i);
                model.addElement((Object)element);
            }
        }
    }

    private void next() {
        SearchResult.Element element = (SearchResult.Element)this.resultList.getSelectedValue();
        if (element != null) {
            this.packages.add(this.index, element);
            if (this.index >= 0 && this.index < this.classNames.size() - 1) {
                ++this.index;
                this.conditionField.setText((String)this.classNames.get(this.index));
            }
            this.resetBtn();
        }
    }

    private void Previous() {
        if (this.index > 0 && this.index <= this.classNames.size() - 1) {
            --this.index;
            this.conditionField.setText((String)this.classNames.get(this.index));
            this.resetBtn();
        }
    }

    private void resetBtn() {
        this.btnPrevious.setEnabled(this.index > 0);
        this.btnNext.setEnabled(this.index < this.classNames.size() - 1);
    }

    public boolean isConfirm() {
        return this.choice == 0;
    }

    public List getResults() {
        return this.packages;
    }

    public void fireIndexCreating() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResourceImportUI.this.lbIndexstatus.setText("\u7d22\u5f15\u521b\u5efa\u4e2d , \u8bf7\u7a0d\u5019....");
            }
        });
    }

    public void fireIndexCreated() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResourceImportUI.this.lbIndexstatus.setText("\u7d22\u5f15\u521b\u5efa\u5b8c\u6bd5");
                String script = ResourceImportUI.this.conditionField.getText();
                if (!StringUtils.isEmpty((String)script)) {
                    ResourceImportUI.this.doSearch(script);
                }
                ResourceImportUI.this.lbIndexstatus.setText("");
            }
        });
    }

    private void initIndex() {
        if (!this.readyForSearch) {
            try {
                IndexReader reader = IndexReader.open((Directory)FSDirectory.open(new File("eas_index")), true);
                reader.close();
                this.readyForSearch = true;
            }
            catch (Exception e) {
                this.createIndex();
            }
        }
    }

    private void createIndex() {
        if (this.creator == null) {
            this.creator = new IndexCreator();
            this.creator.start();
        }
    }

    private class IndexCreator
    extends Thread {
        private IndexCreator() {
        }

        @Override
        public void run() {
            ResourceImportUI.this.fireIndexCreating();
            try {
                String eas_index = null;
                String lib = null;
                String eas_home = System.getProperty("EAS_HOME");
                if (!StringUtils.isEmpty((String)eas_home)) {
                    eas_index = eas_home + "/client/eas_index";
                    lib = eas_home + "/client/lib";
                } else {
                    eas_index = System.getProperty("eashome.path") + "/client/eas_index";
                    lib = System.getProperty("bim.class.path");
                }
                IndexJars.index(eas_index, lib);
                ResourceImportUI.this.readyForSearch = true;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            ResourceImportUI.this.fireIndexCreated();
        }
    }

    private class ResultListRender
    extends DefaultKingdeeListCellRenderer {
        private static final long serialVersionUID = -6619451947593706997L;

        private ResultListRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            SearchResult.Element element = (SearchResult.Element)value;
            String fullName = element.getName();
            if (!StringUtils.isEmpty((String)fullName)) {
                int position = fullName.lastIndexOf(".");
                if (position > 0) {
                    this.setText(fullName.substring(position + 1) + " - " + fullName.substring(0, position));
                } else {
                    this.setText(fullName);
                }
            }
            return ctrl;
        }
    }

    private class ResultClickListener
    extends MouseAdapter {
        private ResultClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchResult.Element element = (SearchResult.Element)ResourceImportUI.this.resultList.getSelectedValue();
            if (element != null) {
                ResourceImportUI.this.resultField.setText(element.toString());
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    if (ResourceImportUI.this.index >= ResourceImportUI.this.classNames.size() - 1) {
                        ResourceImportUI.this.confirm();
                    } else {
                        ResourceImportUI.this.next();
                    }
                }
            }
        }
    }

    private class ConditionListener
    implements DocumentListener {
        private ConditionListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String script = ResourceImportUI.this.conditionField.getText();
            ResourceImportUI.this.doSearch(script);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String script = ResourceImportUI.this.conditionField.getText();
            ResourceImportUI.this.doSearch(script);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String script = ResourceImportUI.this.conditionField.getText();
            ResourceImportUI.this.doSearch(script);
        }
    }
}

