/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.apache.log4j.Logger;
import org.fife.ep.ui.autocomplete.CompletionProviderBase;
import org.fife.ep.ui.autocomplete.ParameterizedCompletion;

public abstract class ScriptCompletionProvider
extends CompletionProviderBase {
    private String lastCompletionsAtText;
    private List lastParameterizedCompletionsAt;
    protected char lastInvalidChar = '\u0000';
    private static final Logger logger = Logger.getLogger(ScriptCompletionProvider.class);

    @Override
    protected List getCompletionsImpl(JTextComponent comp) {
        String text = this.getAlreadyEnteredText(comp);
        return this.getCompletionByInputTextNoException(comp, text);
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent comp) {
        Document doc = comp.getDocument();
        Segment seg = new Segment();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, seg);
        }
        catch (BadLocationException ble) {
            logger.error((Object)"ScriptCompletionProvider.getAlreadyEnteredText", (Throwable)ble);
            return "";
        }
        int segEnd = seg.offset + len;
        for (start = segEnd - 1; start >= seg.offset && this.isValidChar(seg.array[start]); --start) {
        }
        this.lastInvalidChar = '\u0000';
        if (start >= 0) {
            this.lastInvalidChar = seg.array[start];
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(seg.array, start, len);
    }

    protected boolean isValidChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    @Override
    public List getCompletionsAt(JTextComponent tc, Point p) {
        int offset = tc.viewToModel(p);
        if (offset < 0 || offset >= tc.getDocument().getLength()) {
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
        Segment s = new Segment();
        Document doc = tc.getDocument();
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element elem = root.getElement(line);
        int start = elem.getStartOffset();
        int end = elem.getEndOffset() - 1;
        try {
            int endOffs;
            int startOffs;
            doc.getText(start, end - start, s);
            for (startOffs = s.offset + (offset - start) - 1; startOffs >= s.offset && this.isValidChar(s.array[startOffs]); --startOffs) {
            }
            this.lastInvalidChar = '\u0000';
            if (startOffs >= 0) {
                this.lastInvalidChar = s.array[startOffs];
            }
            for (endOffs = s.offset + (offset - start); endOffs < s.offset + s.count && this.isValidChar(s.array[endOffs]); ++endOffs) {
            }
            int len = endOffs - startOffs - 1;
            if (len <= 0) {
                this.lastParameterizedCompletionsAt = null;
                return null;
            }
            String text = new String(s.array, startOffs + 1, len);
            if (text.equals(this.lastCompletionsAtText)) {
                return this.lastParameterizedCompletionsAt;
            }
            List list = this.getCompletionByInputTextNoException(tc, text);
            this.lastCompletionsAtText = text;
            this.lastParameterizedCompletionsAt = list;
            return this.lastParameterizedCompletionsAt;
        }
        catch (BadLocationException ble) {
            logger.error((Object)"ScriptCompletionProvider.getCompletionsAt", (Throwable)ble);
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
    }

    private List getCompletionByInputTextNoException(JTextComponent tc, String inputText) {
        try {
            return this.getCompletionByInputText(tc, inputText);
        }
        catch (Throwable t) {
            return new ArrayList();
        }
    }

    protected abstract List getCompletionByInputText(JTextComponent var1, String var2);

    @Override
    public List getParameterizedCompletions(JTextComponent tc) {
        int line;
        ArrayList list = null;
        char paramListStart = this.getParameterListStart();
        if (paramListStart == '\u0000') {
            return list;
        }
        int dot = tc.getCaretPosition();
        Segment s = new Segment();
        Document doc = tc.getDocument();
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(dot));
        int offs = elem.getStartOffset();
        int len = dot - offs - 1;
        if (len <= 0) {
            return list;
        }
        try {
            String text;
            List l;
            doc.getText(offs, len, s);
            for (offs = s.offset + len - 1; offs >= s.offset && Character.isWhitespace(s.array[offs]); --offs) {
            }
            int end = offs;
            while (offs >= s.offset && this.isValidChar(s.array[offs])) {
                --offs;
            }
            this.lastInvalidChar = '\u0000';
            if (offs >= 0) {
                this.lastInvalidChar = s.array[offs];
            }
            if ((l = this.getCompletionByInputTextNoException(tc, text = new String(s.array, offs + 1, end - offs))) != null && !l.isEmpty()) {
                for (int i = 0; i < l.size(); ++i) {
                    Object o = l.get(i);
                    if (!(o instanceof ParameterizedCompletion)) continue;
                    if (list == null) {
                        list = new ArrayList(1);
                    }
                    list.add(o);
                }
            }
        }
        catch (BadLocationException ble) {
            logger.error((Object)"ScriptCompletionProvider.getCompletionByInputText", (Throwable)ble);
        }
        return list;
    }
}

