/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import com.kingdee.eas.ep.client.script.ClassAnalyzer;
import com.kingdee.eas.ep.client.script.SearchResult;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.queryParser.ParseException;
import org.apache.lucene.ep.queryParser.QueryParser;
import org.apache.lucene.ep.search.IndexSearcher;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.ScoreDoc;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.TermQuery;
import org.apache.lucene.ep.search.TopScoreDocCollector;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.FSDirectory;
import org.apache.lucene.ep.util.Version;

public class SearchClass {
    private static Logger logger = Logger.getLogger(SearchClass.class);
    private static final String field = "contents";
    private static final String indexDir = "eas_index";

    public static SearchResult search(String txt) {
        SearchResult result = new SearchResult();
        if (StringUtils.isEmpty((String)txt)) {
            return result;
        }
        try {
            IndexReader reader = IndexReader.open((Directory)FSDirectory.open(new File(indexDir)), true);
            IndexSearcher searcher = new IndexSearcher(reader);
            ClassAnalyzer analyzer = new ClassAnalyzer();
            Query query = null;
            if (txt.indexOf(46) > 0) {
                query = new TermQuery(new Term(field, txt));
            } else {
                QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, field, analyzer);
                query = parser.parse(txt);
            }
            int DISPLAY_NUM = 500;
            TopScoreDocCollector collector = TopScoreDocCollector.create(500, false);
            searcher.search(query, collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            int numTotalHits = collector.getTotalHits();
            int size = numTotalHits > 500 ? 500 : numTotalHits;
            for (int i = 0; i < size; ++i) {
                Document doc = ((Searcher)searcher).doc(hits[i].doc);
                String path = doc.get("path");
                String name = doc.get("name");
                if (path == null || name == null) continue;
                result.addElement(new SearchResult.Element(path, name));
            }
            reader.close();
        }
        catch (IOException e) {
            logger.info((Object)"Index read Error,please confirm if the directory exists:eas_index");
        }
        catch (ParseException e) {
            logger.info((Object)("Parse query error:" + txt));
        }
        return result;
    }

    public static void search() throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        block0: while (true) {
            logger.info((Object)"Enter query: ");
            String line = in.readLine();
            if (line == null || line.length() == -1 || (line = line.trim()).length() == 0) break;
            SearchResult result = SearchClass.search(line);
            logger.info((Object)(result.size() + " total matching documents"));
            int i = 0;
            while (true) {
                if (i >= result.size()) continue block0;
                logger.info((Object)(i + 1 + ". " + result.getElement(i)));
                ++i;
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        SearchClass.search();
    }
}

