/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.script;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.ep.analysis.Tokenizer;
import org.apache.lucene.ep.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.ep.analysis.tokenattributes.TermAttribute;

public final class SubStringTokenizer
extends Tokenizer {
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int IO_BUFFER_SIZE = 512;
    private final char[] ioBuffer = new char[512];
    private String name = null;
    private int nameLen = 0;
    private boolean isPack = true;
    private String packName = null;

    public SubStringTokenizer(Reader input) {
        super(input);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    @Override
    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.dataLen <= 0) {
            this.dataLen = this.input.read(this.ioBuffer);
            this.name = new String(this.ioBuffer);
            this.name = this.name.trim();
            if (this.name.endsWith(".class")) {
                this.name = this.name.substring(0, this.name.lastIndexOf("."));
                this.packName = this.name.substring(0, this.name.lastIndexOf(".") + 1);
                this.name = this.name.substring(this.name.lastIndexOf(".") + 1);
            }
            this.nameLen = this.name.length();
        }
        if (this.dataLen <= 0 || this.bufferIndex >= this.nameLen) {
            return false;
        }
        this.offset = this.nameLen;
        if (this.packName != null) {
            this.offset = this.packName.length() + this.nameLen;
        }
        int start = this.bufferIndex;
        String term = null;
        int termLength = 0;
        if (this.packName != null && this.isPack) {
            term = this.packName + this.name.substring(0, this.bufferIndex);
            termLength = this.packName.length() + this.bufferIndex;
        } else {
            ++this.bufferIndex;
            term = this.name.substring(0, this.bufferIndex);
            termLength = this.bufferIndex;
        }
        this.termAtt.setTermBuffer(term);
        this.termAtt.setTermLength(termLength);
        this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(this.bufferIndex));
        this.isPack = !this.isPack;
        return true;
    }

    @Override
    public final void end() {
        int finalOffset = this.correctOffset(this.offset);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    @Override
    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
        this.nameLen = 0;
        this.isPack = true;
    }
}

